#include <string.h>
#include "k_stdtype.h"
#include "rtc.h"
#include "daylight.h"

void rtcUTCtoLocalTime(TimeDate *ptr, sint8 timeZone, uint8 useDayLightSaving) {
	if (ptr != NULL) {
		//Substracting timezone
		uint16 i = 0;
		uint16 cnt = 0;
		uint8 decrementTime = 0;
		if (timeZone > 0) {
			decrementTime = 1;
			cnt = timeZone;
		} else if (timeZone < 0) {
			decrementTime = 0;
			cnt = -timeZone;
		}
		for (i = 0; i < cnt; i++) {
			if (decrementTime) {
				inc_hour(ptr);
			} else {
				dec_hour(ptr);
			}
		}
		if (useDayLightSaving) {
			//Substracting daylight saving
			if (isDaylightSavings(ptr->year, ptr->month, ptr->day, ptr->hour, ptr->min, ptr->sec) == DayLightGui_Summer) {
				inc_hour(ptr);
			}
		}
	}
}

void rtcLocalTimeToUTC(TimeDate *ptr, sint8 timeZone, uint8 useDayLightSaving) {
	if (ptr != NULL) {
		//Substracting timezone
		uint16 i = 0;
		uint16 cnt = 0;
		uint8 decrementTime = 0;
		if (timeZone > 0) {
			decrementTime = 1;
			cnt = timeZone;
		} else if (timeZone < 0) {
			decrementTime = 0;
			cnt = -timeZone;
		}
		for (i = 0; i < cnt; i++) {
			if (decrementTime) {
				dec_hour(ptr);
			} else {
				inc_hour(ptr);
			}
		}
		if (useDayLightSaving) {
			//Substracting daylight saving
			if (isDaylightSavings(ptr->year, ptr->month, ptr->day, ptr->hour, ptr->min, ptr->sec) == DayLightGui_Summer) {
				dec_hour(ptr);
			}
		}
	}
}
