#ifndef H__RIJNDAEL
#define H__RIJNDAEL

#include "k_stdtype.h"

typedef uint8 u8;
typedef uint32 u32;


#define KEYLENGTH(keybits) ((keybits)/8)
#define RKLENGTH(keybits)  ((keybits)/8+28)
#define NROUNDS(keybits)   ((keybits)/32+6)

extern int rijndaelSetupEncrypt(u32 *rk, const u8 *key, int keybits);
extern int rijndaelSetupDecrypt(u32 *rk, const u8 *key, int keybits);
extern void rijndaelEncrypt(const u32 *rk, int nrounds, const u8 plaintext[16], u8 ciphertext[16]);
extern void rijndaelDecrypt(const u32 *rk, int nrounds, const u8 ciphertext[16], u8 plaintext[16]);

#endif
