#ifndef _DS1307_H_
#define _DS1307_H_

#include "iic_master.h"
#include "rtc.h"

typedef enum _DS1307_AMPM {
	DS1307_AM,
	DS1307_PM,
	DS1307_NOTUSED
} DS1307_AMPM;

typedef struct _DS1307_Time {
	unsigned char sec;
	unsigned char min;
	unsigned char hour;
	unsigned char day;
	unsigned char month;
	unsigned int year;
	unsigned char dayOfWeek;
	DS1307_AMPM AMPM;
} DS1307_Time;

extern void ds1307_startOsscilator(void);
extern void ds1307_stopOsscilator(void);
extern int ds1307_writeTime(DS1307_Time *time);
extern int ds1307_readTime(DS1307_Time *time);
extern int ds1307_writeControlRegister(unsigned char value);

extern void ds1307_convertToDs1307Format(TimeDate *ptrFrom, DS1307_Time *ptrTo);
extern void ds1307_convertToTimeDateFormat(DS1307_Time *ptrFrom, TimeDate *ptrTo);

#endif
