/*
***********************************************************************************************
*						SHT1x digital temperature and humidity sensor Driver
*										All Rights Reserved
* File name		: SHT1x.c
* Programmer 	: John Leung, TechToys Co. Hong Kong
* Web presence  : www.TechToys.com.hk
* Note			: 
* Language		: C30 complier version 2.40, MPLAB v8.14
* Hardware		: PIC24LF128
* Date			: 11 Oct 2006			Version 1.0 

***********************************************************************************************
*										DESCRIPTION
*
* This module provides an interface to Sensirion SHT10 digital temperature & humidity sensor
*
* pinout function summarized as below
* ---SHT1x			MCU -----------------
* DATA - data		RB2
* SCK  - clock		RB0
***********************************************************************************************
*/

#ifndef SHT1X_H
#define SHT1X_H
/*
***********************************************************************************************
*										PORT DEFINITION
***********************************************************************************************
*/

/*
***********************************************************************************************
*										GLOBAL CONSTANTS
***********************************************************************************************
*/

extern float humi_val; //Variable is intended for SIO usage
extern float temp_val;
extern float dew_val;

extern float getSHTTemp(void);
extern float getSHTHumi(void);
extern float getSHTDew(void);

#endif
