#include <string.h>
#include "aes_helper.h"
#include "rijndael.h"
#include "k_stdtype.h"

#define KEYBITS 128

uint32 tempGlobalTime = 0;
u32 rk_en[RKLENGTH(KEYBITS)];
u32 rk_de[RKLENGTH(KEYBITS)];
u8 key_en[KEYLENGTH(KEYBITS)] = "asdf123asdf123as";
int keybits_en = KEYBITS;
int result_en = 0;
int nrounds_en = 1;
int nrounds_de = 1;
//unsigned char plaintext_en[16] = "Hello World!";
//unsigned char ciphertext_en[16];
unsigned char plaintext_de[16];

int aes_deencrypt(unsigned char *dataIn, unsigned int sizeIn, unsigned char *dataOut, unsigned int *sizeOut, unsigned char enDeCrypt);
int aes_overlap_deencrypt(unsigned char *data, unsigned int size, unsigned char *helperBuffer, unsigned char enDeCrypt);

void init_aes_helper(void) {
	nrounds_en = rijndaelSetupEncrypt(rk_en, key_en, keybits_en);
	nrounds_de = rijndaelSetupDecrypt(rk_de, key_en, keybits_en);
	memset(plaintext_de, 0x00, sizeof(plaintext_de) / sizeof(*plaintext_de));
}

void aes_getSeed(unsigned char *seed, unsigned char len) {
	if (len == 16) {
		memset(seed, 0x00, len);
		tempGlobalTime ++;
		seed[0] = tempGlobalTime;
		seed[1] = tempGlobalTime >> 8;
		seed[2] = tempGlobalTime >> 16;
		seed[3] = tempGlobalTime >> 24;
	}
}

int aes_checkKey(unsigned char *key, unsigned char len) {
	int result = -1;
	if (len == 16) {
		result = 0;
		rijndaelDecrypt(rk_de, nrounds_de, key, plaintext_de);
		if (plaintext_de[0] == (tempGlobalTime & 0xFF)) {
			result = 1;
		}
	}
	return result;
}

int aes_block_encrypt(unsigned char *dataIn, unsigned char *dataOut, unsigned char size) {
	int result = -1;
	if ((dataIn != NULL) && (dataOut != NULL)) {
		if (size == 16) {
			rijndaelEncrypt(rk_en, nrounds_en, dataIn, dataOut);
			result = 1;
		}
	}
	return result;
}

int aes_block_decrypt(unsigned char *dataIn, unsigned char *dataOut, unsigned char size) {
	int result = -1;
	if ((dataIn != NULL) && (dataOut != NULL)) {
		if (size == 16) {
			rijndaelDecrypt(rk_de, nrounds_de, dataIn, dataOut);
			result = 1;
		}
	}
	return result;
}

int aes_encrypt(unsigned char *dataIn, unsigned int sizeIn, unsigned char *dataOut, unsigned int *sizeOut) {
	return aes_deencrypt(dataIn, sizeIn, dataOut, sizeOut, 0x01);
}

int aes_decrypt(unsigned char *dataIn, unsigned int sizeIn, unsigned char *dataOut, unsigned int *sizeOut) {
	return aes_deencrypt(dataIn, sizeIn, dataOut, sizeOut, 0x00);
}

int aes_deencrypt(unsigned char *dataIn, unsigned int sizeIn, unsigned char *dataOut, unsigned int *sizeOut, unsigned char enDeCrypt) {
	int result = -1;
	if ((dataIn != NULL) && (dataOut != NULL) && (sizeOut != NULL)) {
		if (sizeIn != 0) {
			unsigned int x = 0;
			result = 1;
			*sizeOut = 0;
			for (x = 0; x < sizeIn; x += 16) {
				if (sizeIn < (x + 16)) {
					memset(plaintext_de, 0xAA, sizeof(plaintext_de) / sizeof(*plaintext_de));
					memcpy(plaintext_de, dataIn + x, sizeIn - x);
					if (enDeCrypt) {
						aes_block_encrypt(plaintext_de, dataOut + x, 16);
					} else {
						aes_block_decrypt(plaintext_de, dataOut + x, 16);
					}
				} else {
					if (enDeCrypt) {
						aes_block_encrypt(dataIn + x, dataOut + x, 16);
					} else {
						aes_block_decrypt(dataIn + x, dataOut + x, 16);
					}
				}
				*sizeOut += 16;
			}
		}
	}
	return result;
}

int aes_overlap_encrypt(unsigned char *data, unsigned int size, unsigned char *helperBuffer) {
	return aes_overlap_deencrypt(data, size, helperBuffer, 0x01);
}

int aes_overlap_decrypt(unsigned char *data, unsigned int size, unsigned char *helperBuffer) {
	return aes_overlap_deencrypt(data, size, helperBuffer, 0x00);
}

int aes_overlap_deencrypt(unsigned char *data, unsigned int size, unsigned char *helperBuffer, unsigned char enDeCrypt) {
	int result = -1;
	if ((data != NULL) && (helperBuffer != NULL)) {
		if ((size != 0) && ((size % 16) == 0)) {
			unsigned int x = 0;
			for (x = 0; x < size; x += 16) {
				memcpy(helperBuffer, data + x, 16);
				if (enDeCrypt) {
					aes_block_encrypt(helperBuffer, data + x, 16);
				} else {
					aes_block_decrypt(helperBuffer, data + x, 16);
				}
			}
		}
	}
	return result;
}
