#include <string.h>
#include "ds1307.h"
#include "c_ds1307.h"
#include "i_ds1307.h"
#include "w_ds1307.h"
#include "int_ds1307.h"

#include "iic_master.h"

#define HOUR12MODE 0x40
#define HOUR24MODE 0x00
#define AMTIME 0x00
#define PMTIME 0x20

unsigned char osscilatorBit = 0x00;

void init_ds1307(void) {
}

void do_ds1307(void) {
}

void isr_ds1307_1ms(void) {
}

void ds1307_startOsscilator(void) {
	osscilatorBit = 0x00;
	//Bit 7 of Register 0 is the clock halt (CH) bit. When this bit is set to 1, the oscillator is disabled. When cleared to 0, the oscillator is enabled.
	//CH bit to 0
}

void ds1307_stopOsscilator(void) {
	osscilatorBit = 0x80;
	//Bit 7 of Register 0 is the clock halt (CH) bit. When this bit is set to 1, the oscillator is disabled. When cleared to 0, the oscillator is enabled.
	//CH bit to 1
}

int ds1307_writeTime(DS1307_Time *time) {
	int result = NACK;
	if (time != NULL) {
		#ifdef DS1307_IN_PCF8563_MODE
			unsigned char wordAddress = 2;
		#else
			unsigned char wordAddress = 0;
		#endif
		unsigned char dataTemp[7];
		unsigned char length = 7;

		#ifdef DS1307_IN_PCF8563_MODE
			dataTemp[0] = (ds1307_INT2BCD(time->sec) & 0x7F);
			dataTemp[1] = ds1307_INT2BCD(time->min) & 0x7F;
			switch (time->AMPM) {
				case DS1307_AM : {
					dataTemp[2] = (ds1307_INT2BCD(time->hour) & 0x1F);
					break;
				}
				case DS1307_PM : {
					dataTemp[2] = (ds1307_INT2BCD(time->hour + 12) & 0x1F) ;
					break;
				}
				case DS1307_NOTUSED :
				default : {
					dataTemp[2] = (ds1307_INT2BCD(time->hour) & 0x3F);
					break;
				}
			}
			dataTemp[3] = ds1307_INT2BCD(time->day) & 0x3F;
			dataTemp[4] = ds1307_INT2BCD(time->dayOfWeek + 1) & 0x07;
			dataTemp[5] = ds1307_INT2BCD(time->month) & 0x1F;
			{
				unsigned char yearTemp = (time->year - 2000) % 100;
				dataTemp[6] = ds1307_INT2BCD(yearTemp) & 0xFF;
			}
		#else
			dataTemp[0] = (ds1307_INT2BCD(time->sec) & 0x7F) & osscilatorBit;
			dataTemp[1] = ds1307_INT2BCD(time->min) & 0x7F;
			switch (time->AMPM) {
				case DS1307_AM : {
					dataTemp[2] = (ds1307_INT2BCD(time->hour) & 0x1F) | HOUR12MODE | AMTIME;
					break;
				}
				case DS1307_PM : {
					dataTemp[2] = (ds1307_INT2BCD(time->hour) & 0x1F) | HOUR12MODE | PMTIME;
					break;
				}
				case DS1307_NOTUSED :
				default : {
					dataTemp[2] = (ds1307_INT2BCD(time->hour) & 0x3F) | HOUR24MODE;
					break;
				}
			}
			dataTemp[3] = ds1307_INT2BCD(time->dayOfWeek) & 0x07;
			dataTemp[4] = ds1307_INT2BCD(time->day) & 0x3F;
			dataTemp[5] = ds1307_INT2BCD(time->month) & 0x1F;
			{
				unsigned char yearTemp = (time->year - 2000) % 100;
				dataTemp[6] = ds1307_INT2BCD(yearTemp) & 0xFF;
			}
		#endif
		result = ds1307_write(wordAddress, dataTemp, length);
	}
	return result;
}

int ds1307_readTime(DS1307_Time *time) {
	int result = NACK;
	if (time != NULL) {
		unsigned char dataTemp[7];
		#ifdef DS1307_IN_PCF8563_MODE
			unsigned char wordAddress = 2;
		#else
			unsigned char wordAddress = 0;
		#endif
		unsigned char length = 7;
		result = ds1307_read(wordAddress, dataTemp , length);
		if (result != NACK) {
			#ifdef DS1307_IN_PCF8563_MODE
				time->sec = ds1307_BCD2INT(dataTemp[0] & 0x7F);
				time->min = ds1307_BCD2INT(dataTemp[1] & 0x7F);
				//24hmode
				time->AMPM = DS1307_NOTUSED;
				time->hour = ds1307_BCD2INT(dataTemp[2] & 0x3F);
				
				time->day = ds1307_BCD2INT(dataTemp[3] & 0x3F);
				time->dayOfWeek = ds1307_BCD2INT(dataTemp[4] & 0x07) - 1;
				time->month = ds1307_BCD2INT(dataTemp[5] & 0x1F);
				time->year = ds1307_BCD2INT(dataTemp[6]) + 2000;
			#else
				time->sec = ds1307_BCD2INT(dataTemp[0] & 0x7F);
				time->min = ds1307_BCD2INT(dataTemp[1] & 0x7F);
				if (dataTemp[2] & HOUR12MODE) {
					//12hmode
					if (dataTemp[2] & PMTIME) {
						time->AMPM = DS1307_PM;
					} else {
						time->AMPM = DS1307_AM;
					}
					time->hour = ds1307_BCD2INT(dataTemp[2] & 0x1F);
				} else {
					//24hmode
					time->AMPM = DS1307_NOTUSED;
					time->hour = ds1307_BCD2INT(dataTemp[2] & 0x3F);
				}
				time->dayOfWeek = ds1307_BCD2INT(dataTemp[3] & 0x07);
				time->day = ds1307_BCD2INT(dataTemp[4] & 0x3F);
				time->month = ds1307_BCD2INT(dataTemp[5] & 0x1F);
				time->year = ds1307_BCD2INT(dataTemp[6]) + 2000;
			#endif
		}
	}
	return result;
}

int ds1307_writeControlRegister(unsigned char value) {
	int result = NACK;
	unsigned char wordAddress = 0x07;
	unsigned char dataTemp = value;
	unsigned char length = 1;
	result = ds1307_write(wordAddress, &dataTemp, length);
	return result;
}
