#include "led.h"
#include "i_led.h"
#include "w_led.h"
#include "c_led.h"

#include "k_stdtype.h"
#include "mal.h"
#include "io_states.h"
#include "task.h"

unsigned char doBlinkWarningLED = 0;
unsigned char doBlinkNormalLED = 0;

void do_toggleLED(void);

void init_led(void) {
	LEDA = 0;
	LEDB = 0;
	LEDC = 0;
	LEDA_TRIS = OUT;
	LEDB_TRIS = OUT;
	LEDB_TRIS = OUT;
	addTask(do_toggleLED, 500, 1, "do_toggleLED");
}

void do_led(void) {
}

void do_toggleLED(void) {
	if (doBlinkNormalLED) {
		LEDA = !LEDA;
	}
	if (doBlinkWarningLED) {
		LEDB = !LEDB;
	}
}

void isr_led1ms(void) {
}

void setWarningLED(void) {
	LEDB = 1;
}

void clearWarningLED(void) {
	LEDB = 0;
}

void setErrorLED(void) {
	LEDC = 1;
}

void clearErrorLED(void) {
	LEDC = 0;
}

void blinkWarningLED(void) {
	doBlinkWarningLED = 1;
}

void stopBlinkWarningLED(void) {
	doBlinkWarningLED = 0;
}

void setNormalLED(void) {
	LEDA = 1;
}

void clearNormalLED(void) {
	LEDA = 0;
}

void blinkNormalLED(void) {
	doBlinkNormalLED = 1;
}

void stopBlinkNormalLED(void) {
	doBlinkNormalLED = 0;
}
