#include "global.h"
#include "mal.h"
#include "c_isr.h"
#include "i_sio.h"
#include "w_sio.h"

void __ISR(_TIMER_1_VECTOR, IPL2SOFT) Timer1Handler(void) {
    mT1ClearIntFlag();
	#ifdef ISR_USE_TMR1
		isr_tmr1();
	#endif
} 

void __ISR(_TIMER_2_VECTOR, IPL2SOFT) Timer2Handler(void) {
    mT2ClearIntFlag();
	#ifdef ISR_USE_TMR2
		isr_tmr2();
	#endif
}

void __ISR(_SPI_2_VECTOR, IPL3SOFT)__SPI2Interrupt(void) {
	#ifdef ISR_USE_SPI1
		ISR_FNC_SPI1();
	#endif
	#ifdef ISR_USE_SPI2_WIFI
		isr_spi_wifi();
	#endif
}

void __ISR(_TIMER_4_VECTOR, IPL2SOFT) Timer4Handler(void) {
    mT4ClearIntFlag();
	#ifdef ISR_USE_TMR4
		isr_t4();
	#endif
	#ifdef ISR_USE_TMR4_CUSTOM
		isr_appCustom();
	#endif
}

void __ISR(_EXTERNAL_3_VECTOR, IPL13SOFT)__EINT3Interrupt(void) {
	#ifdef ISR_USE_EINT3_WIFI
		isr_eint_wifi();
	#endif
}

void __ISR(_DMA1_VECTOR, ipl5) DmaHandler1(void) {
	#ifdef ISR_USE_DMA1
		isr_dma1();
	#endif
} 

void __ISR(_DMA2_VECTOR, ipl6) DmaHandler2(void) {
	#ifdef ISR_USE_DMA2
		isr_dma2();
	#endif
}

void __ISR(_UART1_VECTOR, IPL2SOFT) IntUart1Handler(void) {
	if (INTGetFlag(INT_SOURCE_UART_RX(UART1)) && INTGetEnable(INT_SOURCE_UART_RX(UART1)) ) {
		INTClearFlag(INT_SOURCE_UART_RX(UART1));
		#ifdef ISR_USE_UART1
			isrSerialRx_usart1(UARTGetDataByte(UART1));
		#endif
		#ifdef ISR_USE_UART1_SIO
			isr_communication();
		#endif
	}
	if ( INTGetFlag(INT_SOURCE_UART_TX(UART1)) && INTGetEnable(INT_SOURCE_UART_TX(UART1)) ) {
		//INTClearFlag(INT_SOURCE_UART_TX(UART1)); //must not be cleared
		#ifdef ISR_USE_UART1
			isrSerialTx_usart1();
		#endif
	}
	if ( INTGetFlag(INT_SOURCE_UART_ERROR(UART1)) && INTGetEnable(INT_SOURCE_UART_ERROR(UART1)) ) {
		INTClearFlag(INT_SOURCE_UART_ERROR(UART1));
		#ifdef ISR_USE_UART1
			isrSerialError_usart1();
		#endif
	}
}

void __ISR(_UART2_VECTOR, IPL7SOFT) IntUart2Handler(void) {
	if (INTGetFlag(INT_SOURCE_UART_RX(UART2)) && INTGetEnable(INT_SOURCE_UART_RX(UART2)) ) {
		INTClearFlag(INT_SOURCE_UART_RX(UART2));
		#ifdef ISR_USE_UART2
			isrSerialRx_usart2(UARTGetDataByte(UART2));
		#endif
		#ifdef ISR_USE_UART2_SIO
			isr_communication();
		#endif
	}
	if ( INTGetFlag(INT_SOURCE_UART_TX(UART2)) && INTGetEnable(INT_SOURCE_UART_TX(UART2)) ) {
		 //INTClearFlag(INT_SOURCE_UART_TX(UART2)); //must not be cleared
		#ifdef ISR_USE_UART2
			isrSerialTx_usart2();
		#endif
	}
	if ( INTGetFlag(INT_SOURCE_UART_ERROR(UART2)) && INTGetEnable(INT_SOURCE_UART_ERROR(UART2)) ) {
		 INTClearFlag(INT_SOURCE_UART_ERROR(UART2));
		#ifdef ISR_USE_UART2
			isrSerialError_usart2();
		#endif
	}
}
void __ISR(_CORE_TIMER_VECTOR, IPL2SOFT) CoreTimerHandler(void) {
    // clear the interrupt flag
    mCTClearIntFlag(); 
}

/*void __attribute__((naked, nomips16,noreturn,unique_section)) _DefaultInterrupt (void) {
	volatile char exitLoop = 0;
	while (!exitLoop) {
		volatile int catcherTemp = 0;
		catcherTemp++;
		catcherTemp++;
		catcherTemp++;
		catcherTemp++;
	}
}*/

void init_isr(void) {
	//INTEnableSystemMultiVectoredInt();
	INTConfigureSystem(INT_SYSTEM_CONFIG_MULT_VECTOR);
	INTEnableInterrupts();
}
