#include "nrf24l01.h"
#include "c_nrf24l01.h"
#include "i_nrf24l01.h"
#include "w_nrf24l01.h"
#include "int_nrf24l01.h"
#include "nrf24l01_low.h"
#include "nrf24l01_medium.h"
#include "nrf24l01_nrf_radio.h"
#include "nrf24l01_radio.h"

#include "ringBuffer.h"

RingBuffer myRingBuffer_nrfradio_tx;
unsigned char nrfradio_tx[RADIO_TX_LEN];
RingBuffer myRingBuffer_nrfradio_rx;
unsigned char nrfradio_rx[RADIO_RX_LEN];
unsigned long missedTxCharNrfRadio = 0;
unsigned long missedRxCharNrfRadio = 0;

void init_nrf24l01_nrfradio(void) {
	ringBuffer_initBuffer(&myRingBuffer_nrfradio_tx, nrfradio_tx, sizeof(nrfradio_tx) / sizeof(*nrfradio_tx));
	ringBuffer_initBuffer(&myRingBuffer_nrfradio_rx, nrfradio_rx, sizeof(nrfradio_rx) / sizeof(*nrfradio_rx));
}

unsigned int isCharInBufferNrfRadio(void) {
	unsigned int result = 0;
	result = ringBuffer_getFillness(&myRingBuffer_nrfradio_rx);
	return result;
}

int getCharNrfRadio(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_nrfradio_rx, &data) != 0) {
		result = data;
	}
	return result;
}

void putCharNrfRadio(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_nrfradio_tx, data) != -1) {
		scheduleTask(doNrf24L01HandlerTaskNr);
	} else {
		missedTxCharNrfRadio++;
	}
}

void flushNrfRadio(void) {
}

unsigned int isCharInBufferNrfRadioTx(void) {
	unsigned int result = 0;
	result = ringBuffer_getFillness(&myRingBuffer_nrfradio_tx);
	return result;
}

int getCharNrfRadioTx(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_nrfradio_tx, &data) != 0) {
		result = data;
	}
	return result;
}

void putCharNrfRadioRx(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_nrfradio_rx, data) != -1) {
		scheduleTask(doNrf24L01HandlerTaskNr);
	} else {
		missedTxCharNrfRadio++;
	}
}
