#include "nrf24l01.h"
#include "c_nrf24l01.h"
#include "i_nrf24l01.h"
#include "w_nrf24l01.h"
#include "int_nrf24l01.h"
#include "nrf24l01_low.h"
#include "nrf24l01_medium.h"
#include "nrf24l01_radio.h"

#include "ringBuffer.h"

RingBuffer myRingBuffer_radio_tx;
unsigned char radio_tx[RADIO_TX_LEN];
RingBuffer myRingBuffer_radio_rx;
unsigned char radio_rx[RADIO_RX_LEN];
unsigned long missedTxCharRadio = 0;
unsigned long missedRxCharRadio = 0;

void init_nrf24l01_radio(void) {
	ringBuffer_initBuffer(&myRingBuffer_radio_tx, radio_tx, sizeof(radio_tx) / sizeof(*radio_tx));
	ringBuffer_initBuffer(&myRingBuffer_radio_rx, radio_rx, sizeof(radio_rx) / sizeof(*radio_rx));
}

unsigned int isCharInBufferRadio(void) {
	unsigned int result = 0;
	result = ringBuffer_getFillness(&myRingBuffer_radio_rx);
	return result;
}

int getCharRadio(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_radio_rx, &data) != 0) {
		result = data;
	}
	return result;
}

void putCharRadio(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_radio_tx, data) != -1) {
		scheduleTask(doNrf24L01HandlerTaskNr);
	} else {
		missedTxCharRadio++;
	}
}

void flushRadio(void) {
}

unsigned int isCharInBufferRadioTx(void) {
	unsigned int result = 0;
	result = ringBuffer_getFillness(&myRingBuffer_radio_tx);
	return result;
}

int getCharRadioTx(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_radio_tx, &data) != 0) {
		result = data;
	}
	return result;
}

void putCharRadioRx(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_radio_rx, data) != -1) {
		scheduleTask(doNrf24L01HandlerTaskNr);
	} else {
		missedTxCharRadio++;
	}
}
