#include <string.h>
#include "rtc.h"
#include "i_rtc.h"
#include "w_rtc.h"

#define MONTH_MIN 1
#define MONTH_MAX 12
#define MONTH_LEAP 0

unsigned char do_sec1s = 0;
TimeDate timeDate = {0,42,19,2,1,2009,0,0};
const unsigned char day_in_month [13] = {29,31,28,31,30,31,30,31,31,30,31,30,31};

static unsigned int isDateValid(TimeDate *ptr);

void isr_rtc_1ms(void) {
	static unsigned int rtc1sCnt = 0;
	rtc1sCnt ++;
	if (rtc1sCnt >= 1000) {
		rtc1sCnt = 0;
		do_sec1s = 1;
	}
}

void isr_rtc_1s(void) {
	do_sec1s = 1;
}

unsigned char is_leap_year (unsigned int year) {
	unsigned char result = 0;
	if ((year % 400) == 0) {
		result = 1;
	} else {
		if ((year % 100) == 0) {
			result = 0;
		} else {
			if ((year % 4) == 0) {
				result = 1;
			} else {
				result = 0;
			}
		}
	}
	return result;
}

unsigned char get_day_in_month (unsigned int year, unsigned int month) {
	unsigned char result = 1;
	if ((month >= MONTH_MIN) && (month <= MONTH_MAX)) {
		if ((month == 2) && (is_leap_year(year) == 1)) {
			result = day_in_month[MONTH_LEAP];
		} else {
			result = day_in_month[month];
		}
	}
	return result;
}

void calendar(TimeDate *ptr) {
	if (ptr != NULL) {
		unsigned int x_year = 1900;
		unsigned int y_month = 1;

		if (ptr->year >= 2000) {
			ptr->dofw_calendar = 5;//first day of year 2000 Szombat
			for (x_year = 2000; x_year < ptr->year; x_year++) {
				for (y_month = 1; y_month <= 12; y_month ++) {
					ptr->dofw_calendar += get_day_in_month(x_year, y_month);
					ptr->dofw_calendar %= 7;
				}
			}
		}
		rtcCalculateWeekAndDay(ptr);
	}
}

void init_rtc(void) {
	TimeDate timeDate;
	timeDate.sec = 0;
	timeDate.min = 41;
	timeDate.hour = 18;
	timeDate.day = 10;
	timeDate.month = 1;
	timeDate.year = 2011;
	rtcSetTimeDate(&timeDate);
}

void do_rtc(void) {
	if (do_sec1s == 1) {
		do_sec1s = 0;
		//inc_sec(&timeDate);
		timeDate.sec++;
		if (timeDate.sec >= 60) {
			timeDate.sec = 0;
			timeDate.min++;
			if (timeDate.min >= 60) {
				timeDate.min = 0;
				timeDate.hour ++;
				if (timeDate.hour >= 24) {
					timeDate.hour = 0;
					timeDate.day++;
					if ((get_day_in_month(timeDate.year, timeDate.month) + 1) <= timeDate.day) {
						timeDate.day = 1;
						timeDate.month++;
						if (timeDate.month > 12) {
							timeDate.month = 1;
							timeDate.year ++;
						}
					}
					calendar(&timeDate);
				}
			}
		}
	}
}

unsigned int rtcGetTimeDate(TimeDate *ptr) {
	unsigned int result = 0;
	if (ptr != NULL) {
		*ptr = timeDate;
		result = 1;
	}
	return result;
}

unsigned int rtcSetTimeDate(TimeDate *ptr) {
	unsigned int result = 0;
	if (ptr != NULL) {
		if (isDateValid(ptr) != 0) {
			timeDate = *ptr;
			calendar(&timeDate);
			result = 1;
		}
	}
	return result;
}

static unsigned int isDateValid(TimeDate *ptr) {
	unsigned int result = 0;
	if (ptr != NULL) {
		if ((ptr->sec < 60) && (ptr->sec >= 0)) {
			if ((ptr->min < 60) && (ptr->min >= 0)) {
				if ((ptr->hour < 24) && (ptr->hour >= 0)) {
					if ((ptr->month <= 12) && (ptr->month >= 0)) {
						if ((ptr->day <= get_day_in_month(ptr->year, ptr->month)) && (ptr->day >= 0)) {
							result = 1;
						}
					}
				}
			}
		}
	}
	return result;
}

void inc_year(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->year ++;
		calendar(ptr);
	}
}

void dec_year(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->year --;
		calendar(ptr);
	}
}

void inc_month(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->month++;
		if (ptr->month > 12) {
			ptr->month = 1;
			inc_year(ptr);
		} else {
			calendar(ptr);
		}
	}
}

void dec_month(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->month--;
		if (ptr->month < 1) {
			dec_year(ptr);
			ptr->month = 12;
		} else {
			calendar(ptr);
		}
	}
}


void inc_day(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->day++;
		if (ptr->day >= (get_day_in_month(ptr->year, ptr->month)+1)) {
			ptr->day = 1;
			inc_month(ptr);
		} else {
			calendar(ptr);
		}
	}
}

void dec_day(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->day--;
		if (ptr->day < 1) {
			dec_month(ptr);
			ptr->day = get_day_in_month(ptr->year, ptr->month);
		} else {
			calendar(ptr);
		}
	}
}

void inc_hour(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->hour++;
		if (ptr->hour >= 24) {
			ptr->hour = 0;
			inc_day(ptr);
		}
	}
}

void dec_hour(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->hour--;
		if (ptr->hour < 0) {
			ptr->hour = 23;
			dec_day(ptr);
		}
	}
}

void inc_min(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->min++;
		if (ptr->min >= 60) {
			ptr->min = 0;
			inc_hour(ptr);
		}
	}
}

void dec_min(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->min--;
		if (ptr->min < 0) {
			ptr->min = 59;
			dec_hour(ptr);
		}
	}
}

void inc_sec(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->sec++;
		if (ptr->sec >= 60) {
			ptr->sec = 0;
			inc_min(ptr);
		}
	}
}

void dec_sec(TimeDate *ptr) {
	if (ptr != NULL) {
		ptr->sec--;
		if (ptr->sec < 0) {
			ptr->sec = 59;
			dec_min(ptr);
		}
	}
}

void rtcCalculateWeekAndDay(TimeDate *ptr) {
	if (ptr != NULL) {
		unsigned char i = 0;
		ptr->week_calendar = 0;
		if (ptr->dofw_calendar < 3) {
			ptr->week_calendar ++;
		}

		for (i = 1; i < ptr->month; i++) {
			ptr->dofw_calendar += get_day_in_month(ptr->year, i) % 7;
			ptr->week_calendar += get_day_in_month(ptr->year, i) / 7;
		}
		ptr->dofw_calendar += (ptr->day - 1) % 7;
		ptr->week_calendar += (ptr->day - 1) / 7;
		ptr->week_calendar += ptr->dofw_calendar / 7;
		ptr->dofw_calendar = ptr->dofw_calendar % 7;
	}
}
