#include <plib.h>
#include "global.h"
#include "mal.h"
#include "serial_usart1.h"
#include "i_serial_usart1.h"
#include "c_serial_usart1.h"
#include "w_serial_usart1.h"

#include "io_states.h"

#include "ringBuffer.h"
#include "c_main.h"
#include <string.h>

RingBuffer myRingBuffer_tx_usart1;
unsigned char _tx_usart1[TX_LEN_USART1];
RingBuffer myRingBuffer_rx_usart1;
unsigned char _rx_usart1[RX_LEN_USART1];

Blocking_usart1 blockingMode_usart1 = BLOCKING_OFF_usart1;

unsigned long missedTxChar_usart1 = 0;
unsigned long missedRxChar_usart1 = 0;

void init_serial_usart1(unsigned long brg) {
	ringBuffer_initBuffer(&myRingBuffer_tx_usart1, _tx_usart1, sizeof(_tx_usart1) / sizeof(*_tx_usart1));
	ringBuffer_initBuffer(&myRingBuffer_rx_usart1, _rx_usart1, sizeof(_rx_usart1) / sizeof(*_rx_usart1));

	RX_TRIS_USART1 = IN;
	TX_TRIS_USART1 = OUT;

	UARTConfigure(UART1, UART_ENABLE_PINS_TX_RX_ONLY | UART_ENABLE_HIGH_SPEED);
	UARTSetFifoMode(UART1, UART_INTERRUPT_ON_TX_NOT_FULL | UART_INTERRUPT_ON_RX_NOT_EMPTY);
	UARTSetLineControl(UART1, UART_DATA_SIZE_8_BITS | UART_PARITY_NONE | UART_STOP_BITS_1);
	UARTSetDataRate(UART1, SYS_FREQ / PB_DIV, brg);

	U1STAbits.URXEN = 1;
	U1STAbits.UTXEN = 1;
	U1MODEbits.ON = 1;
	//UARTEnable(UART1, UART_ENABLE_FLAGS(UART_PERIPHERAL | UART_RX | UART_TX)); 

	INTClearFlag(INT_U1RX);
	INTEnable(INT_U1RX, INT_ENABLED);

	IPC6bits.U1IP = INT_PRIORITY_LEVEL_2;
	//INTSetVectorPriority(INT_VECTOR_UART(UART1), INT_PRIORITY_LEVEL_2);

	INTSetVectorSubPriority(INT_VECTOR_UART(UART1), INT_SUB_PRIORITY_LEVEL_0);

	INTClearFlag(INT_U1E);
	INTEnable(INT_U1E, INT_ENABLED);

}

void isrSerialError_usart1(void) {
	if (U1STAbits.OERR) {
		U1STAbits.OERR = 0;
	} else {
		U1MODEbits.ON = 0;
		U1MODEbits.ON = 1;
		U1STAbits.URXEN = 1;
		U1STAbits.UTXEN = 1;
	}
}

void isrSerialTx_usart1(void) {
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_tx_usart1, &data) != 0) {
		INTClearFlag(INT_U1TX);
		U1TXREG = data;
	} else {
		INTEnable(INT_U1TX, INT_DISABLED);
	}
}

void isrSerialRx_usart1(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_rx_usart1, data) != -1) {
	} else {
		 missedRxChar_usart1++;
	}
}

int isCharInBuffer_usart1(void) {
	int result = -1;
	unsigned int cnt = 0;
	if (ringBuffer_getFillness(&myRingBuffer_rx_usart1) != 0) {
		result = cnt;
	}
	return result;
}

int getChar_usart1(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_rx_usart1, &data) != 0) {
		result = data;
	}
	return result;
}

void putChar_usart1(unsigned char data) {
	if (blockingMode_usart1 == BLOCKING_ON_usart1) {
		flush_usart1();
	}
	if (ringBuffer_addItem(&myRingBuffer_tx_usart1, data) != -1) {
		if (INTGetEnable(INT_U1TX) == 0) {
			INTEnable(INT_U1TX, INT_ENABLED);
		}
	} else {
		missedTxChar_usart1++;
	}
}

void flush_usart1(void) {
	while (1) {
		if (ringBuffer_getFillness(&myRingBuffer_tx_usart1) == 0) {
			break;
		}
	}
}

void setblockingMode_usart1(Blocking_usart1 newblockingMode_usart1) {
	blockingMode_usart1 = newblockingMode_usart1;
}

void tryReadjustBuffer_usart1(void) {
	ringBuffer_tryReadjustBuffer(&myRingBuffer_tx_usart1);
	ringBuffer_tryReadjustBuffer(&myRingBuffer_rx_usart1);
}