#include "mal.h"
#include "sht1x_low.h"
#include "c_sht1x_low.h"
#include "int_sht1x.h"

typedef enum _Sht1x_SignalGeneratorStates {
	Sht1x_SignalGeneratorStates_idle,
	Sht1x_SignalGeneratorStates_s_transstart_1,
	Sht1x_SignalGeneratorStates_s_transstart_2,
	Sht1x_SignalGeneratorStates_s_transstart_3,
	Sht1x_SignalGeneratorStates_s_transstart_4,
	Sht1x_SignalGeneratorStates_s_transstart_5,
	Sht1x_SignalGeneratorStates_s_transstart_6,
	Sht1x_SignalGeneratorStates_s_transstart_7,
	Sht1x_SignalGeneratorStates_s_connectionreset_1,
	Sht1x_SignalGeneratorStates_s_connectionreset_2,
	Sht1x_SignalGeneratorStates_s_connectionreset_3,
	Sht1x_SignalGeneratorStates_s_read_byte_1,
	Sht1x_SignalGeneratorStates_s_read_byte_2,
	Sht1x_SignalGeneratorStates_s_read_byte_3,
	Sht1x_SignalGeneratorStates_s_read_byte_4,
	Sht1x_SignalGeneratorStates_s_read_byte_5,
	Sht1x_SignalGeneratorStates_s_read_byte_6,
	Sht1x_SignalGeneratorStates_s_write_byte_1,
	Sht1x_SignalGeneratorStates_s_write_byte_2,
	Sht1x_SignalGeneratorStates_s_write_byte_3,
	Sht1x_SignalGeneratorStates_s_write_byte_4,
	Sht1x_SignalGeneratorStates_s_write_byte_5,
	Sht1x_SignalGeneratorStates_s_write_byte_6,
	Sht1x_SignalGeneratorStates_s_write_byte_7,
} Sht1x_SignalGeneratorStates;

Sht1x_SignalGeneratorStates sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_idle;
uint8 signalGeneratorLoopCnt = 0;
uint8 s_read_byte_ack = 0;
uint8 s_read_byte_result = 0;
uint8 s_write_byte_value = 0;
uint8 s_write_byte_result = 0;
uint8 do_shtt1x_low_1ms = 0;

void init_sht_low(void) {
	DATA_WR = 1;			//set data pin high
	SHT_PORT_SYNC();
	DATA_TRIS = 0; 			//set data pin an output
	SHT_PORT_SYNC();
	SCK = 0; 
	SHT_PORT_SYNC();
	SCK_TRIS = 0;			//set CLK pin an output low
	SHT_PORT_SYNC();
}

void do_shtt1x_low(void) {
	if (do_shtt1x_low_1ms) {
		do_shtt1x_low_1ms = 0;
		switch (sht1x_SignalGeneratorStates) {
			case Sht1x_SignalGeneratorStates_idle : {
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_1 : {
				SCK = 0; //Initial state   
				SHT_PORT_SYNC();
				DATA_TRIS = 1; //pullup resistor brings DATA pin high
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_2;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_2 : {
				SCK = 1;
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_3;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_3 : {
				DATA_WR = 0; 
				SHT_PORT_SYNC();
				DATA_TRIS = 0;
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_4;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_4 : {
				SCK = 0;
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_5;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_5 : {
				SCK = 1;
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_6;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_6 : {
				DATA_TRIS = 1; //pullup resistor brings DATA pin high
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_7;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_transstart_7 : {
				SCK = 0;
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_idle;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_connectionreset_1 : {
				DATA_WR = 1;			//set data pin high
				SHT_PORT_SYNC();
				DATA_TRIS = 0; 			//set data pin an output
				SHT_PORT_SYNC();
				SCK = 0; 
				SHT_PORT_SYNC();
				SCK_TRIS = 0;			//set CLK pin an output low
				SHT_PORT_SYNC();
				signalGeneratorLoopCnt = 0;
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_connectionreset_2;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_connectionreset_2 : {
				if (signalGeneratorLoopCnt != 9) {
					signalGeneratorLoopCnt++;
					SCK = 1;
					SHT_PORT_SYNC();
					sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_connectionreset_3;
				} else {
					sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_1;
				}
				break;
			}
			case Sht1x_SignalGeneratorStates_s_connectionreset_3 : {
				SCK = 0;
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_connectionreset_2;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_read_byte_1 : {
				DATA_TRIS = 1;                    //set DATA line an input
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_2;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_read_byte_2 : {
				SCK = 0;
				SHT_PORT_SYNC();
				signalGeneratorLoopCnt = 0x80;
				s_read_byte_result = 0;
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_3;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_read_byte_3 : {
				if (signalGeneratorLoopCnt != 0) {
					SCK = 1;                          //clk for SENSI-BUS
					SHT_PORT_SYNC();
					sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_4;
				} else {
					if (s_read_byte_ack == ACK) {
						DATA_TRIS = 0; 
						SHT_PORT_SYNC();
						DATA_WR = 0;
						SHT_PORT_SYNC();
					}
					sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_5;
				}
				break;
			}
			case Sht1x_SignalGeneratorStates_s_read_byte_4 : {
				uint8 bt = 0;
				bt = DATA_RD;
				if (bt == 1) {
					s_read_byte_result = (s_read_byte_result | signalGeneratorLoopCnt);        //read bit  				
				}
				SCK = 0;
				SHT_PORT_SYNC();
				signalGeneratorLoopCnt /= 2;
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_3;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_read_byte_5 : {
				SCK = 1;                          //clk #9 for ack
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_6;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_read_byte_6 : {
				SCK = 0;					    
				SHT_PORT_SYNC();
				DATA_TRIS = 1;                  //release DATA-line
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_idle;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_1 : {
				DATA_TRIS = 0;
				SHT_PORT_SYNC();
				signalGeneratorLoopCnt = 0x80;
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_2;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_2 : {
				if (signalGeneratorLoopCnt != 0) {
					if (signalGeneratorLoopCnt & s_write_byte_value) {
						DATA_WR = 1;          			//masking value with i , write to SENSI-BUS	
						SHT_PORT_SYNC();
					} else { 
						DATA_WR = 0; 
						SHT_PORT_SYNC();
					}
					sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_3;
				} else {
					sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_5;
					DATA_TRIS = 1;                           		//release DATA-line, let SHT10 sensor controls DATA line
					SHT_PORT_SYNC();
				}
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_3 : {
				SCK = 1;                          			//clk for SENSI-BUS
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_4;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_4 : {
				SCK = 0;
				SHT_PORT_SYNC();
				signalGeneratorLoopCnt /= 2;
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_2;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_5 : {
				SCK = 1;                            			//clk #9 for ack 
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_6;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_6 : {
				s_write_byte_result = DATA_RD;                       			//check ack (DATA will be pulled down by SHT11)
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_7;
				break;
			}
			case Sht1x_SignalGeneratorStates_s_write_byte_7 : {
				SCK = 0;       
				SHT_PORT_SYNC();
				sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_idle;
				break;
			}
			default : {
				break;
			}
		}
	}
}

void isrSHT_low_TimeOut_1ms(void) {
	do_shtt1x_low_1ms = 1;
}

uint8 sht1x_low_IsReady(void) {
	uint8 result = 0;
	
	if (sht1x_SignalGeneratorStates == Sht1x_SignalGeneratorStates_idle) {
		result = 1;
	}
	return result;
}

/*
*********************************************************************************************************
*                         				SOFT RESET THE SENSOR
*
* Description :	Soft reset, resets the interface, clears the status register to default values
*				Wait minimum 11 ms before next command
* Arguments   : none
*			
* Returns     : 1 if no response from the sensor
* Notes		  : 
*********************************************************************************************************
*/
/*
//Function not used.
uint8 s_softreset(void) { 
	uint8 result = 0;  
	s_connectionreset();              //reset communication
	result = s_write_byte(RESET);       //send RESET-command to sensor
	#warning TODO change to state machine
	//DelayMS(20);
	return result;                     //error=1 in case of no response from the sensor
}
*/

uint8 s_waitforresult(void) {
	uint8 result = 0;
	result = DATA_RD;
	return result;
}

/*
//Functions not used.
uint8 s_measure(uint8 *p_value, uint8 *p_checksum) { 
	uint8 result = 0;
	uint8 dt = 0;
	dt = s_read_byte(ACK);    		//read the first byte (MSB)
	*(p_value + 1) = dt;
	dt = s_read_byte(ACK);    	 	//read the second byte (LSB)
	*(p_value) = dt;
	dt = s_read_byte(noACK);  		//read checksum
	*p_checksum = dt;
	return result;
}

uint8 s_read_statusreg(uint8 *p_value, uint8 *p_checksum) {
	// reads the status register with checksum (8-bit)   
	uint8 Error = 0;   
	s_transstart();                   //transmission start   
	Error       = s_write_byte(STATUS_REG_R);    //send command to sensor   
	*p_value    = s_read_byte(ACK);              //read status register (8-bit)   
	*p_checksum = s_read_byte(noACK);            //read checksum (8-bit)     
	return Error;                     //error=1 in case of no response form the sensor   
}   

uint8 s_write_statusreg(uint8 *p_value) {
	// writes the status register with checksum (8-bit)   
	uint8 Error = 0;   
	s_transstart();                     //transmission start   
	Error += s_write_byte(STATUS_REG_W); //send command to sensor   
	Error += s_write_byte(*p_value);     //send value of status register   
	return Error;                         //error>=1 in case of no response form the sensor   
}
*/
/*
*********************************************************************************************************
*                         				TRANSMISSION START SEQUENCE
*
* Description : To initiate a transmission, a Transmission Start?sequence has to be issued.
* Arguments   : none
*			
* Returns     : none
* Notes		  : 
* 					generates a transmission start 
*       					_____         ________
* 					DATA: 	     |_______|
*								___     ___
* 					SCK :	___|   |___|   |______
*********************************************************************************************************
*/
/*void s_transstart(void) {
	s_transstart_Start();
	while (sht1x_low_IsReadyLocal() == 0);
}*/

void s_transstart_Start(void) {
	sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_transstart_1;
}

/*
*********************************************************************************************************
*                         				 CONNECTION RESET SEQUENCE
*
* Description : This sequence resets the interface only. The status register preserves its content.
* Arguments   : none
*			
* Returns     : none
* Notes		  : 
* 					communication reset: DATA-line=1 and at least 9 SCK cycles followed by transstart
*       			  _____________________________________________________         ________
* 				DATA:                                                      |_______|
*  				         _    _    _    _    _    _    _    _    _        ___     ___
* 				SCK : __| |__| |__| |__| |__| |__| |__| |__| |__| |______|   |___|   |______
*********************************************************************************************************
*/
/*
void s_connectionreset(void) {
	s_connectionreset_Start();
	while (sht1x_low_IsReadyLocal() == 0);
}
*/

void s_connectionreset_Start(void) {
	sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_connectionreset_1;
}

/*
*********************************************************************************************************
*                         				LOW LEVEL READ FUNCTION 
*
* Description : Read a byte form the Sensibus and gives an acknowledge in case of "ack == ACK" 
* Arguments   : 'ack' 	ACK (1) if acknowledge required
*						noACK (0) in case acknowledge NOT required
*			
* Returns     : return the byte read from the sensor
* Notes		  : 
*********************************************************************************************************
*/
/*
uint8 s_read_byte(uint8 ack) {
	s_read_byte_Start(ack);
	while (sht1x_low_IsReadyLocal() == 0);
	return s_read_byte_GetResult();
}
*/

void s_read_byte_Start(uint8 ack) {
	s_read_byte_ack = ack;
	sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_read_byte_1;
}

uint8 s_read_byte_GetResult(void) {
	return s_read_byte_result;
}

/*
*********************************************************************************************************
*                         				LOW LEVEL WRITE FUNCTION 
*
* Description : Write a byte on the Sensibus and checks the acknowledge
* Arguments   : 'value' is the byte to write to the sensor
*			
* Returns     : 1 in case of an error (no acknowledge) from the sensor
* Notes		  : 
*********************************************************************************************************
*/
/*
uint8 s_write_byte(uint8 value) {
	s_write_byte_Start(value);
	while (sht1x_low_IsReadyLocal() == 0);
	return s_write_byte_GetResult();
}
*/

void s_write_byte_Start(uint8 value) {
	s_write_byte_value = value;
	sht1x_SignalGeneratorStates = Sht1x_SignalGeneratorStates_s_write_byte_1;
}

uint8 s_write_byte_GetResult(void) {
	return s_write_byte_result;
}
