#include "global.h"
#include <string.h>
#include "c_sio.h"
#include "e_sio.h"

#include "main.h"
#include "sleep.h"
#include "mal.h"

typedef enum _ParamIDX {
	ParamIDX_tick_count = 0x0000,
	ParamIDX_status = 0x0001,
	ParamIDX_loopCnt = 0x0002,
	ParamIDX_Bootloader_Command = 0xB006,
	ParamIDX_Bootloader_Result = 0xB007,
	ParamIDX_Bootloader_WriteData = 0xB008,
	ParamIDX_Bootloader_ReadData = 0xB009,
} ParamIDX;

SIOSTATUS status;
extern uint32 Bootloader_Command;
extern uint32 Bootloader_Result;
extern uint32 Bootloader_WriteData;
extern uint32 Bootloader_ReadData;
extern unsigned char fileWriteBuffer[32];
extern UINT writeBytes;

SioParamIDXs sioParamIDX[] = {
	{ParamIDX_tick_count,			(unsigned int *) &tick_count,			0},
	{ParamIDX_status,				(unsigned int *) &status,				0},
	{ParamIDX_loopCnt,				(unsigned int *) &loopCnt,				1},
	{ParamIDX_Bootloader_Command,	(unsigned int *) &Bootloader_Command,	9},
	{ParamIDX_Bootloader_Result,	(unsigned int *) &Bootloader_Result,	9},
	{ParamIDX_Bootloader_WriteData,	(unsigned int *) &Bootloader_WriteData,	9},
	{ParamIDX_Bootloader_ReadData,	(unsigned int *) &Bootloader_ReadData,	9},
};

void Param_Rd(uint16 idx) { // called befor parameter is read
	switch ((ParamIDX)idx) {
		case ParamIDX_tick_count : {
			break;
		}
		case ParamIDX_status : {
			break;
		}
		case ParamIDX_loopCnt : {
			break;
		}
		case ParamIDX_Bootloader_Command : {
			break;
		}
		case ParamIDX_Bootloader_Result : {
			break;
		}
		case ParamIDX_Bootloader_WriteData : {
			break;
		}
		case ParamIDX_Bootloader_ReadData : {
			break;
		}
	}
}

void Param_Wr(uint16 idx) { //called after parameter is updated
	switch ((ParamIDX)idx) {
		case ParamIDX_tick_count : {
			break;
		}
		case ParamIDX_status : {
			break;
		}
		case ParamIDX_loopCnt : {
			break;
		}
		case ParamIDX_Bootloader_Command : {
			break;
		}
		case ParamIDX_Bootloader_Result : {
			break;
		}
		case ParamIDX_Bootloader_WriteData : {
			break;
		}
		case ParamIDX_Bootloader_ReadData : {
			break;
		}
	}
}

void ParamBuff_Rd(uint16 idx, uint8 *data, uint16 *length) {
	if ((data != NULL) && (length != NULL)) {
		switch (idx) {
			case ParamIDX_Bootloader_WriteData : {
				if (*length == 32) {
					memcpy(data, fileWriteBuffer, *length);
				}
				break;
			}
			case ParamIDX_Bootloader_ReadData : {
				if (*length == 32) {
					memcpy(data, fileWriteBuffer, *length);
				}
				break;
			}
			default : {
				*length = 0;
				break;
			}
		}
	}
}

void ParamBuff_Wr(uint16 idx, uint8 *data, uint16 length) {
	if (data != NULL) {
		switch (idx) {
			case ParamIDX_Bootloader_WriteData : {
				if (length == 32) {
					memcpy(fileWriteBuffer, data, length);
					writeBytes = 32;
				}
				break;
			}
			case ParamIDX_Bootloader_ReadData : {
				if (length == 32) {
					memcpy(fileWriteBuffer, data, length);
					writeBytes = 32;
				}
				break;
			}
			default : {
				break;
			}
		}
	}
}

uint16 getsioParamIDXItemCnt(void) {
	return (sizeof(sioParamIDX) / sizeof(*sioParamIDX));
}
