#include "global.h"
#include <string.h>
#include "c_sio.h"
#include "e_sio.h"

#include "main.h"
#include "sleep.h"
#include "mal.h"

typedef enum _ParamIDX {
	ParamIDX_tick_count = 0x0000,
	ParamIDX_status = 0x0001,
	ParamIDX_loopCnt = 0x0002,
} ParamIDX;

SIOSTATUS status;

SioParamIDXs sioParamIDX[] = {
	{ParamIDX_tick_count,			(unsigned int *) &tick_count,			0},
	{ParamIDX_status,				(unsigned int *) &status,				0},
	{ParamIDX_loopCnt,				(unsigned int *) &loopCnt,				1},
};

void Param_Rd(uint16 idx) { // called befor parameter is read
	switch ((ParamIDX)idx) {
		case ParamIDX_tick_count : {
			break;
		}
		case ParamIDX_status : {
			break;
		}
		case ParamIDX_loopCnt : {
			break;
		}
	}
}

void Param_Wr(uint16 idx) { //called after parameter is updated
	switch ((ParamIDX)idx) {
		case ParamIDX_tick_count : {
			break;
		}
		case ParamIDX_status : {
			if (status.idleRequest) {
				status.idleRequest = 0;
				idle_Request();
			}
			if (status.sleepRequest) {
				sleep_Request(5000);
				status.sleepRequest = 0;
			}
			if (status.led) {
				setNormalLED();
			} else {
				clearNormalLED();
			}
			if (status.blinking) {
				blinkNormalLED();
			} else {
				stopBlinkNormalLED();
			}
			break;
		}
		case ParamIDX_loopCnt : {
			break;
		}
	}
}

void ParamBuff_Rd(uint16 idx, uint8 *data, uint16 *length) {
	if ((data != NULL) && (length != NULL)) {
		switch (idx) {
			default : {
				*length = 0;
				break;
			}
		}
	}
}

void ParamBuff_Wr(uint16 idx, uint8 *data, uint16 length) {
	if (data != NULL) {
		switch (idx) {
			default : {
				break;
			}
		}
	}
}

uint16 getsioParamIDXItemCnt(void) {
	return (sizeof(sioParamIDX) / sizeof(*sioParamIDX));
}
