#include <string.h>
#include "sio.h"
#include "w_sio.h"
#include "c_sio.h"
#include "e_sio.h"
#include "i_sio.h"

#include "tmr.h"
#ifdef SIO_USE_AES
	#include "aes_helper.h"
#endif

uint8 sio_Secret_User[SIO_SEED_LENGTH] = {0xde, 0xad, 0xbe, 0xaf};
uint8 sio_Secret_Admin[SIO_SEED_LENGTH] = {0xde, 0xad, 0xbe, 0xaf};
uint8 sio_Secret_Supervisor[SIO_SEED_LENGTH] = {0xde, 0xad, 0xbe, 0xaf};

uint8 sio_Key[SIO_SEED_LENGTH] = {0x00, 0x00, 0x00, 0x00};
uint8 sio_Seed[SIO_SEED_LENGTH] = {0x00, 0x00, 0x00, 0x00};
uint8 sio_access_level_current = 0;

uint8 sio_random(void);
void sio_calculateKey(uint8 newLevel);

void sio_getSeed(uint8 *data) {
	uint8 i = 0;
	if (data != NULL) {
		for (i = 0; i < SIO_SEED_LENGTH; i++) {
			uint8 tempDataSeed = sio_random();
			sio_Seed[i] = tempDataSeed;
			data[i] = tempDataSeed;
//			sio_Seed[i] = data[i] = 0x05;
		}
	}
}

uint8 sio_checkKey(uint8 *key, uint8 newLevel) {
	uint8 result = 1;
	uint8 i = 0;
	if (key != NULL) {
		sio_calculateKey(newLevel);	
		for (i = 0; i < SIO_SEED_LENGTH; i++) {
			if (key[i] != sio_Key[i]) {
				result = 0;
				break;
			}
		}
	}
	if (result) {
		sio_access_level_current = newLevel;
		sio_user_AuthenticatedCallout();
	}
	return result;
}

void sio_calculateKey(uint8 newLevel) {
	uint8 i = 0;
	#ifdef SIO_USE_AES
		uint8 sio_AesBufferIn[16];
		uint8 sio_AesBufferOut[16];
		memcpy(sio_AesBufferIn, sio_Seed, SIO_SEED_LENGTH);
		switch (newLevel) {
			case 0 : //Default
			case 1 :  //User
			case 2 :  //User
			case 3 : {//User
				memcpy(sio_AesBufferIn + SIO_SEED_LENGTH, sio_Secret_User, SIO_SEED_LENGTH);
				break;
			}
			case 4 :  //Admin
			case 5 :  //Admin
			case 6 : {//Admin
				memcpy(sio_AesBufferIn + SIO_SEED_LENGTH, sio_Secret_Admin, SIO_SEED_LENGTH);
				break;
			}
			case 7 : //Supervisor
			default : {
				memcpy(sio_AesBufferIn + SIO_SEED_LENGTH, sio_Secret_Supervisor, SIO_SEED_LENGTH);
				break;
			}
		}
		memset(sio_AesBufferIn + (SIO_SEED_LENGTH + SIO_SEED_LENGTH), 0x00, (SIO_SEED_LENGTH + SIO_SEED_LENGTH));
		aes_block_encrypt(sio_AesBufferIn, sio_AesBufferOut, 16);
		memcpy(sio_Key, sio_AesBufferOut, SIO_SEED_LENGTH);
	#endif
	for (i = 0; i < SIO_SEED_LENGTH; i++) {
		#ifdef SIO_USE_AES
		#else
			switch (newLevel) {
				case 0 : //Default
				case 1 :  //User
				case 2 :  //User
				case 3 : {//User
					sio_Key[i] = sio_Secret_User[i] + sio_Seed[i];
					break;
				}
				case 4 :  //Admin
				case 5 :  //Admin
				case 6 : {//Admin
					sio_Key[i] = sio_Secret_Admin[i] + sio_Seed[i];
					break;
				}
				case 7 : //Supervisor
				default : {
					sio_Key[i] = sio_Secret_Supervisor[i] + sio_Seed[i];
					break;
				}
			}
		#endif
	}
}

uint8 sio_random(void) {
	static uint8 result = 0;
	result += (uint8)getGlobalTime();
	return result;
}

void sio_setUserSecret(uint8 *newSecret) {
	if (newSecret != NULL) {
		memcpy(sio_Secret_User, newSecret, SIO_SEED_LENGTH);
	}
}

void sio_setAdminSecret(uint8 *newSecret) {
	if (newSecret != NULL) {
		memcpy(sio_Secret_Admin, newSecret, SIO_SEED_LENGTH);
	}
}

void sio_setSupervisorSecret(uint8 *newSecret) {
	if (newSecret != NULL) {
		memcpy(sio_Secret_Supervisor, newSecret, SIO_SEED_LENGTH);
	}
}

void sio_clearAccessLevel(void) {
	sio_access_level_current = 0;
	sio_user_AuthenticatedCallout();
}
