#include "sio.h"
#include "w_sio.h"
#include "c_sio.h"
#include "i_sio.h"
#include "e_sio.h"

#ifdef USE_RS232_USART1
	#include "serial_usart1.h"
	#define USE_RS232_LOCAL
	#define isCharInBuffer_sio()					isCharInBuffer_usart1()
	#define getChar_sio()							getChar_usart1()
	#define putChar_sio(data)						putChar_usart1(data)
	#define flush_sio()								flush_usart1()
	#define setBlockingMode_sio(newBlockingMode)	setBlockingMode_usart1(newBlockingMode)
	#define tryReadjustBuffer_sio()					tryReadjustBuffer_usart1()
#endif
#ifdef USE_RS232_USART2
	#include "serial_usart2.h"
	#define USE_RS232_LOCAL
	#define isCharInBuffer_sio()					isCharInBuffer_usart2()
	#define getChar_sio()							getChar_usart2()
	#define putChar_sio(data)						putChar_usart2(data)
	#define flush_sio()								flush_usart2()
	#define setBlockingMode_sio(newBlockingMode)	setBlockingMode_usart2(newBlockingMode)
	#define tryReadjustBuffer_sio()					tryReadjustBuffer_usart2()
#endif
#ifdef USE_USB
	#include "serial_usb.h"
#endif
#ifdef USE_RADIO_NRF
	#include "nrf24l01_radio.h"
#endif
#ifdef USE_ESP8266_SLAVE
	#include "esp8266_radio.h"
#endif
#ifdef USE_GSM_SMS_SLAVE
	#include "gsm_sms_radio.h"
#endif
#ifdef USE_I2C_SLAVE
	#include "iic_slave.h"
#endif
#ifdef USE_CAN
	#include "can_slave.h"
	#include "i_can_sio.h"
	#include "w_can_sio.h"
#endif
#ifdef USE_TEST
	#include "sio_test.h"
#endif

SIO_COM sio_com = 0;
void putChar_Wrapper(char ch);

void sioSendPacketWrapper(uint16 command, uint8 *data, uint16 length) {
	uint16 packetlength = length;
	uint8 LengthH = (packetlength >> 8) & 0xFF;
	uint8 LengthL = (packetlength) & 0xFF;
	uint8 CommandH = (command >> 8) & 0xFF;
	uint8 CommandL = (command) & 0xFF;
	uint32 crc = 0;
	uint8 CrcHH = 0;
	uint8 CrcHL = 0;
	uint8 CrcLH = 0;
	uint8 CrcLL = 0;

	flushBufferWrapper();

	sio_calulate_crc32_start();

	putChar_Wrapper(CMD_START);				//Start
	sio_calulate_crc32_add(CMD_START);

	putChar_Wrapper(LengthH);				//LengthH
	sio_calulate_crc32_add(LengthH);
	putChar_Wrapper(LengthL);				//LengthL
	sio_calulate_crc32_add(LengthL);

	putChar_Wrapper(0xFF);					//AddressH
	sio_calulate_crc32_add(0xFF);
	putChar_Wrapper(0xFF);					//AddressL
	sio_calulate_crc32_add(0xFF);

	putChar_Wrapper(CommandH);					//CommandH
	sio_calulate_crc32_add(CommandH);
	putChar_Wrapper(CommandL);					//CommandL
	sio_calulate_crc32_add(CommandL);

	//precalculate CRC from payload
	sio_calulate_crc32_add(0x00);
	sio_calulate_crc32_add(0x00);
	sio_calulate_crc32_add(0x00);
	sio_calulate_crc32_add(0x00);
	{
		uint16 x = 0;
		for (x = 0; x < length; x++) {
			sio_calulate_crc32_add(*(data + x));
		}
	}
	sio_calulate_crc32_add(CMD_END);
	crc = sio_calulate_crc32_get();
	CrcHH = (crc >> 24) & 0xFF;
	CrcHL = (crc >> 16) & 0xFF;
	CrcLH = (crc >> 8) & 0xFF;
	CrcLL = (crc) & 0xFF;

	putChar_Wrapper(CrcHH);					//CrcHH
	putChar_Wrapper(CrcHL);					//CrcHL
	putChar_Wrapper(CrcLH);					//CrcLH
	putChar_Wrapper(CrcLL);					//CrcLL
	
	{
		uint16 x = 0;
		for (x = 0; x < length; x++) {
			putChar_Wrapper(*(data + x));
		}
	}
	
	putChar_Wrapper(CMD_END);
}

void flushBufferWrapper(void) {
	switch (sio_com) {
		case SIO_RS232 : {
			#ifdef USE_RS232_LOCAL
				flush_sio();
			#endif
			break;
		}
		case SIO_USB : {
			#ifdef USE_USB
				flush_usb();
			#endif
			break;
		}
		case SIO_I2C : {
			#ifdef USE_I2C_SLAVE
				flushI2C();
			#endif
			break;
		}
		case SIO_CAN : {
			#ifdef USE_CAN
				flushCAN();
			#endif
			break;
		}
		case SIO_RADIO : {
			#ifdef USE_RADIO_NRF
				flushRadio();
			#endif
			break;
		}
		case SIO_RADIO_ESP8266 : {
			#ifdef USE_ESP8266_SLAVE
				flushRadioEsp8266();
			#endif
			break;
		}
		case SIO_GSM_SMS : {
			#ifdef USE_GSM_SMS_SLAVE
				flushRadioGSM_SMS();
			#endif
			break;
		}
		case SIO_TEST : {
			#ifdef USE_TEST
				flush_Test();
			#endif
			break;
		}
	}
}

void putChar_Wrapper(char ch) {
	switch (sio_com) {
		case SIO_RS232 : {
			#ifdef USE_RS232_LOCAL
				putChar_sio(ch);
			#endif
			break;
		}
		case SIO_USB : {
			#ifdef USE_USB
				putChar_usb(ch);
			#endif
			break;
		}
		case SIO_I2C : {
			#ifdef USE_I2C_SLAVE
				putCharI2C(ch);
			#endif
			break;
		}
		case SIO_CAN : {
			#ifdef USE_CAN
				putCharCAN(ch);
			#endif
			break;
		}
		case SIO_RADIO : {
			#ifdef USE_RADIO_NRF
				putCharRadio(ch);
			#endif
			break;
		}
		case SIO_RADIO_ESP8266 : {
			#ifdef USE_ESP8266_SLAVE
				putCharRadioEsp8266(ch);
			#endif
			break;
		}
		case SIO_GSM_SMS : {
			#ifdef USE_GSM_SMS_SLAVE
				putCharRadioGSM_SMS(ch);
			#endif
			break;
		}
		case SIO_TEST : {
			#ifdef USE_TEST
				putChar_Test(ch);
			#endif
			break;
		}
	}
}

int getCharWrapper(void) {
	int result = -1;
	#ifdef USE_RS232_LOCAL
		if (result == -1) {
			result = getChar_sio();
			if (result != -1) {
				sio_com = SIO_RS232;
			}
		}
	#endif
	#ifdef USE_USB
		if (result == -1) {
			result = getChar_usb();
			if (result != -1) {
				sio_com = SIO_USB;
			}
		}
	#endif
	#ifdef USE_RADIO_NRF
		if (result == -1) {
			result = getCharRadio();
			if (result != -1) {
				sio_com = SIO_RADIO;
			}
		}
	#endif
	#ifdef USE_ESP8266_SLAVE
		if (result == -1) {
			result = getCharRadioEsp8266();
			if (result != -1) {
				sio_com = SIO_RADIO_ESP8266;
			}
		}
	#endif
	#ifdef USE_GSM_SMS_SLAVE
		if (result == -1) {
			result = getCharRadioGSM_SMS();
			if (result != -1) {
				sio_com = SIO_GSM_SMS;
			}
		}
	#endif
	#ifdef USE_I2C_SLAVE
		if (result == -1) {
			result = getCharI2C();
			if (result != -1) {
				sio_com = SIO_I2C;
			}
		}
	#endif
	#ifdef USE_CAN
		if (result == -1) {
			result = getCharCAN();
			if (result != -1) {
				sio_com = SIO_CAN;
			}
		}
	#endif
	#ifdef USE_TEST
		if (result == -1) {
			result = getCharTest();
			if (result != -1) {
				sio_com = SIO_TEST;
			}
		}
	#endif
	return result;
}
