#include <stdio.h>
#include <string.h>
#include "spi.h"
#include "c_spi.h"
#include "i_spi.h"
#include "w_spi.h"

#include "io_states.h"
#include "tmr.h"
#include "mal.h"
#include "c_main.h"

Timer spiFailsafeTimeout;

void init_spi(void) {
	SPI_SDO_TRIS = 0;
	SPI_PORT_SYNC();
	SPI_SDI_TRIS = 1;
	SPI_PORT_SYNC();
	SPI_SCK_TRIS = 0;
	SPI_PORT_SYNC();

	SPI2CON = 0;
	Nop();
	Nop();
	Nop();
	Nop();
	{
		volatile unsigned char tempRead = SPI2BUF;
	}
	Nop();
	Nop();
	Nop();
	Nop();

	SPI2CON = 0x00008020;
	SPI2STATbits.SPIROV = 0;
	SPI2BRG = SPI_BRG_CONFIG;
	SPI2CONbits.CKP	= SPI_CKP_CONFIG;
	SPI2CONbits.CKE	= SPI_CKE_CONFIG;

	IPC7bits.SPI2IP = 3;
	IPC7bits.SPI2IS = 3;

	IEC1bits.SPI2RXIE = 0;
	IEC1bits.SPI2TXIE = 0;
	IEC1bits.SPI2EIE = 0;

	IFS1bits.SPI2RXIF = 0;
	IFS1bits.SPI2TXIF = 0;
	IFS1bits.SPI2EIF = 0;

	removeTimer(&spiFailsafeTimeout);
	addTimer(&spiFailsafeTimeout);
}

void do_spi(void) {
}

void isr_spi_1ms(void) {
}

void spi_reconfigure(unsigned char SMP, unsigned char CKP, unsigned char CKE, unsigned int BRG) {
	SPI2CONbits.ON = 0;
	SPI2BRG = BRG;
	SPI2CONbits.SMP	= SMP;
	SPI2CONbits.CKP	= CKP;
	SPI2CONbits.CKE	= CKE;
	SPI2CONbits.ON = 1;
}

SPIStateEnum readWriteSPI(unsigned char *bufferOut, unsigned char *bufferIn, unsigned int size) {
	SPIStateEnum result = SPI_BUSY_STATE;
	unsigned int i = 0;
	unsigned int j = 0;

	for (j = 0; j < size; j++) {
		volatile unsigned char currentBufferOut = 0;
		volatile unsigned char currentBufferIn = 0;
		if (bufferOut != NULL) {
			currentBufferOut = bufferOut[j];
		}

		SPI2BUF = currentBufferOut;
		writeTimer(&spiFailsafeTimeout, 100);
		while (1) {
			if (readTimer(&spiFailsafeTimeout) == 0) {
				break;
			}
			if ((IFS1bits.SPI2TXIF) && (IFS1bits.SPI2RXIF)) {
				break;
			}
		}
		IFS1bits.SPI2RXIF = 0;
		IFS1bits.SPI2TXIF = 0;
		currentBufferIn = SPI2BUF;

		if (bufferIn != NULL) {
			bufferIn[j] = currentBufferIn;
		}
	}
	result = SPI_READY_STATE;
	return result;
}

uint16 SPICalutateBRG(uint32 spi_clk) {
	uint32 pb_clk = GetPeripheralClock();
    uint32 brg = 0;

    brg = pb_clk / (2 * spi_clk);

    if(pb_clk % (2 * spi_clk)) {
        brg++;
	}

    if(brg > 0x100) {
        brg = 0x100;
	}

    if(brg) {
        brg--;
	}

    return (uint16) brg;
}
