#include <string.h>
#include <stdio.h>
#include "global.h"
#include "mal.h"
#include "tmr.h"
#include "c_tmr.h"
#include "i_tmr.h"
#include "w_tmr.h"

#include "c_main.h"
#include "k_stdtype.h"

uint32 globalTime = 0;
uint32 globalTimeUs = 0;
static uint32 delayCnt = 0;
static Timer *ptrList[TIMERCNT];
#define SIZEOFPTR (sizeof(ptrList)/sizeof(*ptrList))

void init_tmr (void) {
	uint8 x = 0;

	#ifndef TMR_USE_TMR4_1MS
		//TMR1 1ms
		OpenTimer1(T1_ON | T1_SOURCE_INT | T1_PS_1_256, PR1_CONFIG);
		ConfigIntTimer1(T1_INT_ON | T1_INT_PRIOR_2);
	#endif
	#ifdef TMR_USE_TMR4_1MS
		//TMR4 1ms
		OpenTimer4(T4_ON | T4_SOURCE_INT | T4_PS_1_256, PR1_CONFIG);
		ConfigIntTimer4(T4_INT_ON | T4_INT_PRIOR_2);
	#endif
	#ifdef TMR_USE_TMR1_SOSC
		OSCCONbits.SOSCEN = 1;
		OpenTimer1(T1_ON | T1_SOURCE_EXT | T1_PS_1_1, 32768);
		ConfigIntTimer1(T1_INT_ON | T1_INT_PRIOR_2);
	#endif

	//TMR2 100uS
    OpenTimer2(T2_ON | T2_SOURCE_INT | T2_PS_1_256, PR2_CONFIG);
	ConfigIntTimer2(T2_INT_ON | T2_INT_PRIOR_2);

	for (x = 0; x < SIZEOFPTR; x++) {
		ptrList[x] = NULL;
	}
}

void do_tmr(void) {
}

void delayms(uint32 dt) {
	uint16 temp = 0;
	lock_isr();
	delayCnt = dt;
	unlock_isr();
	while (1) {
		lock_isr();
		temp = delayCnt;
		unlock_isr();
		if (temp == 0) {
			break;
		}
	}
}

void addTimer(Timer *ptr) {
	uint8 x = 0;
	lock_isr();
	for (x = 0; x < SIZEOFPTR; x++) {
		if (ptrList[x] == NULL) {
			ptrList[x] = ptr;
			break;
		}
	}
	unlock_isr();
}

void removeTimer(Timer *ptr) {
	uint8 x = 0;
	lock_isr();
	for (x = 0; x < SIZEOFPTR; x++) {
		if (ptrList[x] == ptr) {
			ptrList[x] = NULL;
			break;
		}
	}
	unlock_isr();
}

uint32 readTimer(const Timer *ptr) {
	uint32 result = 0;
	if (ptr != NULL) {
		lock_isr();
		result = *ptr;
		unlock_isr();	
	}
	return result;
}

void writeTimer(Timer *ptr, uint32 newValue) {
	if (ptr != NULL) {
		lock_isr();
		*ptr = newValue;
		unlock_isr();	
	}
}

void setTimer(uint32 d) {
	delayCnt = d;
}

uint32 getTimer(void) {
	return delayCnt;
}

void isr_tmr3(void) { //custom
	TMR3_FUNCTIONS();
}

void isr_tmr2(void) { //100us
	globalTimeUs += 100;
	TMR2_FUNCTIONS();
}

void isr_tmr1(void) { //1ms
	uint8 x = 0;
	static uint8 ms10Cnt = 0;
	static uint8 ms100Cnt = 0;
	static uint8 ms250Cnt = 0;
	static uint16 ms500Cnt = 0;
	static uint16 ms1000Cnt = 0;
	
	ClrWdt();
	globalTime++;

	TMR1_FUNCTIONS();

	if (delayCnt != 0) {
		delayCnt--;
	}

	ms10Cnt ++;
	if (ms10Cnt == 10) {
		ms10Cnt = 0;
	}

	ms100Cnt ++;
	if (ms100Cnt == 100) {
		ms100Cnt = 0;
	}
	
	ms250Cnt ++;
	if (ms250Cnt == 250) {
		ms250Cnt = 0;
	}

	ms500Cnt ++;
	if (ms500Cnt == 500) {
		ms500Cnt = 0;
	}

	ms1000Cnt ++;
	if (ms1000Cnt == 1000) {
		ms1000Cnt = 0;
	}

	for (x = 0; x < SIZEOFPTR; x++) {
		if (ptrList[x] != NULL) {
			if (*(ptrList[x]) != 0) {
				(*(ptrList[x]))--;
			}
		}
	}
}

uint32 getGlobalTime(void) {
	uint32 result = 0;
	lock_isr();
	result = globalTime;
	unlock_isr();
	return result;
}

uint32 getGlobalTimeUs(void) {
	uint32 result = 0;
	lock_isr();
	result = globalTimeUs;
	unlock_isr();
	return result;
}
