_
; Pin definitions for SCL and SDA

#define SDA portc,4   ; = RC.4
#define SCL portc,3   ; = RC.3

	include ii2.inc

;*****************************************************************
; PCF8583ReadByte
; Reads 1 byte from PCF8583
;
; Inputs:
; IISLAVEADR = slave-address
; IIADR      = address to read
;
; Output:
; IIDATA and W-Register = received byte from PCF8583
;*****************************************************************


PCF8583ReadByte

	call iistart            ; start

	banksel iislaveadr
	bcf status,carry
	rlf iislaveadr,w        ; Slave-Address
	iorlw B'10100000'       ; device-code for PCF8583 + write

	call iisend             ; send control-byte

	btfsc status,carry
	goto PCF8583ReadByte    ; device send NAK - then again

	banksel iiadr
	movfw iiadr             ; send address

	call iisend

	btfsc status,carry
	goto PCF8583ReadByte    ; device send NAK - then again

	call iistart            ; repeated start

	banksel iislaveadr
	bcf status,carry
	rlf iislaveadr,w        ; Slave-Address
	iorlw B'10100001'       ; device-code for PCF8583 + read

	call iisend             ; send control-byte

	btfsc status,carry
	goto PCF8583ReadByte    ; device send NAK - then again

	call iirec              ; read byte
	banksel iidata
	movwf iidata

	call iinak              ; send NAK
	call iistop             ; thats all
	return

;*****************************************************************
; PCF8583WriteByte
; Writes 1 byte to PCF8583
;
; Inputs:
; IISLAVEADR = slave-address
; IIADR      = address to read
; IIDATA     = data send to PCF8583
;
; Output     = nothing
;*****************************************************************

PCF8583WriteByte

	call iistart            ; start

	banksel iislaveadr
	bcf status,carry
	rlf iislaveadr,w        ; Slave-Address
	iorlw B'10100000'       ; device-code for PCF8583 + write

	call iisend             ; send control-byte

	btfsc status,carry
	goto PCF8583WriteByte    ; device send NAK - then again

	banksel iiadr
	movfw iiadr             ; send address

	call iisend

	btfsc status,carry 
	goto PCF8583WriteByte    ; device send NAK - then again

	banksel iidata
	movfw iidata            ; send data

	call iisend

	btfsc status,carry
	goto PCF8583WriteByte    ; device send NAK - then again

	call iistop             ; thats all
	return

;*****************************************************************
; PCF8583ReadClock
;*****************************************************************

PCF8583ReadClock

; read seconds - address 2

	movlw 2
	banksel iiadr
	movwf iiadr

	call PCF8583ReadByte

            banksel iidata
            movwf iidata
            banksel asec
            movwf asec

	andlw H'0F'          ; single
	banksel asec_e
	movwf asec_e

	banksel iidata       ; tenner
	swapf iidata,w       ; Bit 7:4 <-> 3:0
	andlw H'0F'          ; mask Bit 3:0
	banksel asec_z       ; store
	movwf asec_z

                 
; read minutes - address 3

	banksel iiadr
	incf iiadr,f  ; iiadr+1

	call PCF8583ReadByte
	
	banksel iidata
	movwf iidata
	banksel aminut
	movwf aminut
	
	andlw H'0F'
	banksel amin_e
	movwf amin_e

	banksel iidata
	swapf iidata,w       ; Bit 7:4 <-> 3:0
	andlw H'0F'
	banksel amin_z
	movwf amin_z

; read hours - address 4

	banksel iiadr
	incf iiadr,f  ; iiadr+1

	call PCF8583ReadByte

	banksel iidata
	movwf iidata
	banksel ahour
	movwf ahour

	andlw H'0F'
	banksel ahour_e
	movwf ahour_e

	banksel iidata
	swapf iidata,w       ; Bit 7:4 <-> 3:0
	andlw H'0F'
	banksel ahour_z
	movwf ahour_z


; read month/dayofweek - address 6

	banksel iiadr
	incf iiadr,f  ; iiadr+1
	incf iiadr,f

	call PCF8583ReadByte

	banksel iidata
            swapf iidata,f
	rrf iidata,w
          	andlw B'00000111'
            banksel adayofweek
            movwf adayofweek

;	return

;*************************************************
; ReadRam
;*************************************************

;ReadRam1

	movlw 20
	banksel iiadr
	movwf iiadr
	
	call PCF8583ReadByte

	banksel iidata
	movwf iidata
	banksel mh4
	movwf mh4
	
	banksel iiadr
	incf iiadr,f
	
	call PCF8583ReadByte

	banksel iidata
	movwf iidata
	banksel mh5
	movwf mh5

	banksel iiadr
	incf iiadr,f
	
	call PCF8583ReadByte

	banksel iidata
	movwf iidata
	banksel mh5_hi
	movwf mh5_hi

	banksel iiadr
	incf iiadr,f

	call PCF8583ReadByte

	banksel iidata
	movwf iidata
	banksel b2
	movwf b2

	banksel iiadr
	incf iiadr,f

	call PCF8583ReadByte

	banksel iidata
	movwf iidata
	banksel c2
	movwf c2	

	return

;*****************************************************************
; PCF8583SetClock
;*****************************************************************

PCF8583SetClock

; Set seconds address 2

	movlw 2
	banksel iiadr
	movwf iiadr

	banksel asec_e
	movfw asec_e
	banksel iidata
	movwf iidata

	banksel asec_z
	swapf asec_z,w
	banksel iidata
	iorwf iidata,f

	call PCF8583WriteByte

; Set minutes address 3

	banksel iiadr
	incf iiadr,f   ; iiadr+1

	banksel amin_e
	movfw amin_e
	banksel iidata
	movwf iidata

	banksel amin_z
	swapf amin_z,w
	banksel iidata
	iorwf iidata,f

	call PCF8583WriteByte

; Set hours address 4

	banksel iiadr
	incf iiadr,f   ; iiadr+1

	banksel ahour_e
	movfw ahour_e
	banksel iidata
	movwf iidata

	banksel ahour_z
	swapf ahour_z,w
	banksel iidata
	iorwf iidata,f

	call PCF8583WriteByte

; Set month address 6

	banksel iiadr
	incf iiadr,f   ; iiadr+1
	incf iiadr,f

	banksel adayofweek
            swapf adayofweek,w
            banksel iidata
            movwf iidata
	rlf iidata,f
            movlw B'11100000'
            andwf iidata,f  
         
           	call PCF8583WriteByte
       

	movlw 20
	banksel iiadr
	movwf iiadr

	banksel b1  ; muszak sorszam
	movfw b1
	banksel iidata
	movwf iidata

	call PCF8583WriteByte

	banksel iiadr
	incf iiadr,f

	banksel b0   ; munkaval toltott ido
	movfw b0
	banksel iidata
	movwf iidata

	call PCF8583WriteByte

	banksel iiadr
	incf iiadr,f

	banksel b0_hi
	movfw b0_hi
	banksel iidata
	movwf iidata

	call PCF8583WriteByte

	banksel iiadr
	incf iiadr,f

	banksel adayofweek
	movfw adayofweek
	banksel iidata
	movwf iidata

	call PCF8583WriteByte	

	banksel iiadr
	incf iiadr,f

	banksel b3
	movfw b3
	banksel iidata
	movwf iidata

	call PCF8583WriteByte

	return

