#ifndef __UART_H
#define __UART_H

//==============================================================================
// Uart paramtereket itt lehet belltani
// - Inicializls: UartInit()
// - Ads: UartTx(unsigned char ch) (ha a hvs eltt uTxBufFree == 0 -> nem rdemes elkldeni, mert meg van telve)
// - Vtel: ch = UartRx() (csak akkor ad eredmnyt, ha a hvs eltt uRxLength > 0)

//------------------------------------------------------------------------------
#include "hardwareprofile.h"
// Ha kls hardverprofilt hasznlunk akkor azt itt adhatjuk meg
// - bels hardverprofil esetn kommenteljk ki
// - kls hardverprofil esetn az ott megadott paramtereket ebben a file-ban kommenteljk ki

//------------------------------------------------------------------------------
// Ads puffer mrete (4, 8, 16, 32, 64, 128)
// #define UTXBUFFERSIZE 64

//------------------------------------------------------------------------------
// Vteli puffer mrete (4, 8, 16, 32, 64, 128)
// #define URXBUFFERSIZE 64

//------------------------------------------------------------------------------
// Rendszer rajel (UART oszt belltshoz)
// #define SystemClock   48000000

//------------------------------------------------------------------------------
// Soros port kvnt sebessge
// #define BAUDRATE      31250

//------------------------------------------------------------------------------
// Uart lbak I/O belltsa (inicializlskor trtnik ez meg)
// #define UARTPININIT   TRISCbits.TRISC6 = 0; TRISCbits.TRISC7 = 1

//------------------------------------------------------------------------------
// Teszt (vteli puffer programbl is fetlthet lesz, ha engedlyezzk)
// #define UARTDEBUG

//------------------------------------------------------------------------------
// csak PIC18xxx: melyik priorits megszaktst hasznlja a soros port
// lehetsges rtkei:
// - -1 : nincs a tbbszint priorits hasznlva (ilyenkor minden csak a HIGH interruptban megy)
// -  0 : alacsony priorits
// -  1 : magas priorits
#define RXPR18        -1
#define TXPR18        -1

//******************************************************************************
// Innentl kezdve nem kell belenylni !
//
//==============================================================================
extern volatile unsigned char uRxLength; // vteli pufferban lev byte-ok szma
extern volatile unsigned char uRxBufFree;// vteli pufferben mennyi a szabad hely
extern volatile unsigned char uTxLength; // ads pufferben lev byte-ok szma
extern volatile unsigned char uTxBufFree;// ads pufferben mennyi a szabad hely

void UartInit(void);                   // inicializls

unsigned char UartRx(void);            // egy karakter vtele (ha van mit)
unsigned char UartRxTop(void);         // a vteli puffer legelsnek berakott eleme, de nem trldik a pufferbl
#ifdef  UARTDEBUG
void UartRxWrite(unsigned char ch);    // tesztelshez fel lehet tlteni a vteli puffert
#else
#define UartRxWrite(ch)  ;
#endif

void UartRxProcess(void);              // uart vtel polling vagy megszakts kiszolgl fggvny
#define UartRxIntProcess() if(PIE1bits.RCIE && PIR1bits.RCIF)UartRxProcess()

void UartTx(unsigned char ch);         // egy karakter kldse (pufferelt mdon)
void UartTxProcess(void);              // uart ads polling vagy megszakts kiszolgl fggvny
#define UartTxIntProcess() if(PIE1bits.TXIE && PIR1bits.TXIF)UartTxProcess()

#endif // __UART_H
