#include <p18cxxx.h>
#include "uart.h"
#include "HardwareProfile.h"

#pragma udata UART_BUFFER = UARTBUFFERADDR
char uRxBuffer[URXBUFFERSIZE];         // vteli buffer
char uTxBuffer[UTXBUFFERSIZE];         // ads buffer

#pragma udata

// vtel
//char uRxBufferLost = 0;
volatile unsigned char  uRxStart = 0, uRxLength = 0, uRxBufFree = URXBUFFERSIZE;

// ads
volatile char uTxBufferLost = 0;
volatile unsigned char  uTxStart = 0, uTxLength = 0, uTxBufFree = UTXBUFFERSIZE;

#define TRIS_(p, m)            TRIS ## p ## bits.TRIS ## p ## m
#define LAT_(p, m)             LAT ## p ## bits.LAT ## p ## m
#define PORT_(p, m)            PORT ## p ## bits.R ## p ## m

#define IOIN(x)                x(TRIS_) = 1
#define IOOUT(x)               x(TRIS_) = 0
#define SET(x)                 x(LAT_) = 1
#define CLR(x)                 x(LAT_) = 0
#define GET(x)                 x(PORT_)

//=============================================================================
void UartInit(void)
{
  #define BAUDDIV (SystemClock/BAUDRATE)

  #if BAUDDIV < (65536*4)
  #define BRG_DIV          4
  #define CLKSEL           1
  #elif BAUDDIV < (65536*16)
  #define BRG_DIV         16
  #define CLKSEL           0
  #else
  #error "PIC18: ez a BAUDRATE nem elllthat"
  #endif // BAUDDIV

  #define BAUDRATEREG ((SystemClock+((BRG_DIV/2)*BAUDRATE))/BRG_DIV/BAUDRATE-1)
  SPBRG = BAUDRATEREG;                  // als byte;
  SPBRGH = BAUDRATEREG >> 8;            // fels byte
  TXSTAbits.BRGH = CLKSEL;              // lo/hi speed
  BAUDCONbits.BRG16 = 1;                // 16 bites
  IOIN(UARTRX); IOOUT(UARTTX);          // RX bemenet, TX kimenet
  RCSTAbits.SPEN = 1;                   // soros port eng
  TXSTAbits.SYNC = 0;                   // aszinkron md

  #if (RXPR18 == -1 && TXPR18 != -1) || (TXPR18 == -1 && RXPR18 != -1)
  #error "Hiba: priorits nlkli hasznlat esetn az RX s a TX-nek is annak kell lennie!"
  #endif

  #if RXPR18 == -1

  #elif RXPR18 == 0
  IPR1bits.RCIP = 0;                    // alacsony priorits
  #elif RXPR18 == 1
  IPR1bits.RCIP = 1;                    // magas priorits
  #endif

  #if TXPR18 == -1

  #elif TXPR18 == 0
  IPR1bits.TXIP = 0;                    // alacsony priorits
  RCONbits.IPEN = 1;                    // ktszint IRQ eng
  #elif TXPR18 == 1
  IPR1bits.TXIP = 1;                    // magas priorits
  RCONbits.IPEN = 1;                    // ktszint IRQ eng
  #endif
   
  TXSTAbits.TXEN = 1;                   // ads engedlyezs
  RCSTAbits.CREN = 1;                   // vtel engedlyezs
  PIE1bits.RCIE  = 1;                   // vtel IRQ eng 
  // ads megszakts engedlyezst csak forgalmazskor kell megtenni, ha mr TXREG nem szabad
  
//  INTCONbits.GIEL = 1;                  // globlis IRQ eng
//  INTCONbits.GIEH = 1;                  // globlis IRQ eng
  INTCONbits.PEIE = 1;                  // perifria IRQ eng
}

//=============================================================================
// Rx pufferbl egy byte-ot kiolvas, trldik is a pufferbl
unsigned char UartRx(void)
{
  unsigned char ch;
  ch = 0;
  PIE1bits.RCIE = 0;                    // megszakts tilts (hogy ne vltozhasson meg kzben a puffermutat)
  if(uRxLength)                         // van mg adat a pufferben ?
  {
    ch = uRxBuffer[uRxStart++];
    uRxStart &= (URXBUFFERSIZE - 1);
    uRxLength--; uRxBufFree++;
  }
  PIE1bits.RCIE = 1;                    // megszakts engedlyezs
  return ch;
}

//=============================================================================
// Rx pufferbl gy olvas ki egy byte-ot hog nem trldik a pufferbl
unsigned char UartRxTop(void)
{
  return uRxBuffer[uRxStart];
}

//=============================================================================
void UartRxProcess(void)
{
  unsigned char c;
  c = RCREG;
  if(RCSTAbits.FERR | RCSTAbits.OERR)
  {
    RCSTAbits.CREN = 0; //clear error (if any)
    RCSTAbits.CREN = 1; //Enables Receiver
  }
  else
  {
    if (uRxLength != (URXBUFFERSIZE - 1)) // van mg hely a pufferben ?
    {   
      uRxBuffer[(uRxStart + uRxLength) & (URXBUFFERSIZE - 1)] = c; // egy karakter megy a pufferbe
      uRxLength++; uRxBufFree--;
    }
  }
  PIR1bits.RCIF = 0;
}

#ifdef UARTDEBUG
//=============================================================================
void UartRxWrite(unsigned char ch)
{
  if (uRxLength != (URXBUFFERSIZE - 1)) // van mg hely a pufferben ?
  {   
    uRxBuffer[(uRxStart + uRxLength) & (URXBUFFERSIZE - 1)] = ch; // egy karakter megy a pufferbe
    uRxLength++; uRxBufFree--;
  }
}
#endif

//=============================================================================
void UartTx(unsigned char ch)
{
  if (!uTxLength && PIR1bits.TXIF)      // buffer res, s TXREG rht
  {
    TXREG = ch;
  }
  else
  {
    PIE1bits.TXIE = 0;                  // TX IRQ tilts (hogy a megszakts ne nyljon hozz a puffermutatkhoz)
    if(uTxBufFree)                      // van mg hely a pufferben ?
    {   
      uTxBuffer[(uTxStart + uTxLength) & (UTXBUFFERSIZE - 1)] = ch; // egy karakter megy a pufferbe
      uTxLength++; uTxBufFree--;
    }
    else
      uTxBufferLost = 1;                // itt jelezzk hogy buffertlcsorduls miatt adatveszts trtnt
    PIE1bits.TXIE = 1;                  // TX IRQ engedlyezs
  }
}
//=============================================================================
void UartTxProcess(void)
{
  PIR1bits.TXIF = 0;                    // megszakts forrs jelzs trlse
  if(!uTxLength)                        // ha mr nincs mit adni
    PIE1bits.TXIE = 0;                  // TX IRQ tilts
  else
  {
    TXREG = uTxBuffer[uTxStart++];      // TXREG = adat mehet
    uTxStart &= (UTXBUFFERSIZE - 1);
    uTxLength--; uTxBufFree++;
  }
}
