/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>

/** C O N F I G U R A T I O N ************************************************/
        #pragma config PLLDIV   = 5         // (20 MHz crystal on PICDEM FS USB board)
        #pragma config CPUDIV   = OSC1_PLL2	
        #pragma config USBDIV   = 2         // Clock source from 96MHz PLL/2
        #pragma config FOSC     = HSPLL_HS
        #pragma config FCMEN    = OFF
        #pragma config IESO     = OFF
        #pragma config PWRT     = OFF
        #pragma config BOR      = ON
        #pragma config BORV     = 3
        #pragma config VREGEN   = ON		//USB Voltage Regulator
        #pragma config WDT      = OFF
        #pragma config WDTPS    = 32768
        #pragma config MCLRE    = ON
        #pragma config LPT1OSC  = OFF
        #pragma config PBADEN   = OFF
        #pragma config CCP2MX   = ON
        #pragma config STVREN   = ON
        #pragma config LVP      = OFF
        #pragma config ICPRT    = ON       // Dedicated In-Circuit Debug/Programming def: OFF
        #pragma config XINST    = OFF       // Extended Instruction Set
        #pragma config CP0      = OFF
        #pragma config CP1      = OFF
        #pragma config CP2      = OFF
        #pragma config CP3      = OFF
        #pragma config CPB      = OFF
        #pragma config CPD      = OFF
        #pragma config WRT0     = OFF
        #pragma config WRT1     = OFF
        #pragma config WRT2     = OFF
        #pragma config WRT3     = OFF
        #pragma config WRTB     = ON       // Boot Block Write Protection
        #pragma config WRTC     = ON		// Configuration Register Write Protection bit
        #pragma config WRTD     = OFF
        #pragma config EBTR0    = OFF
        #pragma config EBTR1    = OFF
        #pragma config EBTR2    = OFF
        #pragma config EBTR3    = OFF
        #pragma config EBTRB    = OFF

/** V A R I A B L E S ********************************************************/
#pragma udata

/** P R I V A T E  P R O T O T Y P E S ***************************************/

/** V E C T O R  R E M A P P I N G *******************************************/

extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code _RESET_INTERRUPT_VECTOR = 0x000800
void _reset (void)
{
    _asm goto _startup _endasm
}
#pragma code

#pragma code _HIGH_INTERRUPT_VECTOR = 0x000808
void _high_ISR (void)
{
    ;
}

#pragma code _LOW_INTERRUPT_VECTOR = 0x000818
void _low_ISR (void)
{
    ;
}
#pragma code

/** D E C L A R A T I O N S **************************************************/
#pragma code

/** L E D ***********************************************************/
#define mInitAllLEDs()      LATEbits.LATE0=0; TRISEbits.TRISE0=0;

#define mLED_1              LATEbits.LATE0

#define mLED_1_On()         mLED_1 = 1;

#define mLED_1_Off()        mLED_1 = 0;

#define mLED_1_Toggle()     mLED_1 = !mLED_1;

/** S W I T C H *****************************************************/
#define mInitSwitch()  TRISEbits.TRISE1=1
#define sw             PORTEbits.RE1

void main(void)
{
    ADCON1 |= 0x0F;                 // Default all pins to digital
    mInitSwitch();
    mInitAllLEDs();
    while(1)
    {
		mLED_1 = sw;
    }//end while
}//end main

/** EOF Demo02.c *************************************************************/
