/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include "io_cfg.h"

/** V A R I A B L E S ********************************************************/
#pragma udata

/** P R I V A T E  P R O T O T Y P E S ***************************************/
void init();
void InterruptHandlerHigh ();
void InterruptHandlerLow ();

/** V E C T O R  R E M A P P I N G *******************************************/
extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code _RESET_INTERRUPT_VECTOR = 0x000800
void _reset (void)
{
    _asm goto _startup _endasm
}
#pragma code

#pragma code _HIGH_INTERRUPT_VECTOR = 0x000808
void _high_ISR (void)
{
  _asm
    goto InterruptHandlerHigh //jump to interrupt routine
  _endasm
}

#pragma code _LOW_INTERRUPT_VECTOR = 0x000818
void _low_ISR (void)
{
  _asm
    goto InterruptHandlerLow //jump to interrupt routine
  _endasm
}

#pragma code

#pragma interrupt InterruptHandlerHigh
void InterruptHandlerHigh () {
    if (INTCONbits.RBIF) {
		INTCONbits.RBIF = 0;
		mLED_1_Toggle();
	}
}

#pragma interrupt InterruptHandlerLow
void InterruptHandlerLow () {
	;
}
/** D E C L A R A T I O N S **************************************************/
#pragma code

void main(void) {
	init();
    while(1) {
		;
    }//end while
}//end main

void init(void) {
	ADCON0 = 0;
    ADCON1 = 0x0F;                 // Default all pins to digital
    mInitSwitch();
    mInitAllLEDs();

	INTCON = 0b11001000;			// enable all and RB change interrupts
	INTCON2bits.RBPU = 1;			// PORTB pull-up disable
	INTCON2bits.RBIP = 1;			// RB port interrupt set to high priority
	RCONbits.IPEN = 1;				// Enable priority levels
	INTCONbits.GIEH = 1;          	// Enable interrupts
}

/** EOF main.c *************************************************************/
