#ifndef IO_CFG_H
#define IO_CFG_H

/** I N C L U D E S *************************************************/
//#include "usbcfg.h"

/** T R I S *********************************************************/
#define INPUT_PIN           1
#define OUTPUT_PIN          0

/** U S B ***********************************************************/
#define tris_usb_bus_sense  TRISAbits.TRISA1    // Input

#if defined(USE_USB_BUS_SENSE_IO)
#define usb_bus_sense       PORTAbits.RA1
#else
#define usb_bus_sense       1
#endif

#define tris_self_power     TRISAbits.TRISA2    // Input

#if defined(USE_SELF_POWER_SENSE_IO)
#define self_power          PORTAbits.RA2
#else
#define self_power          1
#endif

/** L E D ***********************************************************/
#define mInitAllLEDs()      LATEbits.LATE0=0; TRISEbits.TRISE0=0;

#define mLED_1              LATEbits.LATE0

#define mLED_1_On()         mLED_1 = 1;

#define mLED_1_Off()        mLED_1 = 0;

#define mLED_1_Toggle()     mLED_1 = !mLED_1;

/** S W I T C H *****************************************************/
#define mInitSwitch()   TRISEbits.TRISE1 = 1; TRISBbits.TRISB5 = 1
#define sw1             PORTEbits.RE1
#define sw2				PORTBbits.RB5

#endif //IO_CFG_H
