
#include "fi1216mk2.h"
#include "i2c.h"

#define ADDRESS_MASK	0b11000000
#define IF_FREQUENCY	35100000	// Sound IF frequency in Hz

static unsigned char tuner_address = 0;
static unsigned char tuner_stepsize = 0;
static unsigned long last_frequency = 0;

char tuner_init(unsigned char address, unsigned char step_size)
{
	if (address >= 4)
		return 1;

	tuner_address = (address << 1) & 0b00000110;
	last_frequency = 0;
	tuner_stepsize = step_size;
	return 0;
}

void tuner_set(unsigned char band, unsigned int divider)
{
	unsigned char db1, db2, cb, pb;

	db1 = (divider >> 8) & 0x7f;
	db2 = divider & 0xff;

	cb = 0b00000000;
	cb |= 0b10001000;
	pb = 0b10100000;

	i2c_start();
	i2c_write(ADDRESS_MASK | tuner_address);
	i2c_write(db1);
	i2c_write(db2);
	i2c_write(cb);
	i2c_write(pb);
	i2c_stop();
}

void tuner_set_receiving_freq(unsigned long freq)
{
	unsigned int stepsize;
	unsigned int divider;
	unsigned char db1, db2, cb, pb;

	if (tuner_stepsize == TUNER_STEPSIZE_31_25KHZ) {
		stepsize = 31250;
		cb = 0b00000010;
	} else if (tuner_stepsize == TUNER_STEPSIZE_50KHZ) {
		stepsize = 50000;
		cb = 0b00000000;
	} else {
		stepsize = 62500;
		cb = 0b00000110;
	}

	divider = (freq + IF_FREQUENCY) / stepsize;

	if (freq < 170000000) {
		pb = 0b10100000;
	} else if (freq < 450000000) {
		pb = 0b10010000;
	} else {
		pb = 0b00110000;
	}

	db1 = (divider >> 8) & 0x7f;
	db2 = divider & 0xff;

	cb |= 0b10001000;

	if (freq > last_frequency) {
		i2c_start();
		i2c_write(ADDRESS_MASK | tuner_address);
		i2c_write(db1);
		i2c_write(db2);
		i2c_write(cb);
		i2c_write(pb);
		i2c_stop();
	} else {
		i2c_start();
		i2c_write(ADDRESS_MASK | tuner_address);
		i2c_write(cb);
		i2c_write(pb);
		i2c_write(db1);
		i2c_write(db2);
		i2c_stop();
	}

	last_frequency = freq;
}	

unsigned char tuner_get_status(void)
{
	unsigned char data;

	i2c_start();
	i2c_write(ADDRESS_MASK | tuner_address | 1);
	data = i2c_read_noack();
	i2c_stop();

	return data;
}