
#include <pic.h>
#include "i2c.h"

void i2c_wait_for_idle(void)
{
 	// wait for idle and not writing
	while ((SSPCON2 & 0x1F) | RW) 
	{
	};
}

void i2c_start(void)
{
	i2c_wait_for_idle();
	SEN=1;
}

void i2c_stop(void)
{
	i2c_wait_for_idle();
	PEN = 1;
}

void i2c_repeated_start(void)
{
	i2c_wait_for_idle();
	RSEN = 1;
}

unsigned char i2c_read(unsigned char ack)
{
	unsigned char data;

	i2c_wait_for_idle();
	RCEN = 1;
	i2c_wait_for_idle();
 	data = SSPBUF;
	i2c_wait_for_idle();

	if (ack)
		ACKDT = 0;
	else
		ACKDT = 1;
    
	// send acknowledge sequence
	ACKEN = 1;
	
	return data;
}

unsigned char i2c_read_noack(void)
{
	unsigned char data;

	i2c_wait_for_idle();
	RCEN = 1;
	i2c_wait_for_idle();
 	data = SSPBUF;
	i2c_wait_for_idle();
	return data;
}

unsigned char i2c_write(unsigned char data)
{
	unsigned char i;
	i2c_wait_for_idle();
	SSPBUF = data;
	// wait for acknowledge
	for (i = 0; ACKSTAT && i < 100; ++i)
		{};
	return 0;
}

char i2c_init(char baud)
{
	// set SCL and SDA pins as inputs
	TRISC3 = 1;           
	TRISC4 = 1;

	// set I2C master mode
	SSPCON = 0x38;
	SSPCON2 = 0x00;

    // 100k at 8Mhz clock
	SSPADD = 19;

	CKE = 1;
	SMP = 1;

	SSPIF = 0;
	// clear bus collision flag
	BCLIF = 0;

	return 0;
}
