
#include <pic.h> 
#include <float.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>

#include "lcd.h"
#include "delay.h"
#include "i2c.h"
#include "fi1216mk2.h"

#define	segment_a			0b00100000
#define	segment_b			0b00010000
#define	segment_c			0b00000001
#define	segment_d			0b00001000
#define	segment_e			0b10000000
#define	segment_f			0b01000000
#define	segment_g			0b00000100
#define	segment_dp			0b00000010

#define	digit_0		segment_a | segment_b | segment_c | segment_d | segment_e | segment_f
#define	digit_1		segment_b | segment_c
#define	digit_2		segment_a | segment_b | segment_g | segment_e | segment_d
#define	digit_3		segment_a | segment_b | segment_c | segment_d | segment_g
#define	digit_4		segment_b | segment_c | segment_f | segment_g
#define	digit_5		segment_a | segment_f | segment_g | segment_c | segment_d
#define	digit_6		segment_a | segment_f | segment_g | segment_e | segment_c | segment_d
#define	digit_7		segment_f | segment_a | segment_b | segment_c
#define	digit_8		segment_a | segment_b | segment_c | segment_d | segment_e | segment_f | segment_g
#define	digit_9		segment_a | segment_b | segment_c | segment_d | segment_f | segment_g
#define	digit_a		segment_a | segment_b | segment_c | segment_f | segment_e | segment_g
#define	digit_b		segment_c | segment_d | segment_e | segment_f | segment_g
#define	digit_c		segment_a | segment_d | segment_e | segment_f
#define	digit_d		segment_b | segment_c | segment_d | segment_e | segment_g
#define	digit_e		segment_a | segment_d | segment_e | segment_f | segment_g
#define	digit_f		segment_a | segment_e | segment_f | segment_g

static unsigned const char digit_lut [16] = 
{
	digit_0, digit_1, digit_2, digit_3, digit_4, digit_5,
	digit_6, digit_7, digit_8, digit_9, digit_a, digit_b,
	digit_c, digit_d, digit_e, digit_f
};


char digits[8];
char counter;

void init(void)
{
	char i;

	TRISB = 0;

	// buttons
	TRISC6 = 1;           
	TRISC7 = 1;

	for (i = 0; i < sizeof(digits); ++i)
		digits[i] = 0;

	lcd_init();
	i2c_init(I2C_BAUD_100KHZ);
//	tuner_init(0, TUNER_STEPSIZE_50KHZ);
	tuner_init(0, TUNER_STEPSIZE_50KHZ);
//	tuner_init(0, TUNER_STEPSIZE_31_25KHZ);
}

void display_digits(void)
{
	char i;

	for (i = 0; i < sizeof(digits); ++i)
	{
		PORTB = 1 << i;
		PORTD = digit_lut[digits[i & 0x0f]];
	}
}

void print_number(unsigned long n)
{
	char buffer[20];
	char i = 19;
	buffer[i--] = 0;
	while (n > 0) 
	{
		char c = n % 10;
		buffer[i--] = c + '0';
		n /= 10;
	}
	lcd_write_string(&buffer[i+1]);
}

void print_number_sep(unsigned long n)
{
	char buffer[20];
	char i = 19;
	char j = 0;
	buffer[i--] = 0;
	while (n > 0) 
	{
		char c = n % 10;
		if (j > 2) 
		{
			j = 0;
			buffer[i--] = '.';
		}
		buffer[i--] = c + '0';
		n /= 10;
		++j;
	}
	lcd_write_string(&buffer[i+1]);
}

unsigned long f = 100000000;
signed char multiplier = 0;
signed char kbd_delay = 0;

void check_kbd(void)
{
	if ((PORTC & 0b11000000) == 0)
	{
		multiplier = 0;
		kbd_delay = 0;
	}

	if (PORTC & 0b10000000) 
	{
		if (kbd_delay < 20) 
		{
			if (kbd_delay == 0)
				multiplier = 1;
			else
				multiplier = 0;
			++kbd_delay;
		} else if (kbd_delay < 40) {
			++kbd_delay;
			multiplier = 1;			
		} else {
			++multiplier;
		}
	}

	if (PORTC & 0b01000000) 
	{
		if (kbd_delay > -20) 
		{
			if (kbd_delay == 0)
				multiplier = -1;
			else
				multiplier = 0;
			--kbd_delay;
		} else if (kbd_delay > -40) {
			--kbd_delay;
			multiplier = -1;			
		} else {
			--multiplier;
		}
	}

	if (multiplier > 100)
		multiplier = 100;
	if (multiplier < -100)
		multiplier = -100;

	f += (50000 * (multiplier));
	
	if (f < 48000000)
		f = 48000000;
	if (f > 855000000)
		f = 855000000;
}

void run(void)
{
	unsigned char status;
	unsigned char i = 0;
	counter = 100;
	while (1)
	{
		check_kbd();

		tuner_set_receiving_freq(f);
		for (i = 0; i < 255; )
		{
			status = tuner_get_status();
			if (status & TUNER_STATUS_LOCKED)
				break;
		}

		lcd_set_address(0);
		print_number_sep(f);
		lcd_write_string(" Hz ");

//		delay(10);
	}
}

main()
{
	init();
	run();
}  