
#include <pic.h>
#include "lcd.h"
#include "delay.h"

#define LCD_PORT	PORTD

#define	LCD_RS		PORTD1
#define	LCD_RW		PORTD0
#define	LCD_EN		PORTD2

#define	LCD_RS_BIT		0b00000010;
#define	LCD_RW_BIT		0b00000001;
#define	LCD_EN_BIT		0b00000100;

// Send one nibble
static void send_command_nibble(unsigned char b)
{
	b &= 0b11110000;
	LCD_PORT = b;
	delay2(10);
	b ^= LCD_EN_BIT;
	LCD_PORT = b;
	delay2(10);
	b ^= LCD_EN_BIT;
	LCD_PORT = b;
	delay2(10);
}

static void send_data_nibble(unsigned char b)
{
	b &= 0b11110000;
	b |= LCD_RS_BIT;
	LCD_PORT = b;
	delay2(10);
	b ^= LCD_EN_BIT;
	LCD_PORT = b;
	delay2(10);
	b ^= LCD_EN_BIT;
	LCD_PORT = b;
	delay2(10);
}

// Send a byte in 4-bit mode
static void send_data_byte(unsigned char b)
{
	send_data_nibble(b);
	send_data_nibble(b << 4);
}

static void send_command_byte(unsigned char b)
{
	send_command_nibble(b);
	send_command_nibble(b << 4);
}

void lcd_init(void)
{
	// set up port for output
	TRISD = 0;

	// power-up delay
	delay(50);

	// reset lcd, ensure we are in 8-bit mode before switch to 4 bit
	send_command_nibble(0x30);
	send_command_nibble(0x30);
	send_command_nibble(0x30);

	delay(10);

	// switch to 4 bit mode
	send_command_nibble(0x20);
	send_command_byte(0x28);

	// reset display
	send_command_byte(0b00000010);

	send_command_byte(0b00000110);

	// turn on display
	send_command_byte(0b00001100);

	lcd_clear();
}

void lcd_clear(void)
{
	send_command_byte(1);
}

void lcd_write_char(char c)
{
	send_data_byte(c);
}


void lcd_set_address(unsigned char address)
{
	send_command_byte(0b10000000 | (address & 0b01111111));
}

void lcd_write_string(const char *str)
{
	while (*str)
		send_data_byte(*str++);
}

