;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    FLAsH.ASM                                         *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    PIC16F87x FLASH PROGRAM MEMRIA R/OLVAS DEMO PROGRAM          *
;    -------------------------------------------------------          *
;    A program a FLASH memria 0x050 cm rekeszbe 0x666-ot r,      *
;    majd a 0x001 cm rekesz tartalmt a FLASH_Data_Lo illetve a     *
;    FLASH_Data_Hi vltozkba olvassa be.			      *
;                                                                     *
;**********************************************************************
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _WRT_ENABLE_ON
;----------------------------------------------------------------------
;
FLASH_Addr_Lo	equ     124              	; FLASH cm tmeneti tr
FLASH_Addr_Hi	equ     125              	; FLASH cm tmeneti tr
FLASH_Data_Lo	equ     126             	; FLASH adat tmeneti tr
FLASH_Data_Hi	equ     127             	; FLASH adat tmeneti tr
;
; Megjegyzs:
; -----------
; 1/ A PIC16F877 esetn a BANK0 70h..7Fh terlete minden BANK-bl elrhet.
; 2/ A 70h valamint az 1EBh..1EFh memriaterlet foglalt az MPLAB-ICD szmra!
;
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
		org     0             		; reset vektor
		nop				; MPLAB-ICD miatt szksges
;----------------------------------------------------------------------
Start		bsf	STATUS,RP0	
		bcf	STATUS,RP1		; bank1 kivlaszts
		movlw	14
		movwf	ADCON1			; RA0 analg bemenet !!!
		movlw	B'00111111'    		; PORTA bemenet
		movwf	TRISA
		bcf	STATUS,RP0		; bank0 kivlaszts
;----------------------------------------------------------------------
; FLASH memria rs
;
        	movlw   0x50			; memria cm als bjt
        	movwf   FLASH_Addr_Lo
        	movlw   0			; memria cm fels bitek
        	movwf   FLASH_Addr_Hi
        	movlw   0x66			; memria adat als bjt
        	movwf   FLASH_Data_Lo
        	movlw   0x06			; memria adat fels bitek
        	movwf   FLASH_Data_Hi
        	call    FLASH_write		; FLASH memria rs
;----------------------------------------------------------------------
; FLASH memria olvass
;
	     	movlw   1
        	movwf   FLASH_Addr_Lo
        	movlw   0
        	movwf   FLASH_Addr_Hi
        	call    FLASH_read		; FLASH memria olvass	
;----------------------------------------------------------------------
Stop		goto    Stop			; vrakozs resetre
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;***************************** SZUBRUTINOK ****************************
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
FLASH_write 	bcf     STATUS,RP0      
		bsf     STATUS,RP1		; bank2 kivlaszts
		movf	FLASH_Addr_Lo,0
		movwf	EEADR			; aktulis cm als bjt
		movf	FLASH_Addr_Hi,0
		movwf	EEADRH			; aktulis cm fels bitjei
		movf	FLASH_Data_Lo,0
		movwf	EEDATA			; aktulis adat als bjt
		movf	FLASH_Data_Hi,0
		movwf	EEDATH			; aktulis adat fels bitek
		bsf     STATUS,RP0		; bank3 kivlaszts
        	bsf     EECON1,EEPGD		; prg. memria kivlaszts
        	bsf     EECON1,WREN		; rs engedlyezs
        	bcf	INTCON,GIE
        	movlw   55h			; ***********************
        	movwf   EECON2			; *   rsi szekvencia  *
        	movlw   0aah			; *                     *
        	movwf   EECON2			; ***********************
        	bsf     EECON1,WR
;----------------------------------------------------------------------
        	nop				; ezt a kt utastst a mikrovezrl
        	nop				; figyelmen kvl hagyja
;----------------------------------------------------------------------
		bcf     EECON1,WREN		; tovbbi rs letiltsa
        	return
;----------------------------------------------------------------------
FLASH_read  	bcf     STATUS,RP0
		bsf     STATUS,RP1		; bank2 kivlaszts
		movf	FLASH_Addr_Lo,0
		movwf	EEADR			; aktulis cm als bjt
		movf	FLASH_Addr_Hi,0
		movwf	EEADRH			; aktulis cm fels bitjei
		bsf     STATUS,RP0		; bank3 kivlaszts
        	bsf     EECON1,EEPGD		; prg. memria kivlaszts
        	bsf     EECON1,RD		; EEPROM olvass
;----------------------------------------------------------------------
        	nop				; ezt a kt utastst a mikrovezrl
        	nop				; figyelmen kvl hagyja
;----------------------------------------------------------------------
        	bcf     STATUS,RP0		; bank2 kivlaszts
        	movf    EEDATA,0
        	movwf	FLASH_Data_Lo		; kiolvasott adat (lo) msolsa
        	movf    EEDATH,0
        	movwf	FLASH_Data_Hi		; kiolvasott adat (hi) msolsa 
        	return
;----------------------------------------------------------------------
                end

