
; PicBasic Pro Compiler 2.40, (c) 1998, 2001 microEngineering Labs, Inc. All Rights Reserved. 
PM_USED			EQU	1

	INCLUDE	"16F628.INC"

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
FLAGS           		EQU	RAM_START + 012h
GOP             		EQU	RAM_START + 013h
RM1             		EQU	RAM_START + 014h
RM2             		EQU	RAM_START + 015h
RR1             		EQU	RAM_START + 016h
RR2             		EQU	RAM_START + 017h
_Temp            		EQU	RAM_START + 018h
_count_remain    		EQU	RAM_START + 01Ah
_PORTL           		EQU	PORTB
_PORTH           		EQU	PORTA
_TRISL           		EQU	TRISB
_TRISH           		EQU	TRISA
_Temp_LOWBYTE    		EQU	_Temp
_Temp_HIGHBYTE   		EQU	_Temp + 001h
#define _DQ              	_PORTA_3
#define _Led             	_PORTA_4
#define _soros           	_PORTA_2
#define _PORTA_3         	PORTA, 003h
#define _PORTA_4         	PORTA, 004h
#define _PORTA_2         	PORTA, 002h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
	INCLUDE	"ADO.MAC"
	INCLUDE	"PBPPIC14.LIB"

	MOVE?CB	000h, TRISB
	MOVE?CB	008h, TRISA
	PAUSE?C	064h

	LABEL?L	_Meres	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	044h
	OWEND?	

	LABEL?L	_Varj	
	OWPIN?T	_DQ
	OWMODE?C	004h
	OWIN?B	_count_remain
	OWEND?	
	CMPEQ?BCL	_count_remain, 000h, _Varj
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	0BEh
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	000h
	OWIN?B	_Temp_LOWBYTE
	OWIN?B	_Temp_HIGHBYTE
	OWEND?	
	CMPNE?BCL	_Temp_HIGHBYTE, 0FFh, L00001
	XOR?BCB	_Temp_LOWBYTE, 0FFh, _Temp_LOWBYTE
	ADD?BCB	_Temp_LOWBYTE, 001h, _Temp_LOWBYTE
	LABEL?L	L00001	
	MOVE?CT	001h, _Led
	SERPIN?T	_soros
	SERMODE?C	_N1200
	SEROUT?C	04Bh
	SEROUT?B	_Temp_LOWBYTE
	SEROUT?B	_Temp_HIGHBYTE
	MOVE?CT	000h, _Led
	NAP?C	007h
	GOTO?L	_Meres
	END?	

	END
