#!/usr/bin/perl

use strict;
use File::Basename qw/dirname/;
use Data::Dumper;

my $dir = dirname($0);

opendir DH, $dir or die "Can't open dir!";
my @fileNames = sort grep { /\.bmp$/i } readdir(DH);
closedir DH;

my $output = "#include \"fonts.h\"\n";

my $output2 = "#ifndef _FONTS_H_\n".
              "#define _FONTS_H_\n\n".
              "#include \"osctypes.h\"\n\n".
              "typedef struct {\n".
              "  BYTE w;\n".
              "  BYTE h;\n".
              "  BYTE *def;\n".
              "} FONT;\n\n";


for my $fileName (@fileNames)
{
$output .= "\n";
open FH, "<", "$dir/$fileName" or die "Can't open file, $!\n";
my $content;
read FH, $content, 10000000;
close FH;

die "Not a Windows BMP file!" if substr($content,0,2) ne 'BM';

my $start = read_dword(\$content, 10);
my $width = read_dword(\$content, 18);
my $height = read_dword(\$content, 22);

die "Only 1 panes are supported!" if read_word(\$content,26) != 1;
die "1 bit black and white BMP is required!" if read_word(\$content,28) != 1;
die "BMP compression is not supported!" if read_dword(\$content,30) != 0;

my $fontHeight = ($height / 6) - 1;
my $fontWidth  = ($width  / 16) - 1;

my $row_size = int($width/8);
$row_size++ if $row_size * 8 != $width;
my $lastRow = ($fontHeight+1)*6-1;

my $get_bit = sub {
  my ($x,$y) = @_;
  
  my $off = $start + $row_size * ($lastRow-$y);

  my $data = substr($content, $off + int($x/8), 1);
  my $msk = 128;
  my $cnt = $x & 7;
  $msk /= 2 while $cnt--;
  $msk = int($msk);
  return ( ord($data) & $msk ) ? 1 : 0;
};

$output .= "BYTE font_${fontWidth}x${fontHeight}_def [] PROGMEM = {\n";
$output2 .= "extern FONT *font_${fontWidth}x${fontHeight};\n";
for( my $char = 0; $char < 96; $char++)
{
  $output .= "  ";
  my $xoff = ($char & 15) * ($fontWidth+1);
  my $yoff = int($char / 16) * ($fontHeight+1);

  for( my $x = 0; $x < $fontWidth; $x++ )
  {
    my $data;
    my $msk = 128;
    for( my $y = 0; $y < $fontHeight; $y++ )
    {
      if( $get_bit->($xoff + $x, $yoff + $y ) )
      {
        $data |= $msk;
      }
      $msk = int($msk/2);
    }
    $output .= sprintf( "0x%02x, ", $data );
  }
  $output =~ s/, $/  /s if $char == 95;
  
  $output .= " /* " . chr($char+32) . " */";
  $output .= "\n";
}

$output .= "};\n\n";
$output .= "FONT font_${fontWidth}x${fontHeight}_impl = {${fontWidth}, ${fontHeight}, font_${fontWidth}x${fontHeight}_def};\n";
$output .= "FONT *font_${fontWidth}x${fontHeight} = &font_${fontWidth}x${fontHeight}_impl;\n";
}
$output2 .= "\n#endif\n";

open FH, ">", "$dir/fonts.c" or die "Can't open output source file!";
print FH $output;
close FH;

open FH2, ">", "$dir/fonts.h" or die "Can't open output source file!";
print FH2 $output2;
close FH2;

sub read_dword {
  my ($bmp_ref, $offs) = @_;
  return ord(substr($$bmp_ref,$offs,1)) + (ord(substr($$bmp_ref,$offs+1,1)) * 256) +
             (ord(substr($$bmp_ref,$offs+2,1)) * 65536) + (ord(substr($$bmp_ref,$offs+3,1)) * 0x1000000)
}

sub read_word {
  my ($bmp_ref, $offs) = @_;
  return ord(substr($$bmp_ref,$offs,1)) + (ord(substr($$bmp_ref,$offs+1,1)) * 256);
}
