 /* @file Idokapcsolo.ino
        || @version 1.0
        || @author kapu48
        || @contact
        ||
        || @description
        || | Demonstrates changing the keypad size and key values.
        || #
        */
 #include <MenuBackend.h> //MenuBackend library - copyright by Alexander Brevig
 #include <LiquidCrystal_I2C.h> //this library is included in the Arduino IDE
 #include <Wire.h>
 #include <Keypad.h>
 #include "RTClib.h"

  LiquidCrystal_I2C lcd(0x27, 20, 4);

  RTC_DS1307 RTC;
        
  const int REL1 =  7;
  const int REL2 =  8;
  const int REL3 =  9;
  const int REL4 = 10;
  
  int hour;
  int minute;
  int second;
                 
  const byte ROWS = 4; //four rows
  const byte COLS = 1; //four columns
 //define the cymbols on the buttons of the keypads
   char hexaKeys[ROWS] = {'0','1','2','3'};
              
   byte rowPins[ROWS] = {5, 4, 3, 2}; //connect to the row pinouts of the keypad
   byte colPins[1] = {8}; //connect to the column pinouts of the keypad
         
 //initialize an instance of class NewKeypad
   Keypad customKeypad = Keypad( makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);
   DateTime now;
        
                      //relays adat structure
  struct relays {
 // bekapcsolás
    uint16_t Rbe_year;
    uint8_t Rbe_mon;
    uint8_t Rbe_day;                        
    uint8_t Rbe_hour;
    uint8_t Rbe_min;
    uint8_t Rbe_sec;
            
 // kikapcsolás
    uint16_t Rki_year;
    uint8_t Rki_mon;
    uint8_t Rki_day;          
    uint8_t Rki_hour;
    uint8_t Rki_min;
    uint8_t Rki_sec;           
  };
          
 // Relay flags
    #define Rbe1  0
    #define Rbe2  1
    #define Rbe3  2
    #define Rbe4  3
 
    relays relaysT[4];                 // Tömböd 4 relének
      
    uint8_t relayF = 0;                // Relék állapotjelző bitek
     
    uint8_t relayNum; 
   
    relayNum = 0;                      //0...3
    
    relayhourBe_settting(relayNum);     //ide kerül a relé száma 0 ... 3
    relayhourKi_settting(relayNum); 
    relayminuteBe_settting(relayNum); 
    relayminuteKi_settting(relayNum); 
    relaysecBe_settting(relayNum); 
    relaysecKi_settting(relayNum);     //Amit át adsz a hívott rutinak
    


//Menu variables
  MenuBackend menu = MenuBackend(menuUsed,menuChanged);
//initialize menuitems
  MenuItem menu1Item1 = MenuItem("1. Dugalj 1");
  MenuItem menuItem1SubItem1 = MenuItem("1.1 BE");
  MenuItem menuItem1SubItem2 = MenuItem("1.2 KI");
  MenuItem menu1Item2 = MenuItem("2. Dugalj 2");
  MenuItem menuItem2SubItem1 = MenuItem("2.1 BE");
  MenuItem menuItem2SubItem2 = MenuItem("2.2 KI");
  MenuItem menu1Item3 = MenuItem("3. Dugalj 3");
  MenuItem menuItem3SubItem1 = MenuItem("3.1 BE");
  MenuItem menuItem3SubItem2 = MenuItem("3.2 KI");
  MenuItem menu1Item4 = MenuItem("4. Dugalj 4");
  MenuItem menuItem4SubItem1 = MenuItem("4.1 BE");
  MenuItem menuItem4SubItem2 = MenuItem("4.2 KI");
  MenuItem menu1Item5 = MenuItem(" Vissza ");


void setup()
{

  Serial.begin(9600);
  lcd.begin(20, 4);
  lcd.backlight();
  Wire.begin();
  lcd.clear();
  RTC.begin();
  
  digitalWrite(REL1, HIGH);
  digitalWrite(REL2, HIGH);
  digitalWrite(REL3, HIGH);
  digitalWrite(REL4, HIGH);
                  
  pinMode(REL1, OUTPUT);
  pinMode(REL2, OUTPUT);
  pinMode(REL3, OUTPUT);
  pinMode(REL4, OUTPUT);
  
  if (! RTC.isrunning()) {
     Serial.println("RTC is NOT running!");
  // Beállítja az RTC dáum és idő vázlatát
     RTC.adjust(DateTime(__DATE__, __TIME__));
       }
       
  // Valahol feltöltöd az  relay tömböt
  // bekapcsolás
                     
     relaysT[0].Rbe_hour = 10;
     relaysT[0].Rbe_min = 30;
     relaysT[0].Rbe_sec = 0;
     
     // kikapcsolás
                      
      relaysT[0].Rki_hour = 10;
      relaysT[0].Rki_min = 50;
      relaysT[0].Rki_sec = 0; 
            
   // bekapcsolás
                     
      relaysT[1].Rbe_hour = 10;
      relaysT[1].Rbe_min = 30;
      relaysT[1].Rbe_sec = 0;
            
   // kikapcsolás
                      
      relaysT[1].Rki_hour = 10;
      relaysT[1].Rki_min = 50;
      relaysT[1].Rki_sec = 0; 
            
   // bekapcsolás
                    
      relaysT[2].Rbe_hour = 10;
      relaysT[2].Rbe_min = 30;
      relaysT[2].Rbe_sec = 0;
            
   // kikapcsolás
                     
      relaysT[2].Rki_hour = 10;
      relaysT[2].Rki_min = 50;
      relaysT[2].Rki_sec = 0; 
            
   // bekapcsolás
                   
      relaysT[3].Rbe_hour = 10;
      relaysT[3].Rbe_min = 30;
      relaysT[3].Rbe_sec = 0;
            
   // kikapcsolás
                     
      relaysT[3].Rki_hour = 10;
      relaysT[3].Rki_min = 50;
      relaysT[3].Rki_sec = 0; 
            
    // Példa flag használatára
       relayF |= (1 << Rbe1);           // Jelző set
       relayF &= ~(1 << Rbe1);          // Jelző reset
     if(relayF &(~(1 << Rbe1))){};      // flag vizsgálat bekapcsoltra
     if(!(relayF &(~(1 << Rbe1)))){};   // flag vizsgálat kikapcsoltra
     
       relayF |= (1 << Rbe2);           // Jelző set
       relayF &= ~(1 << Rbe2);          // Jelző reset
     if(relayF &(~(1 << Rbe2))){};      // flag vizsgálat bekapcsoltra
     if(!(relayF &(~(1 << Rbe2)))){};   // flag vizsgálat kikapcsoltra
     
       relayF |= (1 << Rbe3);           // Jelző set
       relayF &= ~(1 << Rbe3);          // Jelző reset
     if(relayF &(~(1 << Rbe3))){};      // flag vizsgálat bekapcsoltra
     if(!(relayF &(~(1 << Rbe3)))){};   // flag vizsgálat kikapcsoltra
     
       relayF |= (1 << Rbe4);           // Jelző set
       relayF &= ~(1 << Rbe4);          // Jelző reset
     if(relayF &(~(1 << Rbe4))){};      // flag vizsgálat bekapcsoltra
     if(!(relayF &(~(1 << Rbe4)))){};   // flag vizsgálat kikapcsoltra
    }
         
  
  //Menü Konfig....
  menu.getRoot().add(menu1Item1);
  menu1Item1.addRight(menu1Item2).addRight(menu1Item3).addRight(menu1Item4).addRight(menu1Item5);
  menu1Item1.add(menuItem1SubItem1).addRight(menuItem1SubItem2);
  menu1Item2.add(menuItem2SubItem1).addRight(menuItem2SubItem2);
  menu1Item3.add(menuItem3SubItem1).addRight(menuItem3SubItem2);
  menu1Item4.add(menuItem4SubItem1).addRight(menuItem4SubItem2);
  menu1Item5.add(menu1Item5);
  
  menu.toRoot();
  lcd.setCursor(0,0);
  lcd.print("Idokapcsolo menu");
  

 }
 









void loop()
{
    DateTime now = RTC.now(); 
          
    lcd.setCursor(0, 0);
    lcd.print(now.year(), DEC);
    lcd.print('.');
    lcd.print(now.month(), DEC);
    lcd.print('.');
    lcd.print(now.day(), DEC);
    lcd.print(' ');
    lcd.setCursor(10, 0);
     if (now.hour()<10)
    lcd.print('0');
    lcd.print(now.hour(), DEC);
    lcd.print(':');
     if (now.minute()<10)
    lcd.print('0');
    lcd.print(now.minute(), DEC);
    lcd.print(':');
     if (now.second()<10)
    lcd.print('0');
    lcd.print(now.second(), DEC);
    lcd.setCursor(6, 1);
          
          
          
    for(uint8_t i = 0; i < 4; i++){
            
    // relé bekapcsol
 
    if(!(relayF &(~(1 << i)))){   // Ha flag = 0
     if((relaysT[i].Rbe_hour == now.hour()) && (relaysT[i].Rbe_min == now.minute()) && (relaysT[i].Rbe_sec == now.second())){
         digitalWrite(REL1 + i, HIGH);
         relayF |= (1 << i);   // Jelző set       
        }
       }
     // relé kikapcsol
     
     if(relayF &(~(1 << i))){   // Ha flag = 1
       if((relaysT[i].Rki_hour == now.hour()) && (relaysT[i].Rki_min == now.minute()) &&(relaysT[i].Rki_sec == now.second()) ){
           digitalWrite(REL1 + i, LOW);
           relayF &= ~(1 << i);   // Jelző reset       
          }
         }   
      }  
          
          
 // Figyeled az órát és össze hasinlítod a tömb éertékekkel! relé be
    if((relaysT[0].Rbe_hour == now.hour()) && (relaysT[0].Rbe_min == now.minute()) && (relaysT[0].Rbe_sec == now.second())){
        digitalWrite(REL1, HIGH);         
      }
  // relé ki
     if((relaysT[0].Rki_hour == now.hour()) && (relaysT[0].Rki_min == now.minute()) && (relaysT[0].Rki_sec == now.second())){
         digitalWrite(REL1, LOW);         
      }   
  // Figyeled az órát és össze hasinlítod a tömb éertékekkel! relé be
     if((relaysT[1].Rbe_hour == now.hour()) && (relaysT[1].Rbe_min == now.minute()) && (relaysT[1].Rbe_sec == now.second())){
         digitalWrite(REL2, HIGH);         
      }
  // relé ki
     if((relaysT[1].Rki_hour == now.hour()) && (relaysT[1].Rki_min == now.minute()) && (relaysT[1].Rki_sec == now.second())){
         digitalWrite(REL2, LOW);         
      }   
  // Figyeled az órát és össze hasinlítod a tömb éertékekkel! relé be
     if((relaysT[2].Rbe_hour == now.hour()) && (relaysT[2].Rbe_min == now.minute()) && (relaysT[2].Rbe_sec == now.second())){
          digitalWrite(REL3, HIGH);         
      }
  // relé ki
     if((relaysT[2].Rki_hour == now.hour()) && (relaysT[2].Rki_min == now.minute()) && (relaysT[2].Rki_sec == now.second())){
         digitalWrite(REL3, LOW);         
      }   
  // Figyeled az órát és össze hasinlítod a tömb éertékekkel! relé be
     if((relaysT[3].Rbe_hour == now.hour()) && (relaysT[3].Rbe_min == now.minute()) && (relaysT[3].Rbe_sec == now.second())){
         digitalWrite(REL4, HIGH);         
      }
  // relé ki
     if((relaysT[3].Rki_hour == now.hour()) && (relaysT[3].Rki_min == now.minute()) && (relaysT[3].Rki_sec == now.second())){
         digitalWrite(REL4, LOW);         
      }   
             
   char customKey = customKeypad.getKey();
         
   if (customKey){
   Serial.println(customKey);   
     }
   if (customKey == '0'){
       relayhour_setting();
     } else if (customKey == '1'){
       relayminute_setting();
     } else if (customKey == '2'){
       relaysec_setting();

     }else{}
      
   }
  
  
   readButtons(); //I splitted button reading and navigation in two procedures because
   navigateMenus(); //in some situations I want to use the button for other purpose (eg. to change some settings)

} //loop()...

   void menuChanged(MenuChangeEvent changed){

   MenuItem newMenuItem=changed.to; //get the destination menu

   lcd.setCursor(0,1); //set the start position for lcd printing to the second row
   if(newMenuItem.getName()==menu.getRoot()){
   lcd.print("  Idokapcsolo menu   ");
   }else if(newMenuItem.getName()=="1. Dugalj 1"){
   lcd.print("1. Dugalj 1");
   }else if(newMenuItem.getName()=="1.1 BE"){
   lcd.print("1.1 BE");
   }else if(newMenuItem.getName()=="1.2 KI"){
   lcd.print("1.2 KI");
   }else if(newMenuItem.getName()=="2. Dugalj 2"){
   lcd.print("2. Dugalj 2");
   }else if(newMenuItem.getName()=="2.1 BE"){
   lcd.print("2.1 BE");
   }else if(newMenuItem.getName()=="2.2 KI"){
   lcd.print("2.2 KI");
   }else if(newMenuItem.getName()=="3. Dugalj 3"){
   lcd.print("3. Dugalj 3");
   }else if(newMenuItem.getName()=="3.1 BE"){
   lcd.print("3.1 BE");
   }else if(newMenuItem.getName()=="3.2 KI"){
   lcd.print("3.2 KI");
   }else if(newMenuItem.getName()=="4. Dugalj 4"){
   lcd.print("4. Dugalj 4");
   }else if(newMenuItem.getName()=="4.1 BE"){
   lcd.print("4.1 BE");
   }else if(newMenuItem.getName()=="4.2 KI"){
   lcd.print("4.2 KI");
   }else if(newMenuItem.getName()=="5.Vissza"){
   lcd.print(" Vissza");

}
}

void menuUsed(MenuUseEvent used){
  menu.toRoot();                                              //back to Main
}

  if ((used.item.getName()) == "5. Vissza")
{
  lcd.setCursor(0,2);
  lcd.print("Vissza");
// lcd.print(used.item.getName());
  delay(3000);                                                //delay to allow message reading
  lcd.setCursor(0,0);
  lcd.print("Idokapcsolo menu");
  menu.toRoot();                                              //back to Main
}



}
//............................................................secBe_settting()................................................     
        void relaysecBe_settting(uint8_t relay)
         {
            char keypressed;
           
           relaysT[relay].Rbe_sec =  now.sec();
           
            lcd.setCursor(0,1);
            lcd.print("Set second: ");
            lcd.print(relay);   
            lcd.setCursor(0,2);
            lcd.print("mPerc = ");
            if(relaysT[relay].Rbe_sec < 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rbe_sec);         
        do {                                                    // ez az�rt kell, hogy addig nyomkodjon, mig jo v�laszt nem ad
            lcd.setCursor(8,1);
            if(relaysT[relay].Rbe_sec < 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rbe_sec);
            delay(100);
            keypressed =customKeypad.getKey();                  //keypressed v�ltoz� szint�n a setupban kell defini�lni
            if (keypressed=='1')                                //Annyit tudni kell itt, hogy most 1-et �rtam be, de neked pl az 1-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rbe_sec< 60){
                      relaysT[relay].Rbe_sec ++;                         
                   }else{
                      relaysT[relay].Rbe_sec = 0;
                   }
                   
                 }
             if (keypressed=='2')                              //Annyit tudni kell itt, hogy most 2-et �rtam be, de neked pl az 2-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rbe_sec > 0){
                      relaysT[relay].Rbe_sec --;                                
                   }else{
                      relaysT[relay].Rbe_sec = 59;
                   }                               
                 }
               //delay(100);
              } while(keypressed != '3');                      // Azaz m�g nem a h�rmas gombot nyomja 
              
          if (! RTC.isrunning()) {
        Serial.println("RTC is NOT running!");
        // Beállítja az RTC dáum és idő vázlatát
        RTC.adjust(DateTime(__DATE__, __TIME__));
       }    
            
      }
      
      //............................................................secKi_settting()................................................     
        void relaysecKi_settting(uint8_t relay)
         {
            char keypressed;
                       
           relaysT[relay].Rki_sec =  now.minute();
           
            lcd.setCursor(0,1);
            lcd.print("Set second: ");
            lcd.print(relay);   
            lcd.setCursor(0,2);
            lcd.print("mPerc = ");
            if(relaysT[relay].Rki_sec < 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rki_sec);         
        do {                                                    
            lcd.setCursor(8,1);
            if(relaysT[relay].Rki_sec < 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rki_sec);
            delay(100);
            keypressed =customKeypad.getKey();                   //keypressed v�ltoz� szint�n a setupban kell defini�lni
            if (keypressed=='1')                                 //Annyit tudni kell itt, hogy most 1-et �rtam be, de neked pl az 1-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rki_sec< 60){
                      relaysT[relay].Rki_sec ++;                    
                   }else{
                      relaysT[relay].Rki_sec = 0;
                   }
                   
                 }
             if (keypressed=='2')                               //Annyit tudni kell itt, hogy most 2-et �rtam be, de neked pl az 2-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rki_sec > 0){
                      relaysT[relay].Rki_sec --;                //
                   }else{
                      relaysT[relay].Rki_sec = 59;
                   }                                           
                 }
               //delay(100);
              } while(keypressed != '3');                       // Azaz m�g nem a h�rmas gombot nyomja 
              
          if (! RTC.isrunning()) {
        Serial.println("RTC is NOT running!");
        // Beállítja az RTC dáum és idő vázlatát
        RTC.adjust(DateTime(__DATE__, __TIME__));
       }    
            
      }
//.....................................................hourBe_setting().......................................................     
         void relayhourBe_settting(uint8_t relay)
         {
            char keypressed;
     
            relaysT[relay].Rbe_hour = now.hour(); 
       
            lcd.setCursor(0,1);
            lcd.print("Set hour:         ");   
            lcd.setCursor(0,2);
            lcd.print("Ora =               "); 
            if(relaysT[relay].Rbe_hour< 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rbe_hour);       
         do {                                                      // ez az�rt kell, hogy addig nyomkodjon, mig jo v�laszt nem ad
               
              lcd.setCursor(6,1);
              if(relaysT[relay].Rbe_hour < 10) lcd.print(" ");
              lcd.print(relaysT[relay].Rbe_hour);
              delay(100);
              keypressed =customKeypad.getKey();                   //keypressed v�ltoz� szint�n a setupban kell defini�lni
              if (keypressed=='1')                                 //Annyit tudni kell itt, hogy most 1-et �rtam be, de neked pl az 1-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rbe_hour < 24){
                      relaysT[relay].Rbe_hour ++;                                 
                   }else{
                      relaysT[relay].Rbe_hour = 0;
                   }
                   
                 }
                if (keypressed=='2')                              //Annyit tudni kell itt, hogy most 2-et �rtam be, de neked pl az 2-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rbe_hour> 0){
                      relaysT[relay].Rbe_hour --;                 //A sec v�ltoz�t a setupban int k�nt kell defini�lni
                   }else{
                      relaysT[relay].Rbe_hour = 23;
                   }                                
                 }
               //delay(100);
              } while(keypressed != '3');                         // Azaz m�g nem a h�rmas gombot nyomja
              
              if (! RTC.isrunning()) {
        Serial.println("RTC is NOT running!");
        // Beállítja az RTC dáum és idő vázlatát
        RTC.adjust(DateTime(__DATE__, __TIME__));
       }
         
           
           
         }   
         //.....................................................hourKi_setting().......................................................     
         void relayhourKi_settting(uint8_t relay)
         {
            char keypressed;
     
            relaysT[relay].Rki_hour = now.hour(); 
       
            lcd.setCursor(0,1);
            lcd.print("Set hour:         ");   
            lcd.setCursor(0,2);
            lcd.print("Ora =               "); 
            if(relaysT[relay].Rki_hour< 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rki_hour);       
         do {                                                      // ez az�rt kell, hogy addig nyomkodjon, mig jo v�laszt nem ad
               
              lcd.setCursor(6,1);
              if(relaysT[relay].Rki_hour < 10) lcd.print(" ");
              lcd.print(relaysT[relay].Rki_hour);
              delay(100);
              keypressed =customKeypad.getKey();                   //keypressed v�ltoz� szint�n a setupban kell defini�lni
              if (keypressed=='1')                                 //Annyit tudni kell itt, hogy most 1-et �rtam be, de neked pl az 1-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rki_hour < 24){
                      relaysT[relay].Rki_hour ++;                                 
                   }else{
                      relaysT[relay].Rki_hour = 0;
                   }
                   
                 }
                if (keypressed=='2')                              //Annyit tudni kell itt, hogy most 2-et �rtam be, de neked pl az 2-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rki_hour> 0){
                      relaysT[relay].Rki_hour --;                                 
                   }else{
                      relaysT[relay].Rki_hour = 23;
                   }                                
                 }
               //delay(100);
              } while(keypressed != '3');                         // Azaz m�g nem a h�rmas gombot nyomja
              
              if (! RTC.isrunning()) {
        Serial.println("RTC is NOT running!");
        // Beállítja az RTC dáum és idő vázlatát
        RTC.adjust(DateTime(__DATE__, __TIME__));
       }
         
           
           
         } 
       //...........................................................minuteBe_setting().................................................         
         void relayminuteKi_settting(uint8_t relay)
         {
            char keypressed;
           
            relaysT[relay].Rbe_min = now.minute(); 
           
            lcd.setCursor(0,1);
            lcd.print("Set Minute:          ");   
            lcd.setCursor(0,2);
            lcd.print("Perc = "); 
            if(relaysT[relay].Rbe_min < 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rbe_min);       
         do {                                                      // ez az�rt kell, hogy addig nyomkodjon, mig jo v�laszt nem ad
               
              lcd.setCursor(7,1);
              if(relaysT[relay].Rbe_min< 10) lcd.print(" ");
              lcd.print(relaysT[relay].Rbe_min);
              delay(100);
              keypressed =customKeypad.getKey();                   //keypressed v�ltoz� szint�n a setupban kell defini�lni
              if (keypressed=='1')                                 //Annyit tudni kell itt, hogy most 1-et �rtam be, de neked pl az 1-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rbe_min < 60){
                      relaysT[relay].Rbe_min ++;                                 //A sec v�ltoz�t a setupban int k�nt kell defini�lni
                   }else{
                      relaysT[relay].Rbe_min = 0;
                   }
                   
                 }
                if (keypressed=='2')                               //Annyit tudni kell itt, hogy most 2-et �rtam be, de neked pl az 2-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rbe_min > 0){
                      relaysT[relay].Rbe_min --;                   
                   }else{
                      relaysT[relay].Rbe_min = 59;
                   }                                
                 }
               //delay(100);
              } while(keypressed != '3');                          // Azaz m�g nem a h�rmas gombot nyomja 
          
          if (! RTC.isrunning()) {
        Serial.println("RTC is NOT running!");
        // Beállítja az RTC dáum és idő vázlatát
        RTC.adjust(DateTime(__DATE__, __TIME__));
       }    
        
         }
         
         //...........................................................minuteKi_setting().................................................
         void relayminuteKi_settting(uint8_t relay)
         {
            char keypressed;
     
            relaysT[relay].Rki_hour = now.minute(); 
       
            lcd.setCursor(0,1);
            lcd.print("Set Minute:         ");   
            lcd.setCursor(0,2);
            lcd.print("Perc =               "); 
            if(relaysT[relay].Rki_hour< 10) lcd.print(" ");
            lcd.print(relaysT[relay].Rki_hour);       
         do {                                                      // ez az�rt kell, hogy addig nyomkodjon, mig jo v�laszt nem ad
               
              lcd.setCursor(6,1);
              if(relaysT[relay].Rki_hour < 10) lcd.print(" ");
              lcd.print(relaysT[relay].Rki_hour);
              delay(100);
              keypressed =customKeypad.getKey();                   //keypressed v�ltoz� szint�n a setupban kell defini�lni
              if (keypressed=='1')                                 //Annyit tudni kell itt, hogy most 1-et �rtam be, de neked pl az 1-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rki_hour < 60){
                      relaysT[relay].Rki_hour ++;                                 
                   }else{
                      relaysT[relay].Rki_hour = 0;
                   }
                   
                 }
                if (keypressed=='2')                              //Annyit tudni kell itt, hogy most 2-et �rtam be, de neked pl az 2-es gomb megnyom�s�ra lehet nem ezt adja vissza, hanem azt amit te adt�l meg, sz�val az kell majd neki itt megadni
                {
                  if(relaysT[relay].Rki_hour> 0){
                      relaysT[relay].Rki_hour --;                                 
                   }else{
                      relaysT[relay].Rki_hour = 59;
                   }                                
                 }
               //delay(100);
              } while(keypressed != '3');                         // Azaz m�g nem a h�rmas gombot nyomja
              
              if (! RTC.isrunning()) {
        Serial.println("RTC is NOT running!");
        // Beállítja az RTC dáum és idő vázlatát
        RTC.adjust(DateTime(__DATE__, __TIME__));
       }
         
           
           
         }      
