
/* @file Idokapcsolo.ino
        || @version 1.0
        || @author kapu48
        || @contact
        ||
        || @description
        || | Demonstrates changing the keypad size and key values.
        || #
        */ 
            
     
     #include <LiquidCrystal_I2C.h> //this library is included in the Arduino IDE
     #include <Wire.h>
     #include <Keypad.h>
     #include "RTClib.h"
     
      LiquidCrystal_I2C lcd(0x27, 20, 4);
     
      RTC_DS1307 RTC;
           
      const int REL1 =  7;
      const int REL2 =  8;
      const int REL3 =  9;
      const int REL4 = 10;
     
      int hour;
      int minute;
      int second;
                     
      const byte ROWS = 4; //four rows
      const byte COLS = 1; //four columns
     //define the cymbols on the buttons of the keypads
       char hexaKeys[ROWS] = {'0','1','2','3'};
                 
       byte rowPins[ROWS] = {5, 4, 3, 2}; //connect to the row pinouts of the keypad
       byte colPins[1] = {8}; //connect to the column pinouts of the keypad
             
     //initialize an instance of class NewKeypad
       Keypad customKeypad = Keypad( makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);
       DateTime now;
           
                          //relays adat structure
      struct relays {
     // bekapcsolás
        uint16_t Rbe_year;
        uint8_t Rbe_mon;
        uint8_t Rbe_day;                       
        uint8_t Rbe_hour;
        uint8_t Rbe_min;
        uint8_t Rbe_sec;
               
     // kikapcsolás
        uint16_t Rki_year;
        uint8_t Rki_mon;
        uint8_t Rki_day;         
        uint8_t Rki_hour;
        uint8_t Rki_min;
        uint8_t Rki_sec;           
      };
             
     // Relay flags
        #define Rbe1  0
        #define Rbe2  1
        #define Rbe3  2
        #define Rbe4  3
     
        relays relaysT[4];                 // Tömböd 4 relének
         
        uint8_t relayF = 0;                // Relék állapotjelző bitek
         
        uint8_t relayNum;
        char customKey;
     
       
   
     
    void setup()
    {
     
      Serial.begin(9600);
      lcd.begin(20, 4);
      lcd.backlight();
      Wire.begin();
      lcd.clear();
      RTC.begin();
     
      digitalWrite(REL1, HIGH);
      digitalWrite(REL2, HIGH);
      digitalWrite(REL3, HIGH);
      digitalWrite(REL4, HIGH);
                     
      pinMode(REL1, OUTPUT);
      pinMode(REL2, OUTPUT);
      pinMode(REL3, OUTPUT);
      pinMode(REL4, OUTPUT);
     
      if (! RTC.isrunning()) {
         Serial.println("RTC is NOT running!");
      // Beállítja az RTC dáum és idő vázlatát
         RTC.adjust(DateTime(__DATE__, __TIME__));
           }
           
      // Valahol feltöltöd az  relay tömböt
      // bekapcsolás
                         
         relaysT[0].Rbe_hour = 10;
         relaysT[0].Rbe_min = 30;
         relaysT[0].Rbe_sec = 0;
         
       // kikapcsolás
                         
          relaysT[0].Rki_hour = 10;
          relaysT[0].Rki_min = 50;
          relaysT[0].Rki_sec = 0;
               
       // bekapcsolás
                         
          relaysT[1].Rbe_hour = 10;
          relaysT[1].Rbe_min = 30;
          relaysT[1].Rbe_sec = 0;
               
       // kikapcsolás
                         
          relaysT[1].Rki_hour = 10;
          relaysT[1].Rki_min = 50;
          relaysT[1].Rki_sec = 0;
               
       // bekapcsolás
                       
          relaysT[2].Rbe_hour = 10;
          relaysT[2].Rbe_min = 30;
          relaysT[2].Rbe_sec = 0;
               
       // kikapcsolás
                         
          relaysT[2].Rki_hour = 10;
          relaysT[2].Rki_min = 50;
          relaysT[2].Rki_sec = 0;
               
       // bekapcsolás
                       
          relaysT[3].Rbe_hour = 10;
          relaysT[3].Rbe_min = 30;
          relaysT[3].Rbe_sec = 0;
               
       // kikapcsolás
                         
          relaysT[3].Rki_hour = 10;
          relaysT[3].Rki_min = 50;
          relaysT[3].Rki_sec = 0;
       /*         
        // Példa flag használatára
           relayF |= (1 << Rbe1);           // Jelző set
           relayF &= ~(1 << Rbe1);          // Jelző reset
         if(relayF &(~(1 << Rbe1))){};      // flag vizsgálat bekapcsoltra
         if(!(relayF &(~(1 << Rbe1)))){};   // flag vizsgálat kikapcsoltra
         
           relayF |= (1 << Rbe2);           // Jelző set
           relayF &= ~(1 << Rbe2);          // Jelző reset
         if(relayF &(~(1 << Rbe2))){};      // flag vizsgálat bekapcsoltra
         if(!(relayF &(~(1 << Rbe2)))){};   // flag vizsgálat kikapcsoltra
         
           relayF |= (1 << Rbe3);           // Jelző set
           relayF &= ~(1 << Rbe3);          // Jelző reset
         if(relayF &(~(1 << Rbe3))){};      // flag vizsgálat bekapcsoltra
         if(!(relayF &(~(1 << Rbe3)))){};   // flag vizsgálat kikapcsoltra
         
           relayF |= (1 << Rbe4);           // Jelző set
           relayF &= ~(1 << Rbe4);          // Jelző reset
         if(relayF &(~(1 << Rbe4))){};      // flag vizsgálat bekapcsoltra
         if(!(relayF &(~(1 << Rbe4)))){};   // flag vizsgálat kikapcsoltra
       */

     
     }
       
    void loop()
    {
        DateTime now = RTC.now();
             
        lcd.setCursor(0, 0);
        lcd.print(now.year(), DEC);
        lcd.print('.');
        lcd.print(now.month(), DEC);
        lcd.print('.');
        lcd.print(now.day(), DEC);
        lcd.print(' ');
        lcd.setCursor(10, 0);
         if (now.hour()<10)
        lcd.print('0');
        lcd.print(now.hour(), DEC);
        lcd.print(':');
         if (now.minute()<10)
        lcd.print('0');
        lcd.print(now.minute(), DEC);
        lcd.print(':');
         if (now.second()<10)
        lcd.print('0');
        lcd.print(now.second(), DEC);
        lcd.setCursor(6, 1);
             
             
             
        for(uint8_t i = 0; i < 4; i++){
               
        // relé bekapcsol
     
        if(!(relayF &(~(1 << i)))){   // Ha flag = 0
         if((relaysT[i].Rbe_hour == now.hour()) && (relaysT[i].Rbe_min == now.minute()) && (relaysT[i].Rbe_sec == now.second())){
             digitalWrite(REL1 + i, HIGH);
             relayF |= (1 << i);   // Jelző set       
            }
           }
         // relé kikapcsol
         
         if(relayF &(~(1 << i))){   // Ha flag = 1
           if((relaysT[i].Rki_hour == now.hour()) && (relaysT[i].Rki_min == now.minute()) &&(relaysT[i].Rki_sec == now.second()) ){
               digitalWrite(REL1 + i, LOW);
               relayF &= ~(1 << i);   // Jelző reset       
              }
             }   
          } 
             
       
       customKey = customKeypad.getKey();
             
       if (customKey){
       Serial.println(customKey);   
         }
           if (customKey == '0'){
       menu1();
     } else if (customKey == '1'){
       menu2();
     } else if (customKey == '2'){
       menu3();
     }else  menu4();
     
} //loop()...
 
void menu1(){                      // Csak a sec van deklarálva a hour és a minut nincs. Az is kellene,de nem tudom hogyan
 
    lcd.setCursor(0,0);
    lcd.print("1. Dugalj 1");
    lcd.setCursor(0,1);
  do{
    delay(100);
    customKey = customKeypad.getKey();
       
    if (customKey == '1'){     
      lcd.print("1.1 BE");
      relaysecBe_setting(0);
    } 
    if (customKey == '2'){     
      lcd.print("1.2 KI");
      relaysecKi_setting(0);
    }
  } while(customKey != '3');
}
   //folytasd:
 
void menu2(){
 
 
    lcd.setCursor(0,0);
    lcd.print("2. Dugalj 2");
    lcd.setCursor(0,1);
  do{
    delay(100);
    customKey = customKeypad.getKey();
      
 
   if (customKey == '1'){
    lcd.print("2.1 BE");
    relaysecBe_setting(1);
    }
   if (customKey == '2'){ 
    lcd.setCursor(0,0);
    lcd.print ("2.2 KI");
    relaysecKi_setting(1);
    }
  } while(customKey != '3');
}
 
void menu3(){
  
    lcd.setCursor(0,0);
    lcd.print("3. Dugalj 3");
    lcd.setCursor(0,1);
  do{
    delay(100);
    customKey = customKeypad.getKey();
      
 
   if (customKey == '1'){
    lcd.print("2.1 BE");
    relaysecBe_setting(2);
    }
   if (customKey == '2'){ 
    lcd.setCursor(0,0);
    lcd.print ("2.2 KI");
    relaysecKi_setting(2);
    }
  } while(customKey != '3');   
}
 
void menu4(){
  
    lcd.setCursor(0,0);
    lcd.print("3. Dugalj 3");
    lcd.setCursor(0,1);
  do{
    delay(100);
    customKey = customKeypad.getKey();
      
 
   if (customKey == '1'){
    lcd.print("2.1 BE");
    relaysecBe_setting(2);
    }
   if (customKey == '2'){ 
    lcd.setCursor(0,0);
    lcd.print ("2.2 KI");
    relaysecKi_setting(2);
    }
  } while(customKey != '3');
    
  
   
 
    lcd.setCursor(0,0);        // Ezt nem tudom hova kell tenni!!!
    lcd.print(" Vissza ");
 }

     
     
     
     

     
     
     
     
     
    //............................................................secBe_setting()................................................     
            void relaysecBe_setting(uint8_t relay)
             {
                char keypressed;
               
               relaysT[relay].Rbe_sec =  now.second();
               
                lcd.setCursor(0,1);
                lcd.print("Set second: ");
                lcd.print(relay);   
                lcd.setCursor(0,2);
                lcd.print("mPerc = ");
                if(relaysT[relay].Rbe_sec < 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rbe_sec);         
            do {                                                    //
                lcd.setCursor(8,1);
                if(relaysT[relay].Rbe_sec < 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rbe_sec);
                delay(100);
                keypressed =customKeypad.getKey();                  //
                if (keypressed=='1')                                //
                    {
                      if(relaysT[relay].Rbe_sec< 60){
                          relaysT[relay].Rbe_sec ++;                         
                       }else{
                          relaysT[relay].Rbe_sec = 0;
                       }
                       
                     }
                 if (keypressed=='2')                              //
                    {
                      if(relaysT[relay].Rbe_sec > 0){
                          relaysT[relay].Rbe_sec --;                               
                       }else{
                          relaysT[relay].Rbe_sec = 59;
                       }                               
                     }
                   //delay(100);
                  } while(keypressed != '3');                      //
              if (! RTC.isrunning()) {
            Serial.println("RTC is NOT running!");
            // Beállítja az RTC dáum és idő vázlatát
            RTC.adjust(DateTime(__DATE__, __TIME__));
           }   
               
          }
         
          //............................................................secKi_setting()................................................     
            void relaysecKi_setting(uint8_t relay)
             {
                char keypressed;
                           
               relaysT[relay].Rki_sec =  now.second();
               
                lcd.setCursor(0,1);
                lcd.print("Set second: ");
                lcd.print(relay);   
                lcd.setCursor(0,2);
                lcd.print("mPerc = ");
                if(relaysT[relay].Rki_sec < 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rki_sec);         
            do {                                                   
                lcd.setCursor(8,1);
                if(relaysT[relay].Rki_sec < 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rki_sec);
                delay(100);
                keypressed =customKeypad.getKey();                   //
                if (keypressed=='1')                                 //
                    {
                      if(relaysT[relay].Rki_sec< 60){
                          relaysT[relay].Rki_sec ++;                   
                       }else{
                          relaysT[relay].Rki_sec = 0;
                       }
                       
                     }
                 if (keypressed=='2')                               //
                    {
                      if(relaysT[relay].Rki_sec > 0){
                          relaysT[relay].Rki_sec --;                //
                       }else{
                          relaysT[relay].Rki_sec = 59;
                       }                                           
                     }
                   //delay(100);
                  } while(keypressed != '3');                       //
              if (! RTC.isrunning()) {
            Serial.println("RTC is NOT running!");
            // Beállítja az RTC dáum és idő vázlatát
            RTC.adjust(DateTime(__DATE__, __TIME__));
           }   
               
          }
    //.....................................................hourBe_setting().......................................................     
             void relayhourBe_setting(uint8_t relay)
             {
                char keypressed;
         
                relaysT[relay].Rbe_hour = now.hour();
           
                lcd.setCursor(0,1);
                lcd.print("Set hour:         ");   
                lcd.setCursor(0,2);
                lcd.print("Ora =               ");
                if(relaysT[relay].Rbe_hour< 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rbe_hour);       
             do {                                                      //
                   
                  lcd.setCursor(6,1);
                  if(relaysT[relay].Rbe_hour < 10) lcd.print(" ");
                  lcd.print(relaysT[relay].Rbe_hour);
                  delay(100);
                  keypressed =customKeypad.getKey();                   //
                  if (keypressed=='1')                                 //
                    {
                      if(relaysT[relay].Rbe_hour < 24){
                          relaysT[relay].Rbe_hour ++;                                 
                       }else{
                          relaysT[relay].Rbe_hour = 0;
                       }
                       
                     }
                    if (keypressed=='2')                              //
                    {
                      if(relaysT[relay].Rbe_hour> 0){
                          relaysT[relay].Rbe_hour --;                 //
                       }else{
                          relaysT[relay].Rbe_hour = 23;
                       }                               
                     }
                   //delay(100);
                  } while(keypressed != '3');                         //
                 
                  if (! RTC.isrunning()) {
            Serial.println("RTC is NOT running!");
            // Beállítja az RTC dáum és idő vázlatát
            RTC.adjust(DateTime(__DATE__, __TIME__));
           }
             
               
               
             }   
             //.....................................................hourKi_setting().......................................................     
             void relayhourKi_setting(uint8_t relay)
             {
                char keypressed;
         
                relaysT[relay].Rki_hour = now.hour();
           
                lcd.setCursor(0,1);
                lcd.print("Set hour:         ");   
                lcd.setCursor(0,2);
                lcd.print("Ora =               ");
                if(relaysT[relay].Rki_hour< 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rki_hour);       
             do {                                                      //
                   
                  lcd.setCursor(6,1);
                  if(relaysT[relay].Rki_hour < 10) lcd.print(" ");
                  lcd.print(relaysT[relay].Rki_hour);
                  delay(100);
                  keypressed =customKeypad.getKey();                   //
                  if (keypressed=='1')                                 //
                    {
                      if(relaysT[relay].Rki_hour < 24){
                          relaysT[relay].Rki_hour ++;                                 
                       }else{
                          relaysT[relay].Rki_hour = 0;
                       }
                       
                     }
                    if (keypressed=='2')                              //
                    {
                      if(relaysT[relay].Rki_hour> 0){
                          relaysT[relay].Rki_hour --;                                 
                       }else{
                          relaysT[relay].Rki_hour = 23;
                       }                               
                     }
                   //delay(100);
                  } while(keypressed != '3');                         //
                 
                  if (! RTC.isrunning()) {
            Serial.println("RTC is NOT running!");
            // Beállítja az RTC dáum és idő vázlatát
            RTC.adjust(DateTime(__DATE__, __TIME__));
           }
             
               
               
             }
           //...........................................................minuteBe_setting().................................................         
             void relayminuteBe_setting(uint8_t relay)
             {
                char keypressed;
               
                relaysT[relay].Rbe_min = now.minute();
               
                lcd.setCursor(0,1);
                lcd.print("Set Minute:          ");   
                lcd.setCursor(0,2);
                lcd.print("Perc = ");
                if(relaysT[relay].Rbe_min < 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rbe_min);       
             do {                                                      //
                   
                  lcd.setCursor(7,1);
                  if(relaysT[relay].Rbe_min< 10) lcd.print(" ");
                  lcd.print(relaysT[relay].Rbe_min);
                  delay(100);
                  keypressed =customKeypad.getKey();                   //
                  if (keypressed=='1')                                 //
                    {
                      if(relaysT[relay].Rbe_min < 60){
                          relaysT[relay].Rbe_min ++;                                 //
                       }else{
                          relaysT[relay].Rbe_min = 0;
                       }
                       
                     }
                    if (keypressed=='2')                               //
                    {
                      if(relaysT[relay].Rbe_min > 0){
                          relaysT[relay].Rbe_min --;                   
                       }else{
                          relaysT[relay].Rbe_min = 59;
                       }                               
                     }
                   //delay(100);
                  } while(keypressed != '3');                          //
             
              if (! RTC.isrunning()) {
            Serial.println("RTC is NOT running!");
            // Beállítja az RTC dáum és idő vázlatát
            RTC.adjust(DateTime(__DATE__, __TIME__));
           }   
           
             }
             
             //...........................................................minuteKi_setting().................................................
    void relayminuteKi_setting(uint8_t relay)
             {
                char keypressed;
         
                relaysT[relay].Rki_hour = now.minute();
           
                lcd.setCursor(0,1);
                lcd.print("Set Minute:         ");   
                lcd.setCursor(0,2);
                lcd.print("Perc =               ");
                if(relaysT[relay].Rki_hour< 10) lcd.print(" ");
                lcd.print(relaysT[relay].Rki_hour);       
             do {                                                      //
                   
                  lcd.setCursor(6,1);
                  if(relaysT[relay].Rki_hour < 10) lcd.print(" ");
                  lcd.print(relaysT[relay].Rki_hour);
                  delay(100);
                  keypressed =customKeypad.getKey();                   //
                  if (keypressed=='1')                                 //
                    {
                      if(relaysT[relay].Rki_hour < 60){
                          relaysT[relay].Rki_hour ++;                                 
                       }else{
                          relaysT[relay].Rki_hour = 0;
                       }
                       
                     }
                    if (keypressed=='2')                              //
                    {
                      if(relaysT[relay].Rki_hour> 0){
                          relaysT[relay].Rki_hour --;                                 
                       }else{
                          relaysT[relay].Rki_hour = 59;
                       }                               
                     }
                   //delay(100);
                  } while(keypressed != '3');                         //
                 
                  if (! RTC.isrunning()) {
            Serial.println("RTC is NOT running!");
            // Beállítja az RTC dáum és idő vázlatát
            RTC.adjust(DateTime(__DATE__, __TIME__));
           }
             
               
               
     }
