//#define  F_CPU 8000000UL
#define __DEBUG
/* Attiny85 és Atmega8 közül választható, de jó UNO-nak is (Atmega328)
#define ATMEGA8A

/*
     74HC595    (a szegmenseket eltoltam, mert így sikerült a forrasztás)
    Q1 (a)   1 +--*--+  16  VCC
    Q2 (b)   2 |  *  |  15  Q0      (dot)
    Q3 (c)   3 |     |  14  DS      Arduino 11 DATA MOSI
    Q4 (d)   4 |     |  13  OE      GND  
    Q5 (e)   5 |     |  12  ST_CP   Arduino 8 CS
    Q6 (f)   6 |     |  11  SH_CP   Arduino 12 SCK
    Q7 (g)   7 |     |  10  MR      HIGH VCC
    GND      8 +-----+   9  
*/

/*
    Arduino pins
    PB0 =  8     PB5 = 13     PC4 = 18
    PB1 =  9     PC0 = 14     PC5 = 19
    PB2 = 10     PC1 = 15     PC6 = 20
    PB3 = 11     PC2 = 16     PC7 = 21
    PB4 = 12     PC3 = 17
*/

/*
    ATMEGA 8A QFP32 TO DIP 
    Ez a DIP konverteres lábkiosztás, nem a DIP tokozásos
    PD3/INT1            1 +--*--+  32    PD2/INT0
    PD4                 2 |  *  |  31    PD1/TX
    GND                 3 |     |  30    PD0/RX
    VCC                 4 |     |  29    PC6/RESET
    GND                 5 |     |  28    PC5/ADC5/SCL
    VCC                 6 |     |  27    PC4/ADC4/SDA
    PB6                 7 |     |  26    PC3/ADC3
    PB7                 8 |     |  25    PC2/ADC2
    PD5                 9 |     |  24    PC1/ADC1
    PD6                10 |     |  23    PC0/ADC0
    PD7                11 |     |  22    ADC7
    PB0                12 |     |  21    GND
    PB1/PWM            13 |     |  20    AREF
    PB2/PWM            14 |     |  19    ADC6
    PB3/PWM/MOSI       15 |     |  18    AVCC
    PB4/MISO           16 +-----+  17    PB5/SCK
*/

/*
    ATTINY 85
    reset               1 +--*--+   8  VCC
    PB3 PWM DBG         2 |  *  |   7  SCL  PB2 SCK
    PB4 ZERO PCINT4     3 |     |   6  OPTO PB1 MISO
    GND                 4 +-----+   5  SDA  PB0 MOSI
*/


#ifdef __DEBUG
#ifdef ATMEGA8A
  #define DbgSerial Serial
#else
//  #include <TinyPinChange.h>
  #include "SoftSerial.h"
  #define DEBUG_TX_RX_PIN         11
  SoftSerial DbgSerial(DEBUG_TX_RX_PIN, DEBUG_TX_RX_PIN);
#endif // ATMEGA8  
#endif

/* 
 *  Ez most egy ilyen osztályos megoldás, mert így átláthatóbb 
 *  de működik az alábbi is
 *   volatile int16_t timercounter=0;
 *   void loop() 
 *   {
 *      static unsigned int T_MEASURE = 0;
 *      if (timercounter - T_MEASURE> 20) // minden 20. msec-ben
 *      {
 *          T_MEASURE = timercounter ;
 *          ...
 *      }
 *   }
 *   ISR(TIMER1_OVF_vect)
 *   {
 *      // azért 4 mert így megközelítőleg millisec -et jelent alap arduino timer1 beállításnál
 *      timercounter+=4;
 *   }
 */
#include "STimer.h"
//#include <EEPROM.h>

/* csak a flanc miatt van osztály, talán átláthatóbb a megvalósításkor */
class analogOlvas {
private:
    unsigned int _hanyszor;
    unsigned int _szamlalo;
    unsigned int _pin;
    long sum;
public:
    int ertek;
    analogOlvas(unsigned int pin,unsigned int hanyszor=16);
    void olvas();
};

analogOlvas::analogOlvas(unsigned int pin,unsigned int hanyszor)
{
    _hanyszor=hanyszor;
    _pin=pin;
    sum=0; ertek=0; _szamlalo=0;
}

void analogOlvas::olvas() 
{
    sum+=analogRead(_pin); _szamlalo++;
    if (_szamlalo==_hanyszor) 
    {
        if (_hanyszor==16)
            ertek=sum>>4;
        else
            ertek=sum/_hanyszor;
        sum=0; _szamlalo=0;
    }
    
}

/* PINEK */

//#define POTA  0
#define TEMPA 5


#define ENCA  14
#define ENCB  15
#define ENCBTN  16

#define DIG1  18
#define DIG2  10
#define DIG3  9
#define DIG4  8

#define LEDR 13
#define LEDG 14
#define LEDB 17

#define SPI_SS    6
#define SPI_MOSI  5
#define SPI_SCLK  7

//#define LED_PORT   PORTB
//#define LED_PIN   _BV(0)
//#define LED1  8
#define PWM   11


/* ENDPIN */

#define NOP __asm__("nop\n\t")
#define SENS  10

#define leptetes  5
#define maxbeall  255
#define floor5(i)   i-=i%5
#define szazalek(i) i=map(i,0,255,0,100)

enum mutatok {homerseklet, beallitas } mutat=homerseklet;
enum allapotok {melegit,tartalatta,tart,hul,hiba,nincs} allapot,elozovillogallapot=nincs;
unsigned int ertekek[]={255,200,100,0,0,0};


analogOlvas *homerolvas=new analogOlvas(TEMPA);

int homer=0;
int beall=100;


unsigned int pwm=0;
unsigned int elozopwm=0;

SimpleTimer timer;

bool villogallapot=false;

// funkciók amik később lesznek deklarálva

void beolvasloop();
void kiirloop();
void forrasztoloop();
void pwmloop();
void kiir();
void villogloop();
void registerWrite(int szam,bool pont=false);
void numberwrite(int num,int dig,bool dot=false);

int mutattimer;

struct eeprom_struct {
  char id[6];
  int ver;
  int ever;
  int tempmin;
  int tempmax;
  int potmin;
  int potmax;
}  eeprom,PROGMEM init_eeprom={"SStat",1,0,20,420,100,380};


void setup()
{

#ifdef __DEBUG  
  DbgSerial.begin(9600); //After DbgSerial.begin(), the serial port is in rxMode by default
#ifdef ATMEGA8A
#else
  DbgSerial.txMode(); //Before sending a message, switch to txMode
#endif  
  DbgSerial.println(F("\nDebug enabled"));
#endif
  

  pinMode(LEDR, OUTPUT);pinMode(LEDG, OUTPUT); pinMode(LEDB, OUTPUT);
  digitalWrite(LEDR,HIGH);digitalWrite(LEDG,HIGH);digitalWrite(LEDB,HIGH);
  pinMode(DIG1, OUTPUT);pinMode(DIG2, OUTPUT); pinMode(DIG3, OUTPUT); pinMode(DIG4, OUTPUT);
  pinMode(SPI_SS, OUTPUT);pinMode(SPI_SCLK, OUTPUT); pinMode(SPI_MOSI, OUTPUT);
  
  pinMode(ENCA, INPUT_PULLUP);  pinMode(ENCB, INPUT_PULLUP); pinMode(ENCBTN, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(ENCA), updateEncoder, CHANGE);   attachInterrupt(digitalPinToInterrupt(ENCB), updateEncoder, CHANGE);
  
  pinMode(PWM, OUTPUT);
  
  mutattimer=timer.setInterval(3000,beallittimerfunc);
  timer.disable(mutattimer);
  for (int i=0;i<30;i++) beolvasloop();  forrasztoloop(); villogloop(); // Hogy gyorsabban világítson

  timer.setInterval(11, beolvasloop);
  timer.setInterval(500,forrasztoloop); 
  timer.setInterval(100,villogloop); 
  timer.setInterval(1000,pwmloop); 
#ifdef __DEBUG  
  timer.setInterval(2000,dbgkiir); 
#endif  
  digitalWrite(DIG1,LOW);    digitalWrite(DIG2,LOW);    digitalWrite(DIG3,LOW); digitalWrite(DIG4,LOW);
}

void loop()
{
  timer.run();
}

void beallittimerfunc() {mutat=homerseklet;timer.disable(mutattimer);}

void beolvasloop()
{
    static unsigned int i=0;
    switch (i++%2) 
    {
      case 1:
      case 0: homerolvas->olvas(); break;
      // abban az esetben, ha a beállítás nem rotary encoder, hanem potméter
      //case 1: beallolvas->olvas(); break;
    }
    
}

void villogloop() {
  static int elozobeall=-1;
  
  /* ha elmozdul a beállítás étzéke (rotary) akkor a beállítást jelenítem meg, nem a hőmérsékletet, x másodpercig */
  if (elozobeall!=-1 && elozobeall!=beall) {
      mutat=beallitas;
      timer.restartTimer(mutattimer); timer.enable(mutattimer);
  }
  elozobeall=beall;
  /* a villogás miatt, a hibánál */
  villogallapot=!villogallapot;
  if ((allapot!=hiba) && (elozovillogallapot==allapot)) return;
  elozovillogallapot=allapot;
  // Common Anode-os az RGB ledem a WS2811 miatt (ami itt most nincs), azért van HIGH-ra állítva
  digitalWrite(LEDR,HIGH);digitalWrite(LEDG,HIGH);digitalWrite(LEDB,HIGH);
  switch (allapot) {
    case melegit : digitalWrite(LEDR,LOW);  break;
    case tart:  digitalWrite(LEDG,LOW); break;
    case nincs: case hul : digitalWrite(LEDB,LOW); break;
    case tartalatta : digitalWrite(LEDG,LOW); break;
    case hiba :  digitalWrite(LEDR,(villogallapot) ? HIGH : LOW); break;
  }

  
}


void forrasztoloop() {

  int homerraw=homerolvas->ertek;
  /* ez itt thermistor, de hasonló a thermoelemes is, csak az 0 -hoz közelebbi */
  homer=map( homerraw,200,850,eeprom.tempmin,eeprom.tempmax) ;
 
  int delta=beall-homer;
  /* fel van húzva a kivezetés, ha nincs összeköttetés, akkor 1023 a visszaadott */
  if (homerraw>1000) allapot=hiba;
  /* van egy átmenet, de lehet software schmitt triggert kellene alkalmazni */
  else if (delta>0 && delta<SENS) allapot=tartalatta;
  else if (delta>=-SENS && delta<=0) allapot=tart;
  else if (delta<-SENS) allapot=hul;
  else allapot=melegit;
  // Az állapotnak megfelelő érték, de ide is beillesztem
  /*
   *     enum allapotok         {melegit,tartalatta,tart,hul,hiba,nincs} 
   *     unsigned int ertekek[]={255,    200,       100, 0,  0,   0};
   */
  pwm=ertekek[(int)allapot];
  
}

/* lépteti a beállított PWM-et, hogy kímélje a PSU-t */
void pwmloop() {
  int pwmdelta=pwm-elozopwm;
  if (pwmdelta<=0) elozopwm=pwm;
  else if (pwmdelta<50) elozopwm=pwm;
  else elozopwm+=50;
  analogWrite( PWM,elozopwm & 0xFF); // 0-255 ig PWM
}


void dbgkiir() {
#ifdef __DEBUG
  DbgSerial.print("beall: ");  DbgSerial.print(beall); DbgSerial.print(", homer: "); DbgSerial.print(homer); DbgSerial.print(", homerraw: "); DbgSerial.print(homerolvas->ertek); DbgSerial.print(", pwm : ");  DbgSerial.print(elozopwm); DbgSerial.print(", elozopwm : ");  DbgSerial.print(pwm); DbgSerial.print(", allapot : ");  DbgSerial.print(allapot);  DbgSerial.print(", mutat : "); DbgSerial.print(mutat);   DbgSerial.println();  
#endif  
}


void updateEncoder()
{
/* 
 *  Külső kód lett beemelve, bevált más platformon is (stm8, 8051) 
 *  de alább amikor Logic Analyzerrel néztem
 */

/*
         rotate L
L    _______        ___
            |      |
            |______|
R    ___        _______
        |      |
        |______|
            
         rotate R
L    ___        _______
        |      |
        |______|
            
R    _______        ___
            |      |
            |______|
            
*/   
  static int lastEncoded = 0;
  
  int MSB = digitalRead(ENCA); //MSB = most significant bit
  int LSB = digitalRead(ENCB); //LSB = least significant bit

  int encoded = (MSB << 1) |LSB; //converting the 2 pin value to single number
  int sum  = (lastEncoded << 2) | encoded; //adding it to the previous encoded value

  if(sum == 0b1101 || sum == 0b0100 || sum == 0b0010 || sum == 0b1011) beall++;
  if(sum == 0b1110 || sum == 0b0111 || sum == 0b0001 || sum == 0b1000) beall--;

  lastEncoded = encoded; //store this value for next time
}


void numberwrite(int num,int dig,bool dot) {
  // 0 = 1
  // 1 = 10
  // 2 = 100
  digitalWrite(DIG1,HIGH);    digitalWrite(DIG2,HIGH);    digitalWrite(DIG3,HIGH); digitalWrite(DIG4,HIGH);
  if (dig==0) {
    registerWrite(num %10,dot );
    digitalWrite(DIG3,LOW);
  } else if (dig==1) {
    if (num<10) registerWrite(-1);
    else registerWrite((num/10)%10);
    digitalWrite(DIG2,LOW);    
  } else if (dig==2) {
    if (num<100) registerWrite(-1);
    else registerWrite((num/100)%10);
    digitalWrite(DIG1,LOW);    
  } else if (dig==3) {
    registerWrite(-2);
    digitalWrite(DIG4,LOW);
    
  }
}


void registerWrite(int szam,bool pont) {
  byte PROGMEM pins[10]={
    // mert így adta a huzagolás :-)

      0b11111010, // 0
      0b10000010, // 1
      0b11011001, // 2
      0b11001011, // 3
      0b10100011, // 4
      0b01101011, // 5 
      0b01111011, // 6
      0b11000010, // 7
      0b11111011, // 8
      0b11100011  // 9
    
      
//      0b11101101, // 0
//      0b10100000, // 1
//      0b10001111, // 2
//      0b10100111, // 3
//      0b11100010, // 4
//      0b01100111, // 5 
//      0b01101111, // 6
//      0b10100001, // 7
//      0b11101111, // 8
//      0b11100011  // 9
    
//     0b00000001, // 0
//     0b00000010, // 1
//     0b00000100, // 2
//     0b00001000, // 3
//     0b00010000, // 4
//     0b00100000, // 5
//     0b01000000, // 6
//     0b10000000, // 7
//     0b00000000, // 8
//     0b00000000, // 9
    
    };
  byte e=0b11001011;
  byte pontb=0b00000100;
  byte fok  =0b11100001;
  byte bitsToSend = 0;
  if (szam>=0 && szam<=9)
    bitsToSend=pins[szam];
  else if (szam==-1)
    bitsToSend=0;
  else if (szam==-2)
    bitsToSend=fok;
  else
    bitsToSend=e;
  digitalWrite(SPI_SS, LOW);
  shiftOut(SPI_MOSI, SPI_SCLK, LSBFIRST, bitsToSend | ( (pont) ? pontb : 0 ));
  digitalWrite(SPI_SS, HIGH);
}


