; Ŀ
;                                                             JUIN 1996      
;                                                             DINCER SACIT   
;                                                                            
;                             AUDIOPIC V2.0                                  
;                                                                            
;                 PROCESSEUR AUDIO HI-FI COMMANDE PAR I.R.                   
;          Avec mmorisation des tats (entre/volume/effet/...) dans        
;          EEPROM et possibilit de changer les touches I.R. (RC5)           
;                                                                            
;    - Utilisation de SFH506-36 pour lire les codes RC5 du tlcommande      
;    - Utilisation du TDA8420/21 pour controler l'audio                      
;                                                                            
;                                                                            
;    HARD: AUDIOP V1 Rev.A                                                   
;    SOFT: AUDIOPIC V2.0                                                     
;    Copyright (C) SAD                                                       
;    06/1997 Dincer Sacita                                                   
;                                                                            
; 

; directive assembleur pour choisir le PIC16C84
	    list  p=16C84

; directive assembleur pour choisir les nombres par defaut DECIMAL
	    list  r=DEC

; directive assembleur pour choisir le format de sortie INHX16
	    list  f=inhx16

; directive assembleur pour inclure les reg. des PIC16C54/55/56/57/71/84
#include    "pic16c84.inc"


;***************************************************************************
;Init TRISA/TRISB pour slectionner In/Out (matrielle) 
;
initPortA   equ      b'11110001' ; input=RA0(inputIR), RA4(reset) Output=RA1(ledIR),RA2(SDA),RA3(SCL)
initPortB   equ      b'00000000' ; input=/ Output=RB0-7(7seg)
;
;I2C
O_SDA       equ      b'11110001' ;Input=RA0(RC5), RA4(reset) Output=RA1(ledIR), RA2(SDA), RA3(SCL)
I_SDA       equ      b'11110101' ;Input=RA0(RC5), RA2(SDA), RA4(reset) Output=RA1(ledIR), RA3(SCL)
;
;***************************************************************************
;Entre et sortie (matrielle)
;RC5
#define     inputIR  RA0
#define     ledIR    RA1
;I2C
#define     SDA      RA2
#define     SCL      RA3
#define     reset    RA4
;Les caractres du 7 segment
segA        equ      b'00100000'    ;RB5
segB        equ      b'00010000'    ;RB4
segC        equ      b'00000010'    ;RB1
segD        equ      b'00000100'    ;RB2
segE        equ      b'00001000'    ;RB3
segF        equ      b'10000000'    ;RB7
segG        equ      b'01000000'    ;RB6
segDP       equ      b'00000001'    ;RB0
;***************************************************************************
;
;Variables Byte
;RC5
adresIR     equ      010h
dataIR      equ      011h
;I2C
adresI2C    equ      012h
dataWrI2C   equ      013h
dataRdI2C   equ      014h
;GENERAL
flag        equ      015h
memVL1      equ      016h
memVR1      equ      017h
memBA       equ      018h
memTR       equ      019h
memS1       equ      01ah
commandAdres equ     01bh
commandData equ      01ch
memBal      equ      01dh
memV        equ      01eh
tempsIrOn   equ      01fh
tempsIrOff  equ      020h
command     equ      021h
memCase     equ      022h
tmpDataIR   equ      023h
;
;Variables Bit
;RC5
#define     errorIR   flag, 00
#define     receptIR  flag, 01
#define     newDataIR flag, 02
;I2C
#define     errorI2C flag, 03
#define     tamponZ  flag, 04   ; tampon pour mmoriser de l'INT Timer
;#define     wrI2C    bcf adresI2C, 00  ; ne va pas sur cet assembleur
;#define     rdI2C    bsf adresI2C, 00
;AUDIOP
#define     IS       memS1, BIT0 ; choix In: IS=0(in1) IS=1(in2)
#define     ML0      memS1, BIT1 ; modeCH1: ML0=ML1=0(rien) ML0=0,ML1=1(monoR)
#define     ML1      memS1, BIT2 ;          ML0=1,ML1=0(monoL) ML0=1,ML1=1(stero)
#define     STL      memS1, BIT3 ; mode: STL=EFL=0(rien) STL=0,EFL=1(pseudo S)
#define     EFL      memS1, BIT4 ;       STL=1,EFL=0(stero) STL=1,EFL=1(Spacial)
#define     MU       memS1, BIT5 ; mute: MU=0(no actif) MU=1(actif)
;#define     MH0      memS2, BIT1 ; modeCH2: MH0=MH1=0(rien) MH0=0,MH1=1(monoR)
;#define     MH1      memS2, BIT2 ;          MH0=1,MH1=0(monoL) MH0=1,MH1=1(stero)
;#define     EXS      memS2, BIT3 ; extSwicht: EXS=0(open Collector) EXS=1(masse)
;
;Variables Eeprom (0  63)
telAdres    equ      000   ; adresse des touches tlcommande 
telVolP     equ      001
telVolM     equ      002
telBasP     equ      003
telBasM     equ      004
telTreP     equ      005
telTreM     equ      006
telBalD     equ      007
telBalG     equ      008
telEff      equ      009
telMod      equ      010
telEnt      equ      011
telMut      equ      012
telNor      equ      013           
telTel      equ      014
telMem      equ      015
telP        equ      016
telM        equ      017
mem0        equ      018   ; adresses des 10 mmoires d'tat (4 bytes) 10*4bytes
memNormal   equ      058   ; adresse d'tat Normal (4 bytes)
videEE1     equ      062
videEE2     equ      063
;
;***************************************************************************
;Constante
initTelAdres equ     000h           
initTelVolP  equ     010h           
initTelVolM  equ     011h           
initTelBasP  equ     016h           
initTelBasM  equ     017h           
initTelTreP  equ     018h           
initTelTreM  equ     019h           
initTelBalD  equ     01ah           
initTelBalG  equ     01bh           
initTelEff   equ     024h           
initTelEnt   equ     023h           
initTelSel   equ     001h           
initTelMut   equ     00dh           
initTelNor   equ     00eh           
initTelTel   equ     002h           
initTelMem   equ     00ah           
initTelPlus  equ     020h           
initTelMoins equ     021h           
;
adresTelMin equ      telAdres
adresTelMax equ      telM
adresSoundI2C equ      080h
adVL1       equ      00   ;   adresse VL1 du TDA8420
adVR1       equ      01   ;   adresse VR1 du TDA8420
adBA        equ      02   ;   adresse BA du TDA8420
adTR        equ      03   ;   adresse TR du TDA8420
adS1        equ      08   ;   adresse S1 du TDA8420
adVL2       equ      04   ;   adresse VL2 du TDA8420
adVR2       equ      05   ;   adresse VR2 du TDA8420
adS2        equ      06   ;   adresse S2 du TDA8420
initVL1     equ      032         ;   init VL1
initVR1     equ      032         ;   init VR1
initBA      equ      00          ;   init BA
initTR      equ      00          ;   init TR
initS1      equ      b'11001110' ;   init S1 (modeCH1=stereo;effet=stereo;mute=NA;in=in1)
initVL2     equ      b'11000000' ;   init VL2
initVR2     equ      b'11000000' ;   init VR2
initS2      equ      b'11110001' ;   init S2 (modeCH2=rien;extSwitch=OC)
initV       equ      032         ;   init V (min)
initBal     equ      032         ;   init (milieu)
normalV     equ      047         ;   normal VL1 (0 dB)
normalBal   equ      032         ;   milieu
normalVL1   equ      047         ;   normal VL1 (0 dB)
normalVR1   equ      047         ;   normal VR1 (0 dB)
normalBA    equ      06          ;   normal BA (0 dB)
normalTR    equ      06          ;   normal TR (0 dB)
normalS1    equ      b'11001110' ;   init S1 (modeCH1=stereo;mode=stereo;mute=NA;in=in1)


;Les caractres du 7 segment
caract0     equ      segA|segB|segC|segD|segE|segF
caract1     equ      segB|segC
caract2     equ      segA|segB|segD|segE|segG
caract3     equ      segA|segB|segC|segD|segG
caract4     equ      segB|segC|segF|segG
caract5     equ      segA|segC|segD|segF|segG
caract6     equ      segA|segC|segD|segE|segF|segG
caract7     equ      segA|segB|segC
caract8     equ      segA|segB|segC|segD|segE|segF|segG
caract9     equ      segA|segB|segC|segD|segF|segG
caractA     equ      segA|segB|segC|segE|segF|segG
caractB     equ      segC|segD|segE|segF|segG
caractC     equ      segA|segD|segE|segF
caractD     equ      segB|segC|segD|segE|segG
caractE     equ      segA|segD|segE|segF|segG
caractF     equ      segA|segE|segF|segG
;
eteint      equ      0
caractErr   equ      segA|segB|segD|segE|segF|segG
caractPoint equ      segDP
caractAdres equ      caractA
caractVol   equ      segB|segC|segD|segE|segF
caractBas   equ      caractB
caractTre   equ      segD|segE|segF|segG
caractBal   equ      caract8
caractVolP  equ      caractVol|segDP
caractBasP  equ      caractBas|segDP
caractTreP  equ      caractTre|segDP
caractBalD  equ      caractBal|segDP
caractVolM  equ      caractVol
caractBasM  equ      caractBas
caractTreM  equ      caractTre
caractBalG  equ      caractBal
caractEff   equ      segA|segB|segC|segD|segG
caractEnt   equ      caractE
caractSel   equ      caract5
caractMut   equ      caract0
caractNor   equ      segC|segE|segF|segG
caractRes   equ      segE|segF|segG
caractTel   equ      segA|segD
caractMem   equ      segB|segC|segE|segF|segG
caractPlus  equ      segA
caractMoins equ      segD
caractMuteOn     equ      caract0
caractMuteOff    equ      caract1
caractSel1       equ      caract1
caractSel2       equ      caract2
caractEffSpeudo  equ      caract2
caractEffStereo  equ      caract5
caractEffSpacial equ      segA|segB|segE|segF|segG
caractEntMonoL   equ      segE|segF
caractEntMonoR   equ      segB|segC
caractEntStereo  equ      segB|segC|segE|segF


;Cte de temps du timer (INT tout les 65,536ms)
temps10sec  equ      153   ; 153*65,536ms=10sec
temps3sec   equ      46
temps1sec   equ      15
temps262ms  equ      4
temps500ms  equ      8
;
;***************************************************************************
;
;
;Macros pour le RC5
attend876   macro          ; 876=2+(comp1*3-1)+2+(comp2*3-1)
	    movlw    255   ; si comp1=255 => 876=767+comp2*3  d'ou comp2=36
	    movwf    GB    ;   comp1=255,comp2=36 => 875
	    decfsz   GB, f ; cycle=255*3-1
	    goto     $-1
	    movlw    36
	    movwf    GB
	    decfsz   GB, f
	    goto     $-1
	    endm
attend439   macro          ; 439=2+(comp1*3-1) comp1=438/3=146
	    movlw    146
	    movwf    GB
	    decfsz   GB, f
	    goto     $-1
	    endm
;
;Macros pour le I2C
rdI2C       macro
	    bsf adresI2C, 00
	    endm
wrI2C       macro
	    bcf adresI2C, 00
	    endm
;
;Macro du programme
sautAdresIrEgale  macro    adresSaut
	    call     compAdresRc5
	    btfsc    Z
	    goto     adresSaut
	    endm
;
sautDataIrEgale  macro    adresMem, adresSaut
	    movlw    adresMem
	    movwf    GA
	    call     compDataRc5
	    btfsc    Z
	    goto     adresSaut
	    endm
;
sautDataIrNonEgale  macro    adresMem, adresSaut
	    movlw    adresMem
	    movwf    GA
	    call     compDataRc5
	    btfss    Z
	    goto     adresSaut
	    endm
;
sautMemCteEgale  macro    adresMemoire, valeurEgale, adresSaut
	    movlw    valeurEgale
	    xorwf    adresMemoire, w
	    btfsc    Z
	    goto     adresSaut
	    endm
;
incMemMax   macro    adresMemoire, valeurMax
	    movlw    256-valeurMax
	    addwf    adresMemoire, w
	    btfss    C
	    incf     adresMemoire, f
	    endm
;
decMemMin   macro    adresMemoire, valeurMin
	    movlw    valeurMin+1
	    subwf    adresMemoire, w
	    btfsc    C
	    decf     adresMemoire, f
	    endm
;***************************************************************************
;FUSIBLE
;              org      FUSE84
	       __FUSES  _XT_OSC&_WDT_OFF&_PWRTE_ON&_CP_OFF

;ID0  ID3
	       org      ID0         ; ou pour ID0  ID3 => __IDLOCS  H'1234'
	       data     68h         ; ID0: code pour 'AUDIOPIC'
	       data     20h         ; ID1: version 2.0
	       data     97h         ; ID2: date anne
	       data     06h         ; ID3: date mois

;EEPROM du PIC16C84
	       org      EEPROM    ; doit etre 8 bits car EEPROM=8bits
	       data     000h,010h,011h,016h,017h,018h,019h,01ah
	       data     01bh,024h,023h,001h,00dh,00eh,002h,00ah
	       data     020h,021h,02fh,020h,066h,0ceh,02fh,020h
	       data     066h,0ceh,02fh,020h,066h,0ceh,02fh,020h
	       data     066h,0ceh,02fh,020h,066h,0ceh,02fh,020h
	       data     066h,0ceh,02fh,020h,066h,0ceh,02fh,020h
	       data     066h,0ceh,02fh,020h,066h,0ceh,02fh,020h
	       data     066h,0ceh,02fh,020h,066h,0ceh,0ffh,0ffh

;***************************************************************************
;PORGRAMME
	       org      RESET
	       goto     debut

	       org      INTERRUPT
	       bcf      tamponZ  ; sauver Z
	       btfsc    Z
	       bsf      tamponZ
	       incf     tempsIrOn,f   ; add 1 mais si =255 pas add
	       btfsc    Z
	       decf     tempsIrOn,f
	       incf     tempsIrOff,f  ; add 1 mais si =255 pas add
	       btfsc    Z
	       decf     tempsIrOff,f
	       bcf      Z
	       btfsc    tamponZ  ; recharger Z
	       bsf      Z
	       bcf      T0IF     ; mettre flag INT=0
	       retfie
;
calMaskDec: andlw    0fh      ; ATTENTION IL FAUT METTRE CE SOUS-PROGRAMME
	    addwf    PCL,f    ; A UN ADRESSE OU IL NE RISQUE PAS D'AVOIR
	    retlw    caract0  ; UN DEBORDEMENT DU PC (ADDWF PC) SUR 8 BITS.
	    retlw    caract1  ; SINON ON RISQUE D'AVOIR UN SAUT AILLEURS.
	    retlw    caract2
	    retlw    caract3
	    retlw    caract4
	    retlw    caract5
	    retlw    caract6
	    retlw    caract7
	    retlw    caract8
	    retlw    caract9
	    retlw    caractA
	    retlw    caractB
	    retlw    caractC
	    retlw    caractD
	    retlw    caractE
	    retlw    caractF
;
calMaskTel: addwf    PCL,f     ; A UN ADRESSE OU IL NE RISQUE PAS D'AVOIR
	    retlw    caractAdres
	    retlw    caractVolP
	    retlw    caractVolM
	    retlw    caractBasP
	    retlw    caractBasM
	    retlw    caractTreP
	    retlw    caractTreM
	    retlw    caractBalD
	    retlw    caractBalG
	    retlw    caractEff
	    retlw    caractEnt
	    retlw    caractSel
	    retlw    caractMut
	    retlw    caractNor
	    retlw    caractTel
	    retlw    caractMem
	    retlw    caractPlus
	    retlw    caractMoins
	    retlw    caractRes
;
calInitTel: addwf    PCL,f
	    retlw    initTelAdres
	    retlw    initTelVolP
	    retlw    initTelVolM
	    retlw    initTelBasP
	    retlw    initTelBasM
	    retlw    initTelTreP
	    retlw    initTelTreM
	    retlw    initTelBalD
	    retlw    initTelBalG
	    retlw    initTelEff
	    retlw    initTelEnt
	    retlw    initTelSel
	    retlw    initTelMut
	    retlw    initTelNor
	    retlw    initTelTel
	    retlw    initTelMem
	    retlw    initTelPlus
	    retlw    initTelMoins
;
debut:      call     init         ; init general (PORTs, valeur par defaut)
	    call     initI2C      ; init I2C (avant utilisation)
	    call     initTimer    ; init INT Timer
	    call     attend1sec   ; attendre 1 seconde
	    goto     ecritSeqIc   ; initialiser le circuit
program:    btfss    inputIR      ; attend qu'il n'y a plus d'IR pour avoir debut IR
	    goto     program
	    clrf     tempsIrOff   ; tempsNonAppuy=0 car recue IR(appuy)
finRecIR:   sautMemCteEgale command, 04, verifNonAppReset
	    btfss    reset
	    goto     recReset
	    sautMemCteEgale command, 01, verifNonAppC01
	    sautMemCteEgale command, 02, verifNonAppC02
	    sautMemCteEgale command, 03, verifNonAppC03
	    sautMemCteEgale tempsIrOff, 254, eteintAff
finRecIR1:  btfsc    inputIR      ; attend de recevoir IR
	    goto     finRecIR
	    call     recoitIR    ; lit le RC5
	    btfsc    errorIR
	    goto     program
	    call     detectNewDataIR
	    btfsc    newDataIR
	    clrf     tempsIrOn     ; tempsAppuy=0 si on a appuy  une nouvelle touche
	    sautAdresIrEgale suivant     ; continue si adresIR est celle choisie
	    goto     program
suivant:    btfss    newDataIR
	    goto     suivant1
	    sautMemCteEgale command, 01, recMemGen
suivant1:   sautMemCteEgale command, 02, recMemCase
	    sautMemCteEgale command, 03, recTel10s
	    sautDataIrEgale telVolP, recVolumeP
	    sautDataIrEgale telVolM, recVolumeM
	    sautDataIrEgale telTreP, recAiguP
	    sautDataIrEgale telTreM, recAiguM
	    sautDataIrEgale telBasP, recBassP
	    sautDataIrEgale telBasM, recBassM
	    sautDataIrEgale telBalD, recBalD
	    sautDataIrEgale telBalG, recBalG
	    btfss    newDataIR               ; si premier touche continuer
	    goto     program
	    sautDataIrEgale telNor, recNormal
	    sautDataIrEgale telMut, recMute
	    sautDataIrEgale telEff, recEffet
	    sautDataIrEgale telMod, recMode
	    sautDataIrEgale telEnt, recEntree
	    sautDataIrEgale telMem, recMem
	    sautDataIrEgale telTel, recTelCom
finProgram: btfss    errorI2C
	    goto     finProg2
	    movlw    caractErr
	    movwf    PORTB
finProg2:   goto     program
;
detectNewDataIR: bsf      newDataIR      ; DETECTE NEWDATAIR en f(dataIR, tempsIrOff)
	    movf     dataIR, w
	    xorwf    tmpDataIR, w
	    btfss    Z
	    goto     nonNewData
	    movlw    256-temps262ms
	    addwf    tempsIrOff, w
	    btfsc    C
	    goto     nonNewData     ; >= temps262ms
	    bcf      newDataIR      ; < temps262ms
nonNewData: movf     dataIR, w          
	    movwf    tmpDataIR     
	    return
;
verifNonAppReset:
	    btfsc    reset
	    goto     nonAppReset
	    movlw    256-temps10sec
	    addwf    tempsIrOn, w
	    btfss    C
	    goto     finProgram      ; < temps10s
	    clrf     command         ; >= temps10s si appuy plus de 10sec alors menu TEL
	    movlw    caractRes
	    iorlw    caractPoint
	    movwf    PORTB
attOffReset: btfss    reset
	    goto     attOffReset
	    clrf     PORTB
	    goto     resetTouche
nonAppReset: movlw    256-temps262ms
	    addwf    tempsIrOff, w
	    btfss    C
	    goto     finRecIR       ; < temps262ms
	    goto     effComPortB    ; >= temps262ms
;
recReset:   movlw    04
	    movwf    command
	    clrf     tempsIrOn     ; tempsAppuy=0
	    movlw    caractRes
	    movwf    PORTB
	    goto     finProgram
;
resetTouche: movlw    255        ; ENREGISTRER DE 0  adresTelMax les valeurs par dfaut dans EEPROM
	    movwf    GA 
resetTB:    incf     GA,f
	    movf     GA, w
	    call     calInitTel
	    movwf    GB
	    call     ecritEeprom  ; ecrit GB  l'adresse GA
	    movlw    256-adresTelMax
	    addwf    GA, w
	    btfss    C
	    goto     resetTB
	    goto     finProgram
;
verifNonAppC03:
	    movlw    256-temps262ms ; APRES 262MS NON APPUYE command=0
	    addwf    tempsIrOff, w
	    btfss    C
	    goto     finRecIR1      ; < temps262ms
effComPortB: clrf     PORTB        ; >= temps262ms
effCommand: clrf     command
	    goto     finProgram
;
recTelCom:  movlw    03
	    movwf    command
	    movlw    caractTel
	    movwf    PORTB
	    goto     finProgram
;
recTel10s:  movlw    256-temps10sec   ; ALLER DANS MENU RECTEL SI APPUYE PLUS DE 10 SEC SUR MEME TOUCHE
	    addwf    tempsIrOn, w
	    btfss    C
	    goto     finProgram      ; < temps10s
	    clrf     command         ; >= temps10s si appuy plus de 10sec alors menu TEL
	    goto     recTel
;
recTel:     clrf     memCase
recTel1:    movf     memCase, w
	    call     calMaskTel
	    movwf    PORTB
recTel2:    btfss    inputIR      ; attend qu'il n'y a plus d'IR pour avoir debut IR
	    goto     recTel2
	    clrf     tempsIrOff   ; tempsNonAppuy=0 car recue IR(appuy)
recTelAtt:  sautMemCteEgale command, 01, recTelNonAppC01
recTelAtt1: sautMemCteEgale tempsIrOff, 255, recTelSortir  ; apres 17sec non appuy sortir
	    btfsc    inputIR      ; attend de recevoir IR
	    goto     recTelAtt
	    call     recoitIR     ; lit le RC5
	    btfsc    errorIR
	    goto     recTel2
	    call     detectNewDataIR
	    btfsc    newDataIR
	    clrf     tempsIrOn     ; tempsAppuy=0 si on a appuy  une nouvelle touche
;            sautAdresIrEgale recTelAdr     ; continue si adresIR est celle choisie
;            goto     recTel2
recTelAdr:  btfss    newDataIR
	    goto     recTelNNT         ; saut non nouvelle touche
	    sautDataIrEgale telP, recTelP  ; nouvelle touche
	    sautDataIrEgale telM, recTelM
	    sautMemCteEgale command, 00, recTelGen
recTelNNT:  sautMemCteEgale command, 01, recTelCase
finRecTel:  goto     recTel2
;
recTelNonAppC01:
	    movlw    256-temps262ms ; APRES 262MS NON APPUYE command=0 + sortir
	    addwf    tempsIrOff, w
	    btfss    C
	    goto     finRecTelNA      ; < temps262ms
recTelSortir: goto     effComPortB    ; >= temps262ms
finRecTelNA: goto     recTelAtt1
;
recTelP:    incMemMax      memCase, adresTelMax
	    goto     recTel1
;
recTelM:    decMemMin      memCase, adresTelMin
	    goto     recTel1
;
recTelGen:  movf     memCase,f ; COMPARER SI LA TOUCHE APPUYE NE CORRESPOND PAS A UNE TOUCHE 
	    btfsc    Z         ; MEMORISE TEL DANS EEPROM (si = touche mmoris alors sortir sinon commande suivant)
	    goto     recTelGCS   ; commande suivant car adresTel
	    clrf     GA          ; GA=0
recTelGBL:  incf     GA,f
	    call     compDataRc5  ; boucle lecture (adresseEEPROM=GA)
	    btfsc    Z
	    goto     recTelSortir ; correspond a une touche mmoris donc sortir
	    movlw    256-adresTelMax
	    addwf    GA, w
	    btfss    C
	    goto     recTelGBL
recTelGCS:  movlw    01
	    movwf    command
	    goto     finRecTel
;
recTelCase: movlw    256-temps3sec   ; ENREGISTRER SI APPUYE PLUS DE 3 SEC SUR MEME TOUCHE
	    addwf    tempsIrOn, w
	    btfss    C
	    goto     finRecTel       ; < temps3s
	    clrf     PORTB           ; >= temps3s si appuy plus de 3sec alors enregistrer
	    clrf     tempsIrOff
recTelCAtt: sautMemCteEgale tempsIrOff, temps500ms, recTelCAff ; attend 0,5sec 
	    goto     recTelCAtt
recTelCAff: movf     memCase, w
	    call     calMaskTel
	    movwf    PORTB
	    movf     memCase, w
	    movwf    GA
	    movf     memCase,f ; si memCase=0 alors enreg adresIR
	    btfsc    Z         
	    goto     recTelCA  ; enreg adresIR
	    movf     dataIR, w
recTelCE:   movwf    GB
	    call     ecritEeprom  ; ecrit dataIR ou adresIR  l'adresse memCase
	    clrf     command         ; effacer command aprs avoir enregistr
	    goto     finRecTel
recTelCA:   movf     adresIR, w
	    goto     recTelCE
;
;
eteintAff:  clrf     PORTB
	    goto     finRecIR1
;
verifNonAppC01:
	    movlw    256-temps3sec   ; APRES 3SEC NON APPUYE command=0
	    addwf    tempsIrOff, w
	    btfss    C
	    goto     finVNAC01      ; < temps3s
	    clrf     command        ; >= temps3s
	    clrf     PORTB
finVNAC01:  goto     finRecIR1
;
verifNonAppC02:
	    movlw    256-temps262ms ; APRES 262MS NON APPUYE command=0 + posMemCase
	    addwf    tempsIrOff, w
	    btfss    C
	    goto     finVNAC02      ; < temps262ms
	    clrf     command        ; >= temps262ms
	    call     affMemCase      
	    movwf    PORTB
	    goto     posMemCase
finVNAC02:  goto     finRecIR1
;
recMemGen:  movlw    256-10           ;PASSER COMMAND SUIVANT SI RECUE 0  9 ou Normal=14 => 10
	    addwf    dataIR, w
	    btfsc    C
	    goto     recMemGen3       ; >=10 tester si Normal
recMemGen2: incf     command,f        ; < 10 mettre command=2 si touche 0  9
	    movf     dataIR, w
	    movwf    memCase          ; mmoriser case mmoire appuy
	    goto     finProgram
recMemGen3: sautDataIrNonEgale telNor, effCommand  ;PASSER COMMAND SUIVANT Normal=14 => 10 Sinon effacer Command
	    movlw    10
	    movwf    dataIR
	    goto     recMemGen2
;            
recMemCase: movlw    256-temps3sec   ; ENREGISTRER SI APPUYE PLUS DE 3 SEC SUR MEME TOUCHE
	    addwf    tempsIrOn, w
	    btfss    C
	    goto     finProgram      ; < temps3s
	    call     affMemCase      ; >= temps3s si appuy plus de 3sec alors enregistrer
	    iorlw    caractPoint
	    movwf    PORTB
	    call     enregMemCase
	    goto     effCommand     ; effacer command aprs avoir enregistr 
;
affMemCase: movlw    10
	    xorwf    memCase, w
	    btfsc    Z
	    retlw    caractNor
	    movf     memCase, w
	    call     calMaskDec
	    return
;
posMemCase: movlw    mem0
	    movwf    GA
	    incf     memCase,f
litMCBoucl: decfsz   memCase,f
	    goto     litMCAdd4
	    call     litEeprom    ; lit Vol addRel=0
	    movf     GB, w
	    movwf    memV
	    incf     GA,f         ; lit Bal addRel=1
	    call     litEeprom
	    movf     GB, w
	    movwf    memBal
	    incf     GA,f         ; lit Tre(H)+Bas(L) addRel=2
	    call     litEeprom
	    movf     GB, w
	    andlw    00fh
	    movwf    memBA
	    swapf    GB, w
	    andlw    0fh
	    movwf    memTR
	    incf     GA,f         ; lit S1 addRel=3
	    call     litEeprom
	    movf     GB, w
	    movwf    memS1
	    call     reglageVol
	    goto     ecritSeqIc
litMCAdd4:  movlw    4
	    addwf    GA,f
	    goto     litMCBoucl
;
enregMemCase: movlw    mem0
	    movwf    GA
	    incf     memCase,f
engMCBoucl: decfsz   memCase,f
	    goto     engMCAdd4
	    movf     memV, w
	    movwf    GB
	    call     ecritEeprom  ; ecrit Vol addRel=0
	    incf     GA,f
	    movf     memBal, w
	    movwf    GB
	    call     ecritEeprom  ; ecrit Bal addRel=1
	    incf     GA,f
	    swapf    memTR, w
	    iorwf    memBA, w
	    movwf    GB
	    call     ecritEeprom  ; ecrit Tre+Bass addRel=2
	    incf     GA,f
	    movf     memS1, w
	    movwf    GB
	    call     ecritEeprom  ; ecrit S1 addRel=3
	    return
engMCAdd4:  movlw    4
	    addwf    GA,f
	    goto     engMCBoucl
;
recMem:     movlw    01
	    movwf    command
	    movlw    caractMem
	    movwf    PORTB
	    goto     finProgram
;
reglageVol: movlw    256-32          ; VOL R
	    addwf    memBal, w
	    btfss    C
	    goto     reglagInf31     ; < 32
	    clrw                     ; >= 32
	    goto     reglagVR1
reglagInf31: movf     memBal, w
	    sublw    32
reglagVR1:  subwf    memV, w
	    movwf    GA
	    movlw    32
	    subwf    GA, w
	    btfsc    C
	    goto     reglagVR2     ; est >=32
	    movlw    32            ; est < 32 donc =32
	    movwf    GA
reglagVR2:  movf     GA, w
	    movwf    memVR1
	    movlw    33           ; VOL L
	    subwf    memBal, w
	    btfsc    C
	    goto     reglagSup31  ; > 32
	    clrw                  ; < 33 ou <=32
	    goto     reglagVL1
reglagSup31: movlw    32 
	    subwf    memBal, w
reglagVL1:  subwf    memV, w
	    movwf    GA
	    movlw    32
	    subwf    GA, w
	    btfsc    C
	    goto     reglagVL2     ; est >=32
	    movlw    32            ; est < 32 donc =32
	    movwf    GA
reglagVL2:  movf     GA, w
	    movwf    memVL1
	    return
;
recVolumeP: incMemMax      memV, 63
	    btfss    MU
	    goto     affMemVol
	    bcf      MU
	    movlw    adS1
	    movwf    commandAdres
	    movf     memS1, w
	    movwf    commandData
	    call     ecritCommandIc
	    call     stopI2C
affMemVol:  movf     memV, w
afficheW:   call     afficheHex
	    call     reglageVol
	    goto     ecritVolumeIc
;
recVolumeM: decMemMin      memV, 32
	    goto     affMemVol
;
recBalD:    incMemMax      memBal, 47
affMemBal:  movf     memBal, w
	    goto     afficheW
;
recBalG:    decMemMin      memBal, 17
	    goto     affMemBal
;
recAiguP:   incMemMax      memTR, 15
	    goto     ecritAiguIc
;
recAiguM:   decMemMin      memTR, 0
	    goto     ecritAiguIc
;
recBassP:   incMemMax      memBA, 15
	    goto     ecritBassIc
;
recBassM:   decMemMin      memBA, 0
	    goto     ecritBassIc
;
recNormal:  movlw    caractNor
	    movwf    PORTB
	    movlw    10        ; se mettre sur la mmoire 10 = adres Normal
	    movwf    memCase
	    goto     posMemCase
;
recMute:    movlw    b'00100000' ; 1  l'emplacement de MU => complementer MU
	    xorwf    memS1, f    ;
	    call     afficheMute
	    goto     ecritS1Ic
;
recEffet:   movf     memS1, w
	    btfsc    STL
	    xorlw    b'00010000'
	    movwf    memS1
	    btfsc    EFL
	    xorlw    b'00001000'
	    movwf    memS1
	    call     afficheEffet
	    goto     ecritS1Ic
;
recMode:    movf     memS1, w
	    btfsc    ML0
	    xorlw    b'00000100'
	    movwf    memS1
	    btfsc    ML1
	    xorlw    b'00000010'
	    movwf    memS1
	    call     afficheMode
	    goto     ecritS1Ic
;
recEntree:  movlw    b'00000001' ; complementer IS
	    xorwf    memS1, f    ;
	    call     afficheEntree
	    goto     ecritS1Ic
;
afficheHex: call     calMaskDec
	    movwf    PORTB
	    return
;
afficheMute: btfss    MU
	    movlw    caractMuteOff
	    btfsc    MU
	    movlw    caractMuteOn
	    movwf    PORTB
	    return
;
afficheEntree: btfss    IS
	    movlw    caractSel1
	    btfsc    IS
	    movlw    caractSel2
	    movwf    PORTB
	    return
;
afficheEffet: btfsc    STL
	     goto     affEffAutre
	     btfss    EFL
	     goto     afficheEffF            ; 00
	     movlw    caractEffSpeudo      ; 10
	     goto     afficheEffP
affEffAutre: btfss    EFL            
	     goto     affEffSte              
	     movlw    caractEffSpacial     ; 11
	     goto     afficheEffP
affEffSte:   movlw    caractEffStereo      ; 01
afficheEffP: movwf    PORTB
afficheEffF: return
;
afficheMode: btfsc    ML0
	     goto     affModeAutre
	     btfss    ML1
	     goto     afficheModeF         ; 00
	     movlw    caractEntMonoR      ; 10
	     goto     afficheModeP
affModeAutre: btfss    ML1            
	     goto     affModeL             
	     movlw    caractEntStereo     ; 11
	     goto     afficheModeP
affModeL:    movlw    caractEntMonoL      ; 01
afficheModeP: movwf    PORTB
afficheModeF: return
;
ecritVolumeIc:
	    movlw    adVL1
	    movwf    commandAdres
	    movf     memVL1, w
	    iorlw    b'11000000'
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritVolumeIc
	    movlw    adVR1
	    movwf    commandAdres
	    movf     memVR1, w
	    iorlw    b'11000000'
	    movwf    commandData
	    call     ecritCommandIc
finEcritVolumeIc:
	    call     stopI2C
	    goto     finProgram
;
ecritBassIc:
	    movlw    adBA
	    movwf    commandAdres
	    movf     memBA, w
	    iorlw    b'11110000'
	    movwf    commandData
	    call     ecritCommandIc
finEcritBassIc:
	    call     stopI2C
	    movf     memBA, w
	    call     afficheHex
	    goto     finProgram
;
ecritAiguIc:
	    movlw    adTR
	    movwf    commandAdres
	    movf     memTR, w
	    iorlw    b'11110000'
	    movwf    commandData
	    call     ecritCommandIc
finEcritAiguIc:
	    call     stopI2C
	    movf     memTR, w
	    call     afficheHex
	    goto     finProgram
;
ecritS1Ic:
	    movlw    adS1
	    movwf    commandAdres
	    movf     memS1, w
	    movwf    commandData
	    call     ecritCommandIc
finEcritS1Ic:
	    call     stopI2C
	    goto     finProgram
;
ecritCommandIc:
	    call     envoyeAdresI2C
	    btfsc    errorI2C
	    goto     finEcritCommandIc
	    movf     commandAdres, w
	    movwf    dataWrI2C
	    call     envoyeDataI2C
	    btfsc    errorI2C
	    goto     finEcritCommandIc
	    movf     commandData, w
	    movwf    dataWrI2C
	    call     envoyeDataI2C
	    btfsc    errorI2C
	    goto     finEcritCommandIc
finEcritCommandIc:
	    retlw    0

;
ecritSeqIc: wrI2C
	    movlw    adVL1
	    movwf    commandAdres
	    movf     memVL1, w
	    iorlw    b'11000000'
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adVR1
	    movwf    commandAdres
	    movf     memVR1, w
	    iorlw    b'11000000'
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adBA
	    movwf    commandAdres
	    movf     memBA, w
	    iorlw    b'11110000'
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adTR
	    movwf    commandAdres
	    movf     memTR, w
	    iorlw    b'11110000'
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adS1
	    movwf    commandAdres
	    movf     memS1, w
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adVL2
	    movwf    commandAdres
	    movlw    initVL2
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adVR2
	    movwf    commandAdres
	    movlw    initVR2
	    movwf    commandData
	    call     ecritCommandIc
	    btfsc    errorI2C
	    goto     finEcritSeqIc
	    movlw    adS2
	    movwf    commandAdres
	    movlw    initS2
	    movwf    commandData
	    call     ecritCommandIc
finEcritSeqIc:
	    call     stopI2C
	    goto     finProgram
;
litEeprom:  movf     GA, w        ; GA > adres EEPROM
	    movwf    EEADR
	    bsf      RP0          ; bank 1
	    bsf      RD
	    bcf      RP0          ; bank 0
	    movf     EEDATA, w
	    movwf    GB
	    retlw    0
;
ecritEeprom: movf     GA, w        ; GA > adres EEPROM
	    movwf    EEADR
	    movf     GB, w
	    movwf    EEDATA
	    bsf      RP0          ; bank 1
	    bcf      GIE          ; disable all INT
	    movlw    055h         ; obligatoire (envoyer cette squence)
	    movwf    EECON2
	    movlw    0aah
	    movwf    EECON2
	    bsf      WR
attEcrit:   btfsc    WR           ; attend jusqu' l'criture (10ms)
	    goto     attEcrit
	    bsf      GIE          ; enable all INT
	    bcf      RP0          ; bank 0
	    retlw    0
;
compAdresRc5: movlw    telAdres
	    movwf    GA
	    call     litEeprom
	    movf     GB, w
	    xorwf    adresIR, w
	    return
;
compDataRc5: call     litEeprom
	    movf     GB, w
	    xorwf    dataIR, w
	    return
;
attend1sec: movlw    256-temps1sec   ; ATTENDRE 1 SECONDE
	    addwf    tempsIrOff, w
	    btfss    C
	    goto     attend1sec     ; < temps1s
	    return                  ; >= temps1s
;
init:       bsf      RP0   ; bank 1 car on modifie TRISA ou TRISB qui est dans bank1
	    movlw    initPortA                 ; initialiser les PORTs
	    movwf    TRISA
	    movlw    initPortB
	    movwf    TRISB
	    bcf      RP0
	    clrf     PORTB       ; eteint les leds
	    movlw    adresSoundI2C ; init adresI2C
	    movwf    adresI2C
	    movlw    initVL1      ; init valeur de reset
	    movwf    memVL1
	    movlw    initVR1
	    movwf    memVR1
	    movlw    initBA
	    movwf    memBA
	    movlw    initTR
	    movwf    memTR
	    movlw    initS1
	    movwf    memS1
	    movlw    initV
	    movwf    memV
	    movlw    initBal
	    movwf    memBal
	    clrf     tempsIrOn
	    clrf     tempsIrOff
	    clrf     command
	    bsf      RP0          ; bank 1 pour EECON1
	    bsf      WREN         ; EECON1 permettre l'ecriture sur EEPROM
	    bcf      RP0          ; bank 0
;            movlw    initVL2  ; ne pas mettre car on employe pas la sortie 2
;            movwf    memVL2   ; donc il n'y a pas de variable (mmXXX), en fin
;            movlw    initVR2  ; de compte seul initXXX est envoye partout
;            movwf    memVR2
;            movlw    initS2
;            movwf    memS2
	    retlw    0
;
;****************************************************************************
; initialiser les interruptions du timer  15,26Hz (65,536ms)
; INT tout les = ((4MHz/4)/256)/256=15,26Hz
;****************************************************************************
initTimer:  bsf      RP0   ; bank 1 car on modifie OPTION
	    bcf      T0CS  ; clock pour timer= osc/4
	    bcf      PSA   ; diviser le clock par le prescalier
	    bsf      PS2   ; mettre le diviseur (prescalier)  256
	    bsf      PS1
	    bsf      PS0
	    bcf      RP0   ; bank 0
	    clrf     TMR0  ; mettre Timer=0
	    bcf      T0IF  ; mettre flag INT Timer  0
	    bsf      GIE   ; permettre les INTs (gnrale)
	    bsf      T0IE  ; permettre (enable) INT Timer (si dpassement 255) donc diviser par 256
	    return
;
; Ŀ
;                                                         SEPTEMBRE 1995     
;                                                         DINCER SACIT       
;                                                                            
;     MODULE POUR PICx PERMETTANT DE LIRE LES COMMANDES DES TELECOMMANDES    
;                  RC5 (Philips) avec un Quartz de 4MHz.                     
;                                                                            
;                                                                            
;  1. recoitIR: module permettant de lire les signaux RC5.                   
;     INPUT   /                                                              
;     OUTPUT  adresIR (Byte): adresses des appareils command (5 bits)       
;                             ex: 0=tlvision                               
;                                 5=magntoscope                             
;             dataIR (Byte): commande (6 bits) des appareils                 
;                            ex: 16=volume +                                 
;                                17=volume -                                 
;             receptIR (Bit): est '1' si recu IR (est un jeton pour que le   
;                             program sache qu'il a rucue un signal IR)      
;             errorIR (Bit): est '0' si c'est bien un signal RC5             
;                            est '1' si ce n'est pas un signal RC5           
; 
;                        SCHEMA DE PRINCIPE :
;                        
;               +5V                                      Ŀ
;                                                              
;                47 Ohm                                         
;                  47F                                        
;                Ŀ +                                 PIC x  
;                                                           
;                                                           
;              Ŀ                                           
;         --->  SĴRA0      
;                                                            
;                SFH506-36                                       
;                (dtecteur IR et filtre)                      
;                                 ĴRA1      
;                                                              
;                                 390 Ohm                       
;                                                              
;                               Ŀ+                            
;                          <--- led                             
;                                                            
;                                                     
;
;
;
;PROGRAM
recoitIR:   bcf      GIE          ; disable all INT
	    bsf      ledIR
	    bcf      errorIR
	    bsf      receptIR
	    attend439         ; 444s - (5cycle*T) ex(4MHz): 444-5*1=439s
	    movlw    14
	    movwf    GA
boucleIR:   bsf      C
	    btfss    inputIR
	    bcf      C
	    btfsc    C
	    goto     verifPrec
	    nop
	    btfsc    receptIR
	    goto     compense
	    bsf      errorIR
	    goto     verifFin
compense:   goto     verifFin
verifPrec:  btfss    receptIR
	    goto     compense
	    bsf      errorIR
	    goto     verifFin
verifFin:   rlf      dataIR, f
	    rlf      adresIR, f
	    attend876          ; 889s - (13cycle*T) ex(4MHz): 889-13*1=876s
	    bsf      receptIR
	    btfss    inputIR
	    bcf      receptIR
	    movlw    2         ; attente de 7=2+(nbr*3-1) o nbr=2
	    movwf    GB
	    decfsz   GB, f
	    goto     $-1
	    attend876          ; 889s - (13cycle*T) ex(4MHz): 889-13*1=876s
	    decfsz   GA, f
	    goto     boucleIR
	    movf     adresIR, w
	    andlw    b'00110000'
	    btfss    Z
	    bsf      errorIR
	    movf     dataIR, w
	    movwf    GA
	    rlf      GA, f
	    rlf      adresIR, f
	    rlf      GA, f
	    rlf      adresIR, f
	    comf     adresIR, w
	    andlw    b'00011111'
	    movwf    adresIR
	    comf     dataIR, w
	    andlw    b'00111111'
	    movwf    dataIR
finIR:      bsf      receptIR
	    bcf      ledIR
	    bsf      GIE          ; enable all INT
	    retlw    0
;
; Ŀ
;                                                             SEPTEMBRE 1995 
;                                                             DINCER SACIT   
;                                                                            
;         MODULE PERMETTANT LA LECTURE ET L'ECRITURE SUR LE BUS IC          
;                   POUR LES PICs (EN MAITRE SEULEMENT).                     
;                                                                            
;                                                                            
;  Ces modules permettent d'ecrire et lire sur le bus IC, la vitesse de     
;  transmission est de 100kHz avec un quartz XT de 4MHz.                     
;                                                                            
;  1. initI2C: module d'initialisation du port I2C (sera appel qu'une seule 
;           fois avant l'utilisation des modules I2C)                        
;     INPUT   /                                                              
;     OUTPUT  /                                                              
;  2. envoyeAdresI2C: module qui envoye le 'START' et adresse le circuit     
;                     intgr I2C celui-ci repond par un 'ACK' s'il est      
;                     prsent sur le bus I2C.                                
;     INPUT   adresI2C (Byte):  l'adresse de circuit sur 8 bits o le bit0   
;                               est le Rd/Wr (0=Wr, 1=Rd).                   
;     OUTPUT  flag.errorI2C (Bit): est =1 si pas de ACK.                     
;  3. envoyeDataI2C: module qui envoye les donnes au le circuit intgr I2C 
;     INPUT   dataWrI2C (Byte): la donne a envoyer sur 8 bits               
;     OUTPUT  flag.errorI2C (Bit): est =1 si pas de ACK.                     
;  4. recoitDataI2C: module qui lit les donnes du bus I2C en envoyant       
;                    un ACK  la fin                                         
;     INPUT   /                                                              
;     OUTPUT  dataRdI2C (Byte): est la donne 8 bits lue du bus I2C          
;  5. recoitDataNaI2C: module qui lit les donnes du bus I2C sans envoyer    
;                      de ACK  la fin                                       
;     INPUT   /                                                              
;     OUTPUT  dataRdI2C (Byte): est la donne 8 bits lue du bus I2C          
;  6. stopI2C: module qui met fin a la communication avec le bus I2C         
;     INPUT   /                                                              
;     OUTPUT  /                                                              
;  7. rdI2C: est un macro, il suffit de mettre 'rdI2C' alors le BIT0 de      
;            adresIR est mit  '1' (lecture)                                 
;     wrI2C: est un macro, il suffit de mettre 'wrI2C' alors le BIT0 de      
;            adresIR est mit  '0' (ecriture)                                
;                                                                            
; 
;                        SCHEMA DE PRINCIPE :
;                        
;                                                   +5V        Ŀ
;                                                 Ŀ               
;                                                                 
;                                            3,3k     3,3k          
;                                                                 
;   -----SCLĳĴ               
;   -----ĳĳSDAĴ             PIC x  
;                                                             
;                                 330     330           
;       (100   100)   (100   100)                         
;                                          ĴRA3(SCL) 
;          Ŀ         Ŀ                                 
;          SDA SCL         SDA SCL            ĴRA2(SDA) 
;            IC             IC                                    
;                                            
;PROGRAM
initI2C:    bcf      SCL
	    bsf      SDA
	    bsf      RP0   ; bank 1 car on modifie TRISA ou TRISB qui est dans bank1
	    movlw    O_SDA     ;mettre SDA et SCL en sortie
	    movwf    TRISA
	    bcf      RP0
stopI2C:    bcf      GIE          ; disable all INT
	    bcf      SDA
	    nop
	    bsf      SCL
	    nop
	    nop
	    nop
	    nop
	    bsf      SDA
	    bsf      GIE          ; enable all INT
	    retlw    0
;
envoyeAdresI2C:
	    bcf      GIE          ; disable all INT
	    bsf      SCL  ;startI2C
	    nop
	    nop
	    nop
	    nop
	    bcf      SDA
	    movf     adresI2C, w
	    goto     sendI2C
;
envoyeDataI2C:
	    bcf      GIE          ; disable all INT
	    movf     dataWrI2C, w
sendI2C:    movwf    GB           ;sendI2C
	    movlw    08
	    movwf    GA
boucleSI2C: rlf      GB, f
	    bcf      SCL
	    btfsc    C
	    bsf      SDA
	    btfss    C
	    bcf      SDA
	    bsf      SCL
	    decfsz   GA, f
	    goto     boucleSI2C
	    nop
	    movlw    I_SDA      ;mettre SDA en entre et SCL en sortie
	    bcf      SCL
	    bsf      RP0   ; bank 1 car on modifie TRISA ou TRISB qui est dans bank1
	    movwf    TRISA
	    bcf      RP0
	    nop
	    bsf      SCL
	    nop
	    bsf      errorI2C
	    btfss    SDA
	    bcf      errorI2C
	    bcf      SCL
	    movlw    O_SDA      ;mettre SDA et SCL en sortie
	    bsf      RP0   ; bank 1 car on modifie TRISA ou TRISB qui est dans bank1
	    movwf    TRISA
	    bcf      RP0
	    bsf      SDA
	    bsf      GIE          ; enable all INT
	    retlw    0
;
recoitDataNaI2C:
	    bsf      GB, BIT0       ;**
	    goto     recoitDataI2C1 ;**
recoitDataI2C:
	    bcf      GIE          ; disable all INT
	    bcf      GB, BIT0       ;**
recoitDataI2C1:
	    movlw    08
	    movwf    GA
	    movlw    I_SDA
	    bsf      RP0   ; bank 1 car on modifie TRISA ou TRISB qui est dans bank1
	    movwf    TRISA ;mettre SDA en entre et SCL en sortie
	    bcf      RP0
boucleRI2C: bcf      SCL
	    nop
	    nop
	    nop
	    movlw    O_SDA      ;mettre SDA et SCL en sortie aprs
	    bsf      SCL
	    bsf      C
	    btfss    SDA
	    bcf      C
	    rlf      dataRdI2C, f
	    decfsz   GA, f
	    goto     boucleRI2C
	    bcf      SCL
	    bsf      RP0   ; bank 1 car on modifie TRISA ou TRISB qui est dans bank1
	    movwf    TRISA ;mettre SDA et SCL en sortie
	    bcf      RP0
	    btfss    GB, BIT0   ;mattre ACK ou pas
	    bcf      SDA
	    btfsc    GB, BIT0
	    bsf      SDA
	    bsf      SCL
	    nop
	    nop
	    nop
	    nop
	    bcf      SCL
	    bsf      SDA
	    bsf      GIE          ; enable all INT
	    retlw    0
;
	    END

