        LIST
; P16C84.INC  Standard Header File, Version 1.00    Microchip Technology, Inc.
        NOLIST

; This header file defines configurations, registers, and other useful bits of
; information for the PIC16C84 microcontroller.  These names are taken to match 
; the data sheets as closely as possible.  

; Note that the processor must be selected before this file is 
; included.  The processor may be selected the following ways:

;       1. Command line switch:
;               C:\ MPASM MYFILE.ASM /PIC16C84
;       2. LIST directive in the source file
;               LIST   P=PIC16C84
;       3. Processor Type entry in the MPASM full-screen interface

;==========================================================================
;
;       Revision History
;
;==========================================================================

;Rev:   Date:    Reason:

;1.00   10/31/95 Initial Release

;==========================================================================
;
;       Verify Processor
;
;==========================================================================

        IFNDEF __16C84
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF

;==========================================================================
;
;       Register Definitions
;
;==========================================================================

W                            EQU     H'0000'
F                            EQU     H'0001'

;----- Register Files------------------------------------------------------

INDF                         EQU     H'0000'
TMR0                         EQU     H'0001'
PCL                          EQU     H'0002'
STATUS                       EQU     H'0003'
FSR                          EQU     H'0004'
PORTA                        EQU     H'0005'
PORTB                        EQU     H'0006'
EEDATA                       EQU     H'0008'
EEADR                        EQU     H'0009'
PCLATH                       EQU     H'000A'
INTCON                       EQU     H'000B'

OPTION_REG                   EQU     H'0081'
TRISA                        EQU     H'0085'
TRISB                        EQU     H'0086'
EECON1                       EQU     H'0088'
EECON2                       EQU     H'0089'

;----- VARIABLES GENERALES ------------------------------------------------

GA          equ      0fh   ; variables gnrales
GB          equ      0eh
GC          equ      0dh
GD          equ      0ch
GE          equ      0bh
GF          equ      0ah
GG          equ      09h
GH          equ      08h
GI          equ      07h

;----- LES ADRESSES -------------------------------------------------------

ID0         equ      02000h
EEPROM      equ      02100h
RESET       equ      0000h
INTERRUPT   equ      0004h

;----- DIVERS -------------------------------------------------------------

; DIVERS
BIT0        equ   00
BIT1        equ   01
BIT2        equ   02
BIT3        equ   03
BIT4        equ   04
BIT5        equ   05
BIT6        equ   06
BIT7        equ   07
LSB         equ   00Fh
MSB         equ   0F0h
TRUE        equ   01h
YES         equ   01h
FALSE       equ   0h
NO          equ   0h

;----- INTCON Bits --------------------------------------------------------

; BIT INTCON
#define     RBIF      INTCON, BIT0
#define     INTF      INTCON, BIT1
#define     T0IF      INTCON, BIT2
#define     RBIE      INTCON, BIT3
#define     INTE      INTCON, BIT4
#define     T0IE      INTCON, BIT5
#define     EEIE      INTCON, BIT6
#define     GIE       INTCON, BIT7

;----- OPTION Bits --------------------------------------------------------

; BIT OPTION
#define     PS0       OPTION_REG, BIT0
#define     PS1       OPTION_REG, BIT1
#define     PS2       OPTION_REG, BIT2
#define     PSA       OPTION_REG, BIT3
#define     T0SE      OPTION_REG, BIT4
#define     T0CS      OPTION_REG, BIT5
#define     INTEDG    OPTION_REG, BIT6
#define     RBPU      OPTION_REG, BIT7

;----- EECON1 Bits --------------------------------------------------------

; BIT EECON1
#define     RD        EECON1, BIT0
#define     WR        EECON1, BIT1
#define     WREN      EECON1, BIT2
#define     WRERR     EECON1, BIT3
#define     EEIF      EECON1, BIT4

;----- STATUS Bits --------------------------------------------------------

; BIT STATUS
#define     C         STATUS, BIT0
#define     DC        STATUS, BIT1
#define     Z         STATUS, BIT2
#define     PD        STATUS, BIT3
#define     TO        STATUS, BIT4
#define     PA0       STATUS, BIT5
#define     PA1       STATUS, BIT6
#define     PA2       STATUS, BIT7
#define     RP0       STATUS, BIT5
#define     RP1       STATUS, BIT6
#define     IRP       STATUS, BIT7

;----- PORTA Bits --------------------------------------------------------

; BIT PORTA
#define     RA0       PORTA, BIT0  ;facilite au lieu de: bsf PORTA,BIT0
#define     RA1       PORTA, BIT1  ;     il faut crire: bsf RA0
#define     RA2       PORTA, BIT2
#define     RA3       PORTA, BIT3
#define     RA4       PORTA, BIT4
#define     T0CKI     PORTA, BIT4
#define     RA5       PORTA, BIT5
#define     RA6       PORTA, BIT6
#define     RA7       PORTA, BIT7

;----- PORTB Bits --------------------------------------------------------

; BIT PORTB
#define     RB0       PORTB, BIT0
#define     INT       PORTB, BIT0
#define     RB1       PORTB, BIT1
#define     RB2       PORTB, BIT2
#define     RB3       PORTB, BIT3
#define     RB4       PORTB, BIT4
#define     RB5       PORTB, BIT5
#define     RB6       PORTB, BIT6
#define     RB7       PORTB, BIT7

;----- TRISA Bits --------------------------------------------------------

; BIT TRISA
#define     TRISA0    TRISA, BIT0
#define     TRISA1    TRISA, BIT1
#define     TRISA2    TRISA, BIT2
#define     TRISA3    TRISA, BIT3
#define     TRISA4    TRISA, BIT4

;----- TRISB Bits --------------------------------------------------------

; BIT TRISB
#define     TRISB0    TRISB, BIT0
#define     TRISB1    TRISB, BIT1
#define     TRISB2    TRISB, BIT2
#define     TRISB3    TRISB, BIT3
#define     TRISB4    TRISB, BIT4
#define     TRISB5    TRISB, BIT5
#define     TRISB6    TRISB, BIT6
#define     TRISB7    TRISB, BIT7

;==========================================================================
;
;       RAM Definition
;
;==========================================================================

        __MAXRAM H'AF'
        __BADRAM H'07', H'30'-H'7F', H'87'

;==========================================================================
;
;       Configuration Bits
;
;==========================================================================

_CP_ON                       EQU     H'3FEF'
_CP_OFF                      EQU     H'3FFF'
_PWRTE_ON                    EQU     H'3FFF'
_PWRTE_OFF                   EQU     H'3FF7'
_WDT_ON                      EQU     H'3FFF'
_WDT_OFF                     EQU     H'3FFB'
_LP_OSC                      EQU     H'3FFC'
_XT_OSC                      EQU     H'3FFD'
_HS_OSC                      EQU     H'3FFE'
_RC_OSC                      EQU     H'3FFF'

        LIST

