#include <stdlib.h>
#include <delays.h>
#include "system\typedefs.h"
#include "1wire.h"
#include "ds1820.h"

byte read_rom(byte *sn) {
	byte i;
	if (Detect_Slave_Device()) {
		//Delay10TCYx(120); // 240 us
		OW_write_byte(READ_ROM);
		//Delay10TCYx(120); // 240 us
		for(i = 0; i < 8; i++) {
   			sn[i] = OW_read_byte();
		}
		return 1;
	}
	return 0;
}

byte startConvertT(byte *sn) {
	byte i;
	if (Detect_Slave_Device()) {
		if (ONLY_ONE) {
			OW_write_byte(SKIP_ROM);
		} else {
			OW_write_byte(MATCH_ROM);
			for (i = 0; i < 8; i++)
				OW_write_byte(sn[i]);
		}
		OW_write_byte(CONVERT_T);
		//if (PARASITE) drive_OW_high();
		return 1;
	}
	return 0;
}

byte readMem(byte *sn, byte *data) {
	byte i;
	if (Detect_Slave_Device()) {
		if (ONLY_ONE) {
			OW_write_byte(SKIP_ROM);
		} else {
			OW_write_byte(MATCH_ROM);
			for (i = 0; i < 8; i++)
				OW_write_byte(sn[i]);
		}
		for (i = 0; i < 8; i++)
			data[i] = OW_read_byte();
		return 1;
	}
	return 0;
}

double getTemperature(byte *sn) {
	byte i;
	byte temp[2];
	double x = 85;
	if (Detect_Slave_Device()) {
		if (ONLY_ONE) {
			OW_write_byte(SKIP_ROM);
		} else {
			OW_write_byte(MATCH_ROM);
			for (i = 0; i < 8; i++)
				OW_write_byte(sn[i]);
		}
		temp[0] = OW_read_byte(); // LSB
		temp[1] = OW_read_byte(); // MSB
		OW_reset_pulse();
		x = (double) (atoi(temp) / 2);
	}
	return x;
}

double getHighPrecTemperature(byte *sn) {
	double x = 85;
	if (Detect_Slave_Device()) {
	}
	return x;
}
