#ifndef IO_CFG_H
#define IO_CFG_H

/** I N C L U D E S *************************************************/
#include "autofiles\usbcfg.h"

/** T R I S *********************************************************/
#define INPUT_PIN           1
#define OUTPUT_PIN          0


/** U S B ***********************************************************/
#define tris_usb_bus_sense  TRISBbits.TRISA1    // Input

#if defined(USE_USB_BUS_SENSE_IO)
#define usb_bus_sense       PORTBbits.RA1
#else
#define usb_bus_sense       1
#endif

#define tris_self_power     TRISAbits.TRISA2    // Input
#if defined(USE_SELF_POWER_SENSE_IO)
#define self_power          PORTAbits.RA2
#else
#define self_power          1
#endif

/** L E D ***********************************************************/
#define mInitAllLEDs()      LATEbits.LATE0=0; TRISEbits.TRISE0=0; LATDbits.LATD3=0; TRISDbits.TRISD3=0;

#define mLED_1              LATEbits.LATE0
#define mLED_2              LATDbits.LATD3

#define mLED_1_On()         mLED_1 = 1;
#define mLED_2_On()         mLED_2 = 1;

#define mLED_1_Off()        mLED_1 = 0;
#define mLED_2_Off()        mLED_2 = 0;

#define mLED_1_Toggle()     mLED_1 = !mLED_1;
#define mLED_2_Toggle()     mLED_2 = !mLED_2;

/** S W I T C H *****************************************************/
#define mInitAllSwitches()  TRISEbits.TRISE1=1;TRISBbits.TRISB5=1;
#define mInitSwitch1()      PORTEbits.RE1=1;
#define mInitSwitch2()      TRISBbits.TRISB5=1;
#define sw1                 PORTEbits.RE1
#define sw2                 PORTBbits.RB5
/********************************************************************/

#endif //IO_CFG_H
