/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <string.h>
#include <stdlib.h>
#include "system\typedefs.h"                        // Required
#include "system\usb\usb.h"                         // Required
#include "io_cfg.h"                                 // Required
#include "1wire.h"
#include "ds1820.h"
#include "system\usb\usb_compile_time_validation.h" // Optional

/** C O N F I G U R A T I O N ************************************************/
// Note: For a complete list of the available config pragmas and their values, 
// see the compiler documentation, and/or click "Help --> Topics..." and then 
// select "PIC18 Config Settings" in the Language Tools section.

        #pragma config PLLDIV   = 5         // (20 MHz crystal on PICDEM FS USB board)
        #pragma config CPUDIV   = OSC1_PLL2	
        #pragma config USBDIV   = 2         // Clock source from 96MHz PLL/2
        #pragma config FOSC     = HSPLL_HS
        #pragma config FCMEN    = OFF
        #pragma config IESO     = OFF
        #pragma config PWRT     = OFF
        #pragma config BOR      = ON
        #pragma config BORV     = 3
        #pragma config VREGEN   = ON		//USB Voltage Regulator
        #pragma config WDT      = OFF
        #pragma config WDTPS    = 32768
        #pragma config MCLRE    = ON
        #pragma config LPT1OSC  = OFF
        #pragma config PBADEN   = OFF
//      #pragma config CCP2MX   = ON
        #pragma config STVREN   = ON
        #pragma config LVP      = OFF
//      #pragma config ICPRT    = OFF       // Dedicated In-Circuit Debug/Programming
        #pragma config XINST    = OFF       // Extended Instruction Set
        #pragma config CP0      = OFF
        #pragma config CP1      = OFF
//      #pragma config CP2      = OFF
//      #pragma config CP3      = OFF
        #pragma config CPB      = OFF
//      #pragma config CPD      = OFF
        #pragma config WRT0     = OFF
        #pragma config WRT1     = OFF
//      #pragma config WRT2     = OFF
//      #pragma config WRT3     = OFF
        #pragma config WRTB     = ON       // Boot Block Write Protection
        #pragma config WRTC     = OFF
//      #pragma config WRTD     = OFF
        #pragma config EBTR0    = OFF
        #pragma config EBTR1    = OFF
//      #pragma config EBTR2    = OFF
//      #pragma config EBTR3    = OFF
        #pragma config EBTRB    = OFF

/** V A R I A B L E S ********************************************************/
#pragma udata
byte old_sw1, old_sw2;

#define USB_BUFF_SIZE 64
#define DEBUG_MODE 1

byte in_buf[USB_BUFF_SIZE];
byte out_buf[USB_BUFF_SIZE];

/** P R I V A T E  P R O T O T Y P E S ***************************************/
static void InitializeSystem(void);
void BlinkUSBStatus(void);
BOOL Switch1IsPressed(void);
BOOL Switch2IsPressed(void);
void USBTasks(void);
void Debug_msg(char *msg);

/** V E C T O R  R E M A P P I N G *******************************************/
extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code REMAPPED_RESET_VECTOR = 0x800
void _reset (void)
{
    _asm goto _startup _endasm
}
#pragma code REMAPPED_HIGH_INTERRUPT_VECTOR = 0x808
void Remapped_High_ISR (void)
{
     ;
}
#pragma code REMAPPED_LOW_INTERRUPT_VECTOR = 0x818
void Remapped_Low_ISR (void)
{
     ;
}


#pragma code

/** D E C L A R A T I O N S **************************************************/
#pragma code

void main(void)
{
	byte sn[8];
	sn[0] = '';
    InitializeSystem();
	INTCON2bits.RBPU = 0;
	while (1) {
      USBTasks();         // USB Tasks
	  BlinkUSBStatus();
	  if (!((usb_device_state < CONFIGURED_STATE)||(UCONbits.SUSPND==1))) {
   			if (getsUSBUSART(in_buf, 64)) {
				if (in_buf[0] == 'a') {
					mLED_2_Toggle();
				} else if (in_buf[0] == 'h') {
					Debug_msg("ROM code lekrdezse ... ");
					if (read_rom(&sn)) {
						Debug_msg("ksz\r\n");
						memcpy(out_buf, sn, 8);
					   	if (mUSBUSARTIsTxTrfReady()) {
							mUSBUSARTTxRam(out_buf, 8);
					 	}
						Debug_msg("\r\n");
					} else {
						Debug_msg("sikertelen\r\n");
					}
				}
			}
	  }
	  if (Switch1IsPressed()) {
			if (mUSBUSARTIsTxTrfReady()) {
				//output_buffer[0] = 'c';
				//mUSBUSARTTxRam(output_buffer, 1);
				putrsUSBUSART("Hello World!\r\n");
			}
	  }

    }//end while
}//end main

static void InitializeSystem(void)
{
	//On the PIC18F87J50 Family of USB microcontrollers, the PLL will not power up and be enabled
	//by default, even if a PLL enabled oscillator configuration is selected (such as HS+PLL).
	//This allows the device to power up at a lower initial operating frequency, which can be
	//advantageous when powered from a source which is not gauranteed to be adequate for 48MHz
	//operation.  On these devices, user firmware needs to manually set the OSCTUNE<PLLEN> bit to
	//power up the PLL.

	ADCON1 |= 0x0F;                 // Default all pins to digital

//	The USB specifications require that USB peripheral devices must never source
//	current onto the Vbus pin.  Additionally, USB peripherals should not source
//	current on D+ or D- when the host/hub is not actively powering the Vbus line.
//	When designing a self powered (as opposed to bus powered) USB peripheral
//	device, the firmware should make sure not to turn on the USB module and D+
//	or D- pull up resistor unless Vbus is actively powered.  Therefore, the
//	firmware needs some means to detect when Vbus is being powered by the host.
//	A 5V tolerant I/O pin can be connected to Vbus (through a resistor), and
// 	can be used to detect when Vbus is high (host actively powering), or low
//	(host is shut down or otherwise not supplying power).  The USB firmware
// 	can then periodically poll this I/O pin to know when it is okay to turn on
//	the USB module/D+/D- pull up resistor.  When designing a purely bus powered
//	peripheral device, it is not possible to source current on D+ or D- when the
//	host is not actively providing power on Vbus. Therefore, implementing this
//	bus sense feature is optional.  This firmware can be made to use this bus
//	sense feature by making sure "USE_USB_BUS_SENSE_IO" has been defined in the
//	usbcfg.h file.
    #if defined(USE_USB_BUS_SENSE_IO)
    tris_usb_bus_sense = INPUT_PIN; // See io_cfg.h
    #endif

//	If the host PC sends a GetStatus (device) request, the firmware must respond
//	and let the host know if the USB peripheral device is currently bus powered
//	or self powered.  See chapter 9 in the official USB specifications for details
//	regarding this request.  If the peripheral device is capable of being both
//	self and bus powered, it should not return a hard coded value for this request.
//	Instead, firmware should check if it is currently self or bus powered, and
//	respond accordingly.  If the hardware has been configured like demonstrated
//	on the PICDEM FS USB Demo Board, an I/O pin can be polled to determine the
//	currently selected power source.  On the PICDEM FS USB Demo Board, "RA2" 
//	is used for	this purpose.  If using this feature, make sure "USE_SELF_POWER_SENSE_IO"
//	has been defined in usbcfg.h, and that an appropriate I/O pin has been mapped
//	to it in io_cfg.h.
    #if defined(USE_SELF_POWER_SENSE_IO)
    tris_self_power = INPUT_PIN;
    #endif
    
    mInitializeUSBDriver();         // See usbdrv.h
    mInitAllLEDs();
    mInitAllSwitches();
    old_sw1 = sw1;
    old_sw2 = sw2;

}//end InitializeSystem

void USBTasks(void)
{
    /*
     * Servicing Hardware
     */
    USBCheckBusStatus();                    // Must use polling method
    if(UCFGbits.UTEYE!=1)
        USBDriverService();                 // Interrupt or polling method
    
    #if defined(USB_USE_CDC)
    CDCTxService();
    #endif

}// end USBTasks

void BlinkUSBStatus(void) {
    static word led_count=0;
    
    if (led_count == 0) led_count = 40000U;
    led_count--;

    if (UCONbits.SUSPND == 1) {
        mLED_1_Off();
    } else {
        if (usb_device_state == DETACHED_STATE) {
			//led_count--;
            //mLED_1_Toggle();
			mLED_1_Off();
        } else if (usb_device_state == ADDRESS_STATE) {
            mLED_1_On();
        } else if (usb_device_state == CONFIGURED_STATE) {
            if (led_count==0) {
                mLED_1_Toggle();
            }//end if
        }//end if(...)
    }//end if(UCONbits.SUSPND...)
}//end BlinkUSBStatus

BOOL Switch1IsPressed(void)
{
    if(sw1 != old_sw1)
    {
        old_sw1 = sw1;                  // Save new value
        if(sw1 == 0)                    // If pressed
            return TRUE;                // Was pressed
    }//end if
    return FALSE;                       // Was not pressed
}//end Switch1IsPressed

BOOL Switch2IsPressed(void)
{
    if(sw2 != old_sw2)
    {
        old_sw2 = sw2;                  // Save new value
        if(sw2 == 0)                    // If pressed
            return TRUE;                // Was pressed
    }//end if
    return FALSE;                       // Was not pressed
}//end Switch2IsPressed

void Debug_msg(char *msg)
{
     if ((mUSBUSARTIsTxTrfReady()) && (DEBUG_MODE == 1))
     {
       putrsUSBUSART(msg); // string kldse
     }

}
/** EOF main.c ***************************************************************/
