;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    24LC16B.ASM                                       *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    24LC16B I2C SOROS EEPROM BYTE/PAGE R/OLVAS PROGRAM            *
;    -----------------------------------------------------            *
;    Az EEPROM a mikrovezrl szinkron soros portjra csatlakozik,    *
;    melynek kivezetseit szoftveres rutinok kezelik.                 *
;    A program az EEPROM Start_Address cmtl kezdd 10 bjtos      *
;    terlett a mikrovezrl adatmemrija Datao cmtl kezdd      *
;    terletnek adataival rja fell.                                *
;    A visszaolvasott adatok a Datai kezdcm bufferbe kerlnek.     *
;                                                                     *
;**********************************************************************
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;
;----------------------------------------------------------------------
Start_Address	equ	0x302     	; EEPROM clterletnek kezd cme
Slave           equ     B'10100000'     ; EEPROM I2C cme (B'1010xxxx')
;----------------------------------------------------------------------
Flag            equ     32              ; program sttusz regiszter
Err1            equ     0               ; bit0: hiba flag
;----------------------------------------------------------------------
Addr_Lo         equ     33              ; EEPROM cm als bjt trolja
Addr_Hi         equ     34              ; EEPROM cm 3 fels bit trolja
Txbuf           equ     35              ; Tx buffer, tmeneti trol
Rxbuf           equ     36              ; Rx buffer, tmeneti trol
Counter         equ     37              ; bit szmll
Timer0          equ     38              ; ksleltets szmll als bjt
Timer1          equ     39              ; ksleltets szmll fels bjt
Byte_num	equ	40		; lap rs/olvass bjt szmll
;
Datai           equ     48              ; EEPROM-bl olvasott adatok kezdcme
;
Datao           equ     64              ; beprogramozand adatok kezdcme
;----------------------------------------------------------------------
; PORTC kivezetsek
;
SCL             equ     3               ; RC3, I2C soros rajel
SDA             equ     4               ; RC4, I2C be/kimeneti adat
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt
;----------------------------------------------------------------------
; PORTA, PORTC konfigurlsa
;
Start		bsf	STATUS,RP0	
		bcf	STATUS,RP1	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111111'    	; PORTA bemenet
		movwf	TRISA
		movlw	B'11111111'	; PORTC bemenet
		movwf	TRISC
		bcf	STATUS,RP0	; bank0 kivlaszts
;----------------------------------------------------------------------
; Datao kezdcm adatmemria terlet feltltse
;
                movlw   00h             
                movwf   Datao		
                movlw   11h 
                movwf   Datao+1
                movlw   22h
                movwf   Datao+2
                movlw   33h
                movwf   Datao+3
                movlw   44h
                movwf   Datao+4
                movlw   55h 
                movwf   Datao+5
                movlw   66h 
                movwf   Datao+6
                movlw   77h  
                movwf   Datao+7
                movlw   88h 
                movwf   Datao+8
                movlw   99h 
                movwf   Datao+9
;----------------------------------------------------------------------
; Az EEPROM adott terletnek feltltse s visszaolvassa
;
		movlw	low Start_Address
                movwf   Addr_Lo         ; EEPROM cm als bjt msolsa
                movlw   high Start_Address
                movwf   Addr_Hi         ; EEPROM cm fels bitek msolsa
                call    Wrpage          ; laprs (max. 16 bjt)
;----------------------------------------------------------------------
                call    Delay           ; vr a bels mkds befejezdsre
;----------------------------------------------------------------------
		movlw	low Start_Address
                movwf   Addr_Lo         ; EEPROM cm als bjt msolsa
                movlw   high Start_Address
                movwf   Addr_Hi         ; EEPROM cm fels bitek msolsa
		call    Rdpage          ; szekvencilis olvass
;----------------------------------------------------------------------
Loop            goto    Loop            ; vrakozs resetre
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;***************************** SZUBRUTINOK ****************************
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
; Bjt rs, egy bjtot r az EEPROM adott cm rekeszbe
;
Wrbyte          call    Bstart          ; START bit generls
                movlw   Slave           ; Slave cm msolsa a TXbuf
                movwf   Txbuf           ; regiszterbe
                bcf	STATUS,C	; R/W bitet 0-ba lltja
                rlf	Addr_Hi,0	; Addr_Hi -> w
                addwf	Txbuf,1		; Txbuf a cmbiteket is tartalmazza 
                call    Tx              ; slave cm kikldse (ACK detektls)
                movf    Addr_Lo,0       ; EEPROM cm als bjt msolsa
                movwf   Txbuf           ; a Txbuf regiszterbe
                call    Tx              ; cm kikldse (ACK detektls)
                movf    Datao,0         ; programozand adat msolsa
                movwf   Txbuf           ; a Txbuf regiszterbe
                call    Tx              ; adat kikldse (ACK detektls)
                call    Bstop           ; STOP bit generls
                return
;----------------------------------------------------------------------
; Bjt olvass, egy bjtot olvas az EEPROM adott cm rekeszbl
;
Rdbyte          call    Bstart          ; START bit generls
                movlw   Slave           ; Slave cm msolsa a TXbuf
                movwf   Txbuf           ; regiszterbe 
                bcf	STATUS,C	; R/W bitet 0-ba lltja
                rlf	Addr_Hi,0	; Addr_Hi -> w
                addwf	Txbuf,1		; Txbuf a cmbiteket is tartalmazza 
                call    Tx              ; slave cm kikldse (ACK detektls)
                movf    Addr_Lo,0       ; EEPROM cm als bjt msolsa
                movwf   Txbuf           ; a Txbuf regiszterbe
                call    Tx              ; cm kikldse (ACK detektls)
                call    Bstart          ; ismtelt START bit generls
                movlw   Slave           ; Slave cm msolsa a TXbuf
                movwf   Txbuf           ; regiszterbe
                bsf	STATUS,C        ; olvass md bellts (R/W = 1)
                rlf	Addr_Hi,0	; Addr_Hi -> w
                addwf	Txbuf,1		; Txbuf a cmbiteket is tartalmazza 
                call    Tx              ; slave cm kikldse (ACK detektls)
                call    Rx              ; adat beolvass
                call    Bstop           ; STOP bit generls
                movf    Rxbuf,0         ; a vett adat msolsa a Datai
                movwf   Datai           ; regiszterbe
                return
;----------------------------------------------------------------------
; Laprs, max 16 bjt rsa az EEPROM-ba
;
Wrpage          call    Bstart          ; START bit generls
                movlw   Slave           ; Slave cm msolsa a TXbuf
                movwf   Txbuf           ; regiszterbe
                bcf	STATUS,C	; R/W bitet 0-ba lltja
                rlf	Addr_Hi,0	; Addr_Hi -> w
                addwf	Txbuf,1		; Txbuf a cmbiteket is tartalmazza 
                call    Tx              ; slave cm kikldse (ACK detektls)
                movf    Addr_Lo,0       ; EEPROM cm als bjt msolsa
                movwf   Txbuf           ; a Txbuf regiszterbe
                call    Tx              ; cm kikldse (ACK detektls)
                movlw   10              ; kikldend bjtok szma
                movwf   Byte_num
                movlw   Datao		; adatmemria kezdcm -> FSR
                movwf   FSR
Wrpage1         movf    INDF,0		; adatmozgats indirekt cmzssel
                movwf   Txbuf           ; a bufferbe
                call    Tx              ; adat kiklds (ACK detektls)
                incf    FSR,1		; FSR=FSR+1, kvetkez adatra mutat
                decfsz  Byte_num,1	; az sszes bjtot kikldtk?
                goto    Wrpage1		; mg nem
;----------------------------------------------------------------------
                call    Bstop           ; STOP bit generls
                return
;----------------------------------------------------------------------
; Szekvencilis adat olvass az EEPROM-bl
; ACKNOWLEDGE jelet most a master adja!
;
Rdpage          call    Bstart          ; START bit generls
                movlw   Slave           ; Slave cm msolsa a TXbuf
                movwf   Txbuf           ; regiszterbe
                bcf	STATUS,C	; R/W bitet 0-ba lltja
                rlf	Addr_Hi,0	; Addr_Hi -> w
                addwf	Txbuf,1		; Txbuf a cmbiteket is tartalmazza 
                call    Tx              ; slave cm kikldse (ACK detektls)
                movf    Addr_Lo,0       ; EEPROM cm als bjt msolsa
                movwf   Txbuf           ; a Txbuf regiszterbe
                call    Tx              ; cm kikldse (ACK detektls)
                call    Bstart          ; ismtelt START bit generls
                movlw   Slave           ; Slave cm msolsa a TXbuf
                movwf   Txbuf           ; regiszterbe
                bsf	STATUS,C        ; olvass md bellts (R/W = 1)
                rlf	Addr_Hi,0	; Addr_Hi -> w
                addwf	Txbuf,1		; Txbuf a cmbiteket is tartalmazza 
                call    Tx              ; slave cm kikldse (ACK detektls)
                movlw   10              ; beolvasand btok szma
                movwf   Byte_num
                movlw   Datai		; adatmemria kezdcm -> FSR
                movwf   FSR
Rdpage1         call    Rx              ; adatbeolvass
                call    Ackn_rx         ; acknowledge bit ellenrzse 
                movf    Rxbuf,0 
                movwf   INDF        	; beolvasott adat RAM-ba msolsa
                incf    FSR,1		; FSR=FSR+1, kvetkez RAM cmre mutat
                decfsz  Byte_num,1	; az sszes bjtot beolvastuk?
                goto    Rdpage1		; mg nem
;----------------------------------------------------------------------
                call    Bstop           ; STOP bit generls
                return
;----------------------------------------------------------------------
; START bit generls (SCL magas szintje mellett SDA magasbl alacsonyba megy)
;
Bstart          movlw	24		; SCL, SDA magas szintek
		movwf	PORTC
                bsf     STATUS,RP0	; bank1 kivlaszts
                movlw   B'11100111'     ; SCL, SDA vonalak kimenetek
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts
                bcf     PORTC,SDA       ; SDA magasbl alacsonyba megy
                nop                     ; idzts
                nop
                nop
                bcf     PORTC,SCL       ; rajel is alacsony szint lesz
                return
;----------------------------------------------------------------------
; STOP bit generls (SDA alacsonybl magasba megy SCL magas szintje mellett)
;
Bstop           bcf     PORTC,SDA       ; SDA alacsony szint
                bsf     STATUS,RP0	; bank1 kivlaszts
                movlw   B'11100111'     ; SCL, SDA vonalak kimenetek
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts
                nop
                bsf     PORTC,SCL       ; SCL magas szint
                nop
                nop
                nop
                bsf     PORTC,SDA       ; SDA alacsonybl magasba megy
                bsf     STATUS,RP0	; bank1 kivlaszts
                movlw   B'11111111'     ; SCL, SDA vonalak kimenetek
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts
                return
;----------------------------------------------------------------------
Delay           movlw   66		; kb 10ms ksleltets Fosc=20MHz
                movwf   Timer1		; esetn
Delay1          decfsz  Timer0,1
                goto    Delay1
                decfsz  Timer1,1
                goto    Delay1
                return
;----------------------------------------------------------------------
; Adatbjt ads szubrutin
; 8 bitet lptet ki az SDA vonalon, mg az rajelet az SCL vonalon adja.
;
Tx              bsf     STATUS,RP0	; bank1 kivlaszts
                movlw   B'11100111'     ; SCL, SDA vonalak kimenetek
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts
                movlw   8		; bitek szma 8
                movwf   Counter
Txloop          btfsc   Txbuf,7         ; Txbuf bit7 msolsa SDA vonalra
                bsf     PORTC,SDA
                btfss   Txbuf,7
                bcf     PORTC,SDA
		nop
                bsf     PORTC,SCL       ; SCL=1, rajel magas szint
                rlf     Txbuf,1         ; Txbuf lptetse (Carry-n keresztl)
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                bcf     PORTC,SCL       ; SCL=0, rajel alacsony szint
                decfsz  Counter,1       ; 8 bit tvitele megtrtnt?
                goto    Txloop          ; mg nem
;----------------------------------------------------------------------
                bcf     PORTC,SDA	; SDA vonal alacsonyba lltsa
Ackn_test       bsf     STATUS,RP0	; bank1 kivlaszts
                movlw   B'11110111'     ; SDA vonal bemenet, SCL kimenet
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts
                bsf     PORTC,SCL       ; SCL=1, rajel magas szint
                btfsc   PORTC,SDA       ; acknowledge bit ellenrzse
                bsf     Flag,Err1	; hiba esetn Err1 bitet 1-be lltja
                nop
                nop
                nop
                bcf     PORTC,SCL       ; SCL=0, rajel alacsony szint
                return
;----------------------------------------------------------------------
; Adatbjt vteli szubrutin
;
Rx              bsf     STATUS,RP0	; bank1 kivlaszts
                movlw   B'11110111'     ; SDA vonal bemenet, SCL kimenet
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts
                movlw   8
                movwf   Counter         ; bitek szma 8
Rxloop          bsf     PORTC,SCL	; SCL=1, rajel magas szint
                nop
                btfsc   PORTC,SDA	; SDA msolsa Carry bitbe
                bsf     STATUS,C
                btfss   PORTC,SDA
                bcf     STATUS,C
                rlf     Rxbuf,1         ; carry belptetse RXbuf regiszterbe
                nop
                bcf     PORTC,SCL	; SCL=0, rajel alacsony szint
                decfsz  Counter,1       ; sszes bit vtele megtrtnt
                goto    Rxloop		; mg nem
                return
;----------------------------------------------------------------------
; Adatbjt vtel utn a master adja az ACKNOWLWDGE bitet
;
Ackn_rx         bsf     STATUS,RP0	; bank1 kivlaszts 
                movlw   B'11100111'     ; SDA, SCL vonalak kimenetek
                movwf   TRISC
                bcf     STATUS,RP0	; bank0 kivlaszts 
                bcf     PORTC,SDA       ; SDA=0, adatbit trlse
                nop
                nop
                bsf     PORTC,SCL       ; SCL=1, rajel magas szint
                nop
                nop
                nop
                nop
                nop
                bcf     PORTC,SCL       ; SCL=0, rajel alacsony szint
                return
;----------------------------------------------------------------------
                end

