;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    LCD_ORA.ASM                                       *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V2.3                                              *
;    #8                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    LCD KIJELZS RA VEZRL PROGRAM                                *
;    ---------------------------------                                *
;    Naptros ra: kezeli a hnapokat, napokat.                       *
;    Az rt vezrl egyes gombok szerepe:                            *
;    1. Bekapcsols utn					      *
;       K3 - rabellts kezdemnyzs.                               *
;    2. Az rabellts zemmdban                      	      *
;	K0 - berskor kurzor lptets, rs vgn 'ENTER'            *	
;	K1 - inkrementl gomb					      *
;	K3 - berst kezdemnyez 'SET', bers kzben 'CANCEL'       *
;                                                                     *
;**********************************************************************
;
;
;-------------------------------------------------------------------------------
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_ON & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;-------------------------------------------------------------------------------
; PORTE kivezetsek
;
RS              equ     0               ; 0= utasts, 1= adat reg. vlaszts
RdWr		equ	1		; R/W=0 LCD rs, R/W=1 LCD memria olvass
E               equ     2               ; 0= LCD tilts, 1= engedlyezs
;-------------------------------------------------------------------------------
Mp              equ     32      	; msodperc regiszter (BCD)
Perc            equ     33      	; perc regiszter (BCD)
Ora             equ     34      	; ra regiszter (BCD)
Nap             equ     35      	; nap regiszter (BCD)
Honap           equ     36      	; hnap regiszter (BCD)
Ora_Temp        equ     37      	; tmeneti tr berskor (ra)
Perc_Temp       equ     38      	; tmeneti tr berskor (perc)
Nap_Temp        equ     39      	; tmeneti tr berskor (nap)
Honap_Temp      equ     40      	; tmeneti tr berskor (hnap)
W_Temp          equ     41      	; a W regiszter tmeneti trolsra
Status_Temp	equ	42      	; STATUS regiszter tmeneti trolsra
;-------------------------------------------------------------------------------
Prg_Szint       equ     45      	; program szint, 
;  					  minst vltoz a program elgazsokhoz
;  PROGRAMSZINT   FUNKCI
;-----------------------------------------------------------------------
;       0     bejelentkezs bekapcsols utn (tpfeszltsg kimarads)
;  	1     vrakozsi llapot a SET gomb megnyomsa utn:  -	ra mdosts
;	2	 					      -	perc mdosts
;	3	 					      -	hnap mdosts
;	4	 					      -	nap mdosts
;
;-------------------------------------------------------------------------------
Timer1		equ	46
Timer2		equ	47
Temp		equ	48
;-------------------------------------------------------------------------------
Prg_Status	equ	49
;
T4		equ	0		; =1, ha a 14. TMR1 megszakts volt
KEY		equ	1		; =1, ha 1 megnyomott billenty van
;-------------------------------------------------------------------------------
Button          equ     50      	; utoljra lenyomott billenty kdja 
Button_Temp     equ     51      	; elzleg lenyomott billenty kdja
Mod4		equ	52		; modulo4 IT szmll
Counter		equ	53      	; a lenyomott billentyket szmllja
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
		org     0             	; reset vektor
		nop             	; az MPLAB-ICD miatt kell
		goto	Start
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;******************************** IT rutin *************************************
;-------------------------------------------------------------------------------
; Megszakts 1/4 s gy billenty beolvass msodpercenknt, ra inkrementls
; 1 msodpercenknt.
;
		org     4             	; IT vektor
Pushw		bcf	STATUS,RP0      ; bank0 kivlaszts
		bcf	STATUS,RP1
		bcf	PIR1,TMR1IF	; Timer1 IT flag trls
		movwf	W_Temp		; W ments
		swapf	STATUS,0
		movwf	Status_Temp     ; Status regiszter ments
		movlw	H'E0' 
		movwf	TMR1H 
		clrf	TMR1L		; Timer1=E000h
                decfsz  Mod4,1   	; MOD4 szmll cskkents
                goto    Popw    	; mg nem 0, kilps a rutinbl
;-------------------------------------------------------------------------------
		movlw   4	      	; MOD4 szmll visszallts
                movwf   Mod4   	
		bsf	Prg_Status,T4	; T4=1 bellts
;-------------------------------------------------------------------------------
; ra inkrementls
;
Clk_Inkrement	decfsz  Mp,1    	; msodperc regiszter dekrementlsa
                goto    Popw    	; mg nem 0, kilps a rutinbl
;-------------------------------------------------------------------------------
                movlw	60	     	; perc regiszter korrekci szksges
		movwf	Mp
                decfsz  Perc,1    	; a perc regiszter dekrementlsa  
                goto    Popw    	; mg nem 0, kilps a rutinbl
;-------------------------------------------------------------------------------
                movlw	60	     	; ra regiszter korrekci szksges
		movwf	Perc
                decfsz  Ora,1     	; az ra regiszter dekrementlsa
                goto    Popw    	; mg nem 0, kilps a rutinbl
;-------------------------------------------------------------------------------
                movlw	24	     	; nap regiszter korrekci szksges
		movwf	Ora
                decfsz  Nap,1   	; a nap regiszter dekrementlsa                  
                goto    Popw    	; mg nem 0, kilps a rutinbl
;-------------------------------------------------------------------------------
                decf	Honap,0
                call    Honap_vege      ; hnap regiszter korrekci szksges
		movwf	Nap      	; W=hnap utols napja
		decfsz  Honap,1         ; hnap regiszter dekrementlsa
                goto    Popw    	; mg nem 0, kilps a rutinbl
;-------------------------------------------------------------------------------
                movlw	12	     	; nap regiszter korrekci szksges
		movwf	Honap
;-------------------------------------------------------------------------------
Popw            call	Scan		; billenty olvass
		swapf	Status_Temp,0	
		movwf	STATUS		; Status regiszter visszallts 
		swapf	W_Temp,1
		swapf	W_Temp,0	; W visszallts
                retfie          	; visszatrs az IT-rutinbl
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;****************************** Szubrutinok ************************************
;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
; a visszakapott rtk a kijelz adat tizese
;
Tabla1		addwf   PCL,1		;
		retlw	35h		; w=0,   59
		retlw	35h		; w=1,   58
		retlw	35h		; w=2,   57
		retlw	35h		; w=3,   56
		retlw	35h		; w=4,   55
		retlw	35h		; w=5,   54
		retlw	35h		; w=6,   53
		retlw	35h		; w=7,   52
		retlw	35h		; w=8,   51
		retlw	35h		; w=9,   50
		retlw	34h		; w=10,  49
		retlw	34h		; w=11,  48
		retlw	34h		; w=12,  47
		retlw	34h		; w=13,  46
		retlw	34h		; w=14,  45
		retlw	34h		; w=15,  44
		retlw	34h		; w=16,  43
		retlw	34h		; w=17,  42
		retlw	34h		; w=18,  41
		retlw	34h		; w=19,  40
		retlw	33h		; w=20,  39
		retlw	33h		; w=21,  38
		retlw	33h		; w=22,  37
		retlw	33h		; w=23,  36
		retlw	33h		; w=24,  35
		retlw	33h		; w=25,  34
		retlw	33h		; w=26,  33
		retlw	33h		; w=27,  32
		retlw	33h		; w=28,  31
		retlw	33h		; w=29,  30
		retlw	32h		; w=30,  29
		retlw	32h		; w=31,  28
		retlw	32h		; w=32,  27
		retlw	32h		; w=33,  26
		retlw	32h		; w=34,  25
		retlw	32h		; w=35,  24
		retlw	32h		; w=36,  23
		retlw	32h		; w=37,  22
		retlw	32h		; w=38,  21
		retlw	32h		; w=39,  20
		retlw	31h		; w=40,  19
		retlw	31h		; w=41,  18
		retlw	31h		; w=42,  17
		retlw	31h		; w=43,  16
		retlw	31h		; w=44,  15
		retlw	31h		; w=45,  14
		retlw	31h		; w=46,  13
		retlw	31h		; w=47,  12
		retlw	31h		; w=48,  11
		retlw	31h		; w=49,  10
		retlw	30h		; w=50,  09
		retlw	30h		; w=51,  08
		retlw	30h		; w=52,  07
		retlw	30h		; w=53,  06
		retlw	30h		; w=54,  05
		retlw	30h		; w=55,  04
		retlw	30h		; w=56,  03
		retlw	30h		; w=57,  02
		retlw	30h		; w=58,  01  
		retlw	30h		; w=59,  00
;-------------------------------------------------------------------------------
; a visszakapott rtk a kijelz adat egyese
;
Tabla0		addwf   PCL,1		;
		retlw	39h		; w=0,   59
		retlw	38h		; w=1,   58
		retlw	37h		; w=2,   57
		retlw	36h		; w=3,   56
		retlw	35h		; w=4,   55
		retlw	34h		; w=5,   54
		retlw	33h		; w=6,   53
		retlw	32h		; w=7,   52
		retlw	31h		; w=8,   51
		retlw	30h		; w=9,   50
		retlw	39h		; w=10,  49
		retlw	38h		; w=11,  48
		retlw	37h		; w=12,  47
		retlw	36h		; w=13,  46
		retlw	35h		; w=14,  45
		retlw	34h		; w=15,  44
		retlw	33h		; w=16,  43
		retlw	32h		; w=17,  42
		retlw	31h		; w=18,  41
		retlw	30h		; w=19,  40
		retlw	39h		; w=20,  39
		retlw	38h		; w=21,  38
		retlw	37h		; w=22,  37
		retlw	36h		; w=23,  36
		retlw	35h		; w=24,  35
		retlw	34h		; w=25,  34
		retlw	33h		; w=26,  33
		retlw	32h		; w=27,  32
		retlw	31h		; w=28,  31
		retlw	30h		; w=29,  30
		retlw	39h		; w=30,  29
		retlw	38h		; w=31,  28
		retlw	37h		; w=32,  27
		retlw	36h		; w=33,  26
		retlw	35h		; w=34,  25
		retlw	34h		; w=35,  24
		retlw	33h		; w=36,  23
		retlw	32h		; w=37,  22
		retlw	31h		; w=38,  21
		retlw	30h		; w=39,  20
		retlw	39h		; w=40,  19
		retlw	38h		; w=41,  18
		retlw	37h		; w=42,  17
		retlw	36h		; w=43,  16
		retlw	35h		; w=44,  15
		retlw	34h		; w=45,  14
		retlw	33h		; w=46,  13
		retlw	32h		; w=47,  12
		retlw	31h		; w=48,  11
		retlw	30h		; w=49,  10
		retlw	39h		; w=50,  09
		retlw	38h		; w=51,  08
		retlw	37h		; w=52,  07
		retlw	36h		; w=53,  06
		retlw	35h		; w=54,  05
		retlw	34h		; w=55,  04
		retlw	33h		; w=56,  03
		retlw	32h		; w=57,  02
		retlw	31h		; w=58,  01  
		retlw	30h		; w=59,  00
;-------------------------------------------------------------------------------
Honap_vege      addwf   PCL,1		;
                retlw   31              ;   janur      31 napos
                retlw   31              ;   december    31 napos
                retlw   30              ;   november    30 napos
                retlw   31              ;   oktber     31 napos
                retlw   30              ;   szeptember  30 napos
                retlw   31              ;   augusztus   31 napos
                retlw   31              ;   jlius      31 napos
                retlw   30              ;   jnius      30 napos
                retlw   31              ;   mjus       31 napos
                retlw   30              ;   prilis     30 napos
                retlw   31              ;   mrcius     31 napos
                retlw   28              ;   februr     28 napos
                retlw   31              ;   janur      31 napos
;-------------------------------------------------------------------------------
TablaShift      addwf   PCL,1		;
                retlw   27              ;   december    31 napos
                retlw   28              ;   november    30 napos
                retlw   27              ;   oktber     31 napos
                retlw   28              ;   szeptember  30 napos
                retlw   27              ;   augusztus   31 napos
                retlw   27              ;   jlius      31 napos
                retlw   28              ;   jnius      30 napos
                retlw   27              ;   mjus       31 napos
                retlw   28              ;   prilis     30 napos
                retlw   27              ;   mrcius     31 napos
                retlw   30              ;   februr     28 napos
                retlw   27              ;   janur      31 napos
;-------------------------------------------------------------------------------
Scan		bcf	Prg_Status,KEY
		clrF	Counter
		clrf	Button
		movlw	14
		movwf	PORTB		; fels nyomgomb sor kivlasztsa
                btfsc   PORTB,4		; K0 billenty le van nyomva?
		goto	Scan1		; nem
;-------------------------------------------------------------------------------
		bsf	Button,0	; igen	
                incf	Counter,1
Scan1           btfsc   PORTB,5		; K1 billenty le van nyomva?
		goto	Scan2		; nem
;-------------------------------------------------------------------------------
		bsf	Button,1	; igen	
                incf	Counter,1
Scan2           btfsc   PORTA,3		; K2 billenty le van nyomva?
		goto	Scan3		; nem
;-------------------------------------------------------------------------------
		bsf	Button,2	; igen	
                incf	Counter,1	
Scan3           btfsc   PORTA,5		; K3 billenty le van nyomva?
		goto	Scan4		; nem
;-------------------------------------------------------------------------------
		bsf	Button,3	; igen	
                incf	Counter,1	
Scan4		movf	Counter,0	; lenyomott billentyk szmnak ellenrzse
		xorlw	1
		btfsc	STATUS,Z
		bsf	Prg_Status,KEY	; ha Counter=1, rvnyes a Button kd
		return
;-------------------------------------------------------------------------------
LCD_Inic        bcf     PORTE,RS
		movlw   38h             ; 8 bit interface set
                call    Write
                call    Kesl
                movlw   38h
                call    Write
                movlw   06h             ; Entry mode set: increment
                call    Write
                movlw   0ch             ; Display on, cursor/blink off
                call    Write
                movlw   10h             ; Display/cursor shift: cursor
                call    Write
                movlw   01h             ; Display clear
                call    Write
                call    Kesl
		return
;-----------------------------------------------------------------------
LCD_Write	bcf     PORTE,RS	; cm
                movlw   129             ; LCD cm= 1 (+128)
                call    Write
                bsf     PORTE,RS	; adat
		movf	Ora,0
		addlw	35
		call	Tabla1
                call    Write
		movf	Ora,0
		addlw	35
		call	Tabla0
                call    Write
		movlw	':'
                call    Write
		decf	Perc,0
		call	Tabla1
                call    Write
		decf	Perc,0
		call	Tabla0
                call    Write
		movlw	':'
                call    Write
		decf	Mp,0
		call	Tabla1
                call    Write
		decf	Mp,0
		call	Tabla0
                call    Write
		movlw	' '
                call    Write
		movlw	' '
                call    Write
		movf	Honap,0
		addlw	46
		call	Tabla1
                call    Write
		movf	Honap,0
		addlw	46
		call	Tabla0
                call    Write
		movlw	'-'
                call    Write
		decf	Honap,0
		call	TablaShift
		movwf	Temp
		movf	Nap,0
		addwf	Temp,0
		call	Tabla1
                call    Write
		movf	Nap,0
		addwf	Temp,0
		call	Tabla0
                call    Write
		return
;-------------------------------------------------------------------------------
; LCD rs 
;
Write           movwf   PORTD
		bsf     PORTE,E
                call    Kesl100		; Busy flag olvasst "helyettesti"
                bcf     PORTE,E
                return
;-------------------------------------------------------------------------------
Kesl100         movlw   165		; 100us ksleltets
                movwf   Timer1
Kesl101		decfsz  Timer1,1
                goto    Kesl101
                return
;-------------------------------------------------------------------------------
Kesl2           clrf    Timer1		; 2ms ksleltets
                movlw	20
		movwf   Timer2
Kesl21          call	Kesl100
                decfsz  Timer2,1
                goto    Kesl21
                return
;-------------------------------------------------------------------------------
Kesl            clrf    Timer1
                clrf    Timer2
Kesl1		decfsz  Timer1,1
                goto    Kesl1
                decfsz  Timer2,1
                goto    Kesl1
                return
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;******************************* Fprogram *************************************
;-------------------------------------------------------------------------------
;
;===============================================================================
; Port bellts
;
	        clrf    PORTD
                clrf    PORTE
Start		bcf	STATUS,RP1	
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'00111111'	; PORTA bemenet
		movwf	TRISA
		movlw	B'11110000'	; RB4...7 bemenet
		movwf	TRISB
		clrf	TRISD		; PORTD kimenet
		clrf	TRISE		; PORTE kimenet
		bcf	OPTION_REG,NOT_RBPU
;------------------------------------------------------------------------------
; Timer1 konfigurlsa
;
		movlw	1		; TMR1IE=1
		movwf	PIE1		; Timer1 megszakts engedlyezs
		bcf	STATUS,RP0	; bank0 kivlaszts
		movlw	14		; Timer1 bellts: TMR1 oszc. eng.,
		movwf	T1CON		; eloszt=1, aszinkron md
		clrf	INTCON		; megszaktsok tiltsa
;------------------------------------------------------------------------------
		bcf	T1CON,TMR1ON	; Timer1 megllts
		bcf	PIR1,TMR1IF	; Timer1 IT flag trls
		movlw	H'E0'		; Timer1=C000h bellts, 
		movwf	TMR1H		; gy 1/4 msodperceknt kr megszaktst
		clrf	TMR1L		
		movlw	192		; GIE=1, PEIE=1
		movwf	INTCON		; Timer1 IT engedlyezs
		bsf	T1CON,TMR1ON	; Timer1 start
		call	LCD_Inic	
;-------------------------------------------------------------------------------
; ra bekapcsolsi llapot: 23:59:00 01-31  (12:00:00 01-01)
;
                movlw   60
                movwf   Mp		; msodperc=0 regiszter bellts
                movlw   60		
		movwf	Perc		; perc=0 regiszter bellts 
		movlw	12
		movwf	Ora 		; ra=12 regiszter bellts
		movlw	12
		movwf	Honap 		; hnap=janur regiszter bellts
		movlw	31
		movwf	Nap 		; nap=1 regiszter bellts
		clrf	Prg_Szint
		clrf	Prg_Status
		clrf	Button_Temp
		movlw   4	      	; MOD4 szmll bellts
                movwf   Mod4   	
		call	LCD_Write
;-------------------------------------------------------------------------------
Main_Loop	movf	Button,0	; a lenyomott billenty megegyezik a korbbival?
		xorwf	Button_Temp,0
		btfsc	STATUS,Z
		goto	Main_Loop1	; igen, programszint vizsglat kvetkezik
;-------------------------------------------------------------------------------
		movf	Button,0
		movwf	Button_Temp	; j billentykd eltrolsa
		btfsc	Prg_Status,KEY	; egy lenyomott billenty van?
		goto	Key_Test	; igen
;-------------------------------------------------------------------------------
Main_Loop1	movf	Prg_Szint,0	; nem, programszint=0 ?
		btfss	STATUS,Z
		goto	Main_Loop	; nem Szint0
;-------------------------------------------------------------------------------
Szint0		btfss	Prg_Status,T4	; 4. TMR1 megszakts volt (1mp letelt)?
		goto	Main_Loop	; mg nem
;-------------------------------------------------------------------------------
		bcf	Prg_Status,T4	; igen, jelzbit trls
		call	LCD_Write	; ra kijelzs 
		goto	Main_Loop
;-------------------------------------------------------------------------------
Key_Test	movf	Prg_Szint,0	; programszint vizsglat
		btfss	STATUS,Z
		goto	Nem_Nulla		
;-------------------------------------------------------------------------------
; Programszint=0
; ---------------
; K0 : 
; K1 : 
; K2 :
; K3 : rabellts kivlaszt gomja, SET   -> Programszint= 1
;
Prgszint0	btfss	Button,3	; K3 gomb van lenyomva?
		goto	Main_Loop	; nem
;-------------------------------------------------------------------------------
Clk_Set_Start	incf	Prg_Szint,1	; igen
		call	LCD_Write	; ra kijelzs
		bcf     PORTE,RS	; cm
                movlw   135             ; LCD cm=7 (+128)
                call    Write
		bsf     PORTE,RS	; adat
                movlw   '0'		; msodperc trls
                call    Write
                movlw   '0'
                call    Write
		movf	Honap,0
		movwf	Honap_Temp
		movf	Nap,0
		movwf	Nap_Temp
		movf	Ora,0
		movwf	Ora_Temp
		movf	Perc,0
		movwf	Perc_Temp
		bcf     PORTE,RS	; cm
                movlw   H'0E'           ; Display on, kurzor on
                call    Write
                movlw   130             ; LCD cm= 2 (+128)
                call    Write
		goto	Main_Loop
;-------------------------------------------------------------------------------
Nem_Nulla	movf	Prg_Szint,0	; programszint vizsglat
		xorlw	1
		btfss	STATUS,Z
		goto	Nem_Egy		
;-------------------------------------------------------------------------------
; Programszint=1
; ---------------
; K0 : kurzor lptets 		-> Programszint= 2
; K1 : ra lptets flfel
; K2 : 
; K3 : kilps   		-> Programszint= 0
;
Prgszint1	btfsc	Button,0	; K0 gomb van lenyomva?
		goto	Shift1		; igen, kurzor lptets
;-------------------------------------------------------------------------------
		btfsc	Button,1	; K1 gomb van lenyomva?
		goto	Ora_Inkrement	; igen, ra lptets
;-------------------------------------------------------------------------------
		btfss	Button,3	; K3 gomb van lenyomva?
		goto	Main_Loop	; nem
;-------------------------------------------------------------------------------
		bcf     PORTE,RS	; igen, kilps az ralltsbl
                movlw   H'0C'           ; Display on, blink off
                call    Write
		call	LCD_Write	; ra kijelzs
		clrf	Prg_Szint
		goto	Main_Loop
;-------------------------------------------------------------------------------
Shift1		movlw	2
		movwf	Prg_Szint	; programszint=2
		bcf     PORTE,RS	; cm
                movlw   133             ; LCD cm= 5 (+128)
                call    Write
		goto	Main_Loop
;-------------------------------------------------------------------------------
Ora_Inkrement	decfsz  Ora_Temp,1     	; az ra regiszter dekrementlsa
                goto    Ora_Inkr1    	; mg nem 0, folytats
;-------------------------------------------------------------------------------
                movlw	24	     	; ra regiszter korrekci
		movwf	Ora_Temp
Ora_Inkr1	bcf     PORTE,RS	; cm
                movlw   129             ; LCD cm= 1 (+128)
                call    Write
                bsf     PORTE,RS	; adat
		movf	Ora_Temp,0	; mdostott Ora_Temp regiszter kijelzse
		addlw	35
		call	Tabla1
                call    Write
		movf	Ora_Temp,0
		addlw	35
		call	Tabla0
                call    Write
		bcf     PORTE,RS	; cm
                movlw   130             ; kurzor cm
                call    Write
		clrf	Button_Temp	; billenty kd trls a bill. ismtlshez
		call	Kesl		; ismtlsi idlland belltsa
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		goto	Main_Loop
;-------------------------------------------------------------------------------
Nem_Egy		movf	Prg_Szint,0	; programszint vizsglat
		xorlw	2
		btfss	STATUS,Z
		goto	Nem_Ketto		
;-------------------------------------------------------------------------------
; Programszint=2
; ---------------
; K0 : kurzor lptets 		-> Programszint= 3
; K1 : perc lptets flfel
; K2 : 
; K3 : kilps   		-> Programszint= 0
;
Prgszint2	btfsc	Button,0	; K0 gomb van lenyomva?
		goto	Shift2		; igen, kurzor lptets
;-------------------------------------------------------------------------------
		btfsc	Button,1	; K1 gomb van lenyomva?
		goto	Perc_Inkrement	; igen
;-------------------------------------------------------------------------------
		btfss	Button,3	; K3 gomb van lenyomva?
		goto	Main_Loop	; nem
;-------------------------------------------------------------------------------
		bcf     PORTE,RS	; igen, kilps az ralltsbl
                movlw   0ch             ; Display on, blink off
                call    Write
		call	LCD_Write	; ra kijelzs
		clrf	Prg_Szint
		goto	Main_Loop	
;-------------------------------------------------------------------------------
Shift2		movlw	3
		movwf	Prg_Szint	; programszint=3
		bcf     PORTE,RS	; cm
                movlw   140	   	; LCD cm= 12 (+128)
                call    Write
		goto	Main_Loop
;-------------------------------------------------------------------------------
Perc_Inkrement	decfsz  Perc_Temp,1     ; a perc regiszter dekrementlsa
                goto    Perc_Inkr1    	; mg nem 0, folytats
;-------------------------------------------------------------------------------
                movlw	60	     	; perc regiszter korrekci
		movwf	Perc_Temp
Perc_Inkr1	bcf     PORTE,RS	; cm
                movlw   132             ; LCD cm= 4 (+128)
                call    Write
                bsf     PORTE,RS	; adat
		decf	Perc_Temp,0	; mdostott Perc_Temp regiszter kijelzse
		call	Tabla1
                call    Write
		decf	Perc_Temp,0
		call	Tabla0
                call    Write
		bcf     PORTE,RS	; cm
                movlw   133             ; kurzor cm
                call    Write
		clrf	Button_Temp	; billenty kd trls a bill. ismtlshez
		call	Kesl		; ismtlsi idlland belltsa
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		goto	Main_Loop
;-------------------------------------------------------------------------------
Nem_Ketto	movf	Prg_Szint,0	; programszint vizsglat
		xorlw	3
		btfss	STATUS,Z
		goto	Prgszint4		
;-------------------------------------------------------------------------------
; Programszint=3
; ---------------
; K0 : kurzor lptets 		-> Programszint= 4
; K1 : hnap lptets flfel
; K2 : 
; K3 : kilps   		-> Programszint= 0
;
Prgszint3	btfsc	Button,0	; K0 gomb van lenyomva?
		goto	Shift3		; igen, kurzor lptets
;-------------------------------------------------------------------------------
		btfsc	Button,1	; K1 gomb van lenyomva?
		goto	Honap_Inkr	; igen
;-------------------------------------------------------------------------------
		btfss	Button,3	; K3 gomb van lenyomva?
		goto	Main_Loop	; nem
;-------------------------------------------------------------------------------
		bcf     PORTE,RS	; igen, kilps az ralltsbl
                movlw   0ch             ; Display on, blink off
                call    Write
		clrf	Prg_Szint
		call	LCD_Write	; ra kijelzs
		goto	Main_Loop
;-------------------------------------------------------------------------------
Shift3		movlw	4
		movwf	Prg_Szint	; programszint=4
		bcf     PORTE,RS	; cm
                movlw   143	   	; LCD cm= 15 (+128)
                call    Write
		goto	Main_Loop
;-------------------------------------------------------------------------------
Honap_Inkr	decfsz  Honap_Temp,1	; a hnap regiszter dekrementlsa
                goto    Honap_Inkr1    	; mg nem 0, folytats
;-------------------------------------------------------------------------------
                movlw	12	     	; hnap regiszter korrekci
		movwf	Honap_Temp
Honap_Inkr1	bcf     PORTE,RS	; cm
                movlw   139             ; LCD cm= 11 (+128)
                call    Write
                bsf     PORTE,RS	; adat
		movf	Honap_Temp,0	; mdostott Honap_Temp regiszter kijelzse
		addlw	46
		call	Tabla1
                call    Write
		movf	Honap_Temp,0
		addlw	46
		call	Tabla0
                call    Write
		bcf     PORTE,RS	; cm
                movlw   140             ; kurzor cm
                call    Write
		clrf	Button_Temp	; billenty kd trls a bill. ismtlshez
		call	Kesl		; ismtlsi idlland belltsa
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		goto	Main_Loop
;-------------------------------------------------------------------------------
; Programszint=4
; ---------------
; K0 : kilps   		-> ENTER, Programszint= 0
; K1 : nap lptets flfel
; K2 :
; K3 : kilps   		-> Programszint= 0
;
Prgszint4	btfsc	Button,0	; K0 gomb van lenyomva?
		goto	Enter		; igen
;-------------------------------------------------------------------------------
		btfsc	Button,1	; K1 gomb van lenyomva?
		goto	Nap_Inkrement	; igen
;-------------------------------------------------------------------------------
		btfss	Button,3	; K3 gomb van lenyomva?
		goto	Main_Loop 
;-------------------------------------------------------------------------------
		bcf     PORTE,RS	; igen, kilps az ralltsbl
                movlw   0ch             ; Display on, blink off
                call    Write
		clrf	Prg_Szint
		call	LCD_Write	; ra kijelzs
		goto	Main_Loop
;-------------------------------------------------------------------------------
Enter		bcf	INTCON,GIE	; megszaktsok tiltsa
		btfsc	INTCON,GIE
		goto	Enter
;-------------------------------------------------------------------------------
; Temp regiszterek visszarsa a hnap, nap, ra, perc regiszterekbe (mp=0) 
		movf	Honap_Temp,0
		movwf	Honap
		movf	Nap_Temp,0
		movwf	Nap
		movf	Ora_Temp,0
		movwf	Ora
		movf	Perc_Temp,0
		movwf	Perc
		movlw	60
		movwf	Mp
		bsf	INTCON,GIE	; megszakts ismt engedlyezett
		bcf     PORTE,RS	
                movlw   0ch             ; Display on, kurzor off
                call    Write
		clrf	Prg_Szint	; programszint = 0
		call	LCD_Write	; ra kijelzs
		goto	Main_Loop
;-------------------------------------------------------------------------------
Nap_Inkrement	decfsz  Nap_Temp,1	; a hnap regiszter dekrementlsa
                goto    Nap_Inkr1    	; mg nem 0, folytats
;-------------------------------------------------------------------------------
                movf	Honap_Temp,0
                call    Honap_vege      ; hnap regiszter korrekci szksges
		movwf	Nap_Temp      	; W=hnap utols napja
Nap_Inkr1	bcf     PORTE,RS	; cm
                movlw   142             ; LCD cm= 14 (+128)
                call    Write
                bsf     PORTE,RS	; adat
		decf	Honap_Temp,0
		call	TablaShift
		movwf	Temp
		movf	Nap_Temp,0	; mdostott Nap_Temp regiszter kijelzse
		addwf	Temp,0
		call	Tabla1
                call    Write
		movf	Nap_Temp,0
		addwf	Temp,0
		call	Tabla0
                call    Write
		bcf     PORTE,RS	; cm
                movlw   143             ; kurzor cm
                call    Write
		clrf	Button_Temp	; billenty kd trls a bill. ismtlshez
		call	Kesl		; ismtlsi idlland belltsa
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		call	Kesl
		goto	Main_Loop
;===============================================================================
		end

