;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    RS232_HW.ASM                                      *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.1                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    RS-232 INTERFSZ KEZELSE A USART PORTTAL                        *
;    -----------------------------------------                        *
;    A program a 00h...FFh rtkek kztt vltoz Temp regiszter      *
;    tartalmt kldi ki a soros porton 9600 baud sebessggel.         *
;    A PIC16F87x USART portjt (HW) hasznlja.                        *
;    Az RS232 kommunikci adatformtuma: 9600-1-8-N-1.               *
;                                                                     *
;**********************************************************************
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;----------------------------------------------------------------------
;
Timer1		equ	32
Bit_Cntr	equ	33
Temp		equ	34
;----------------------------------------------------------------------
; PORTC bitek
;
TxData	equ	6
RxData	equ	7
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt szksges
;----------------------------------------------------------------------
; I/O port konfigurls
;
		bsf	STATUS,RP0	
		bcf	STATUS,RP1	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	1	      	; RA0 bemenet, RA1..5 kimenet
		movwf	TRISA
		movlw	B'10111111'	; RC6 kimenet (TxD)
		movwf	TRISC
;----------------------------------------------------------------------
; USART port programozsa aszinkron mdban
;
		movlw	129
		movwf	SPBRG
		movlw	B'00100100'	; TXEN=1, SYNC=0, BRGH=1
		movwf	TXSTA		;
		bcf	STATUS,RP0	; bank0 kivlaszts
		movlw	B'10010000'	; SPEN=1, CREN=1
		movwf	RCSTA		;
;----------------------------------------------------------------------
		clrf	Temp
Loop		incf	Temp,1
		movf	Temp,0		; Temp msolsa a USART port
		movwf	TXREG		; TXREG ads regiszterbe
Wait		btfss	PIR1,TXIF
		goto	Wait		; vr az ads befejezdsre
;----------------------------------------------------------------------
		bcf	PIR1,TXIF	; megszakts jelzbit trlse
		goto	Loop
;----------------------------------------------------------------------
		end

