;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    93LC56.ASM                                        *
;    Dtum:         2000.11.12.                                       *
;    Verziszm:    V1.2                                              *
;    #3                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    93LC56 MICROWIRE SOROS EEPROM KEZEL PROGRAM                     *
;    --------------------------------------------                     *
;                                                                     *
;    A Txtemp kezdcm, 16 byte mret RAM buffer tartalmt a 0x10   *
;    cmtl kezdden az EEPROM-ba msolja, majd az ugyanarrl a      *
;    cmtartomnyrl visszaolvasott adatokat a Txtemp kezdcm RAM   *
;    bufferbe rja.                                                   *
;    A szinkron soros port vonalait szoftveresen kezeli.              *
;                                                                     *
;**********************************************************************
;
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;----------------------------------------------------------------------
; PORTA kivezetsek
;
CS      	equ	2		; RA2, EEPROM Chip select, aktv H
;----------------------------------------------------------------------
; PORTC kivezetsek
;
SDO		equ	5		; RC5, EEPROM DI kivezetsre
SDI		equ	4		; RC4, EEPROM DO kivezetsre
CLK     	equ	3		; RC3, EEPROM CLK kivezetsre
;----------------------------------------------------------------------
; EEPROM utastskdok
;
ROP     	equ     192     	; OLVASS utastskd
WROP    	equ     160     	; RS utastskd
EWEN    	equ     152     	; TRLS s RS engedlyezs kd
EWDS    	equ	128     	; TRLS s RS letilts utastskd
;----------------------------------------------------------------------
;
Temp    	equ	32		; tmeneti trol az EE rutinokhoz
EE_data    	equ	33		; EEPROM adat (EEwrite, EEread)
EE_addr    	equ	34		; EEPROM cm (EEwrite, EEread)
Clocks    	equ	35		; rajel ciklus szmll
Counter		equ	36		; fprogram segdvltozja
;
Rxtemp		equ	48		; kiolvasott adatok kezdcme a RAM-ban
;
Txtemp		equ	64		; berand adatok cme a RAM-ban
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt
;----------------------------------------------------------------------
; Mikrovezrl port konfigurls
;
Start		bcf	STATUS,RP0	
		bcf	STATUS,RP1	; bank0 kivlaszts
		clrf	PORTA		; 
		clrf	PORTC		; EEPROM vonalak inaktvak
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111011'    	; RA2 kimenet
		movwf	TRISA
		movlw	B'11010111'	; RC3, RC5 kimenet
		movwf	TRISC
		bcf	STATUS,RP0	; bank0 kivlaszts
;----------------------------------------------------------------------
; A Txtemp kezdcm, 16 byte mret RAM buffer msolsa az EEPROM-ba 
;
	        call    Buffer_Load	; a RAM buffer feltltse
	        call    EEnable 	; EEPROM rs/trls engedlyezs
		movlw	16		; programozand rekeszek szma
		movwf	Counter
		movlw	16		; els EEPROM memriacm
		movwf	EE_addr
		movlw	Txtemp		; berand adatok kezdcme a RAM-ban
		movwf	FSR
;----------------------------------------------------------------------
Wrloop		movf	INDF,0		; adat msols indirekt cmzssel
		movwf	EE_data
		call    EEwrite 	; EEPROM rs
        	incf	FSR,1		; kvetkez adatmemria cm
        	incf	EE_addr,1	; EEPROM cm inkrementls
        	decfsz	Counter,1	; 16 EEPROM rekesz rs megtrtnt?
        	goto	Wrloop		; mg nem
;----------------------------------------------------------------------
	        call    EEdisbl 	; rs/trls tilts
;----------------------------------------------------------------------
; A Rxtemp kezdcm, 16 byte mret RAM buffer feltltse az EEPROM-bl
;
		movlw	16		; programozand rekeszek szma
		movwf	Counter
		movlw	16		; els EEPROM memriacm
		movwf	EE_addr
		movlw	Rxtemp		; kiolvasott adatok kezdcme a RAM-ban
		movwf	FSR
;----------------------------------------------------------------------
Rdloop		call    EEread		; EEPROM olvass
		movf	EE_data,0
		movwf	INDF		; indirekt adatmozgats a RAM-ba
		incf	FSR,1
		incf	EE_addr,1	; EEPROM cm inkrementls
		decfsz	Counter,1	; 16 EEPROM rekesz olvass megtrtnt?
		goto	Rdloop		; mg nem
;----------------------------------------------------------------------
		nop
Stop		goto	Stop		; vrakozs resetre
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- SZUBRUTINOK ----------------------------
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
; A RAM buffer feltltse
;
Buffer_Load	movlw	'0'
		movwf	Txtemp
		movlw	'1'
		movwf	Txtemp+1
		movlw	'2'
		movwf	Txtemp+2
		movlw	'3'
		movwf	Txtemp+3
		movlw	'4'
		movwf	Txtemp+4
		movlw	'5'
		movwf	Txtemp+5
		movlw	'6'
		movwf	Txtemp+6
		movlw	'7'
		movwf	Txtemp+7
		movlw	'8'
		movwf	Txtemp+8
		movlw	'9'
		movwf	Txtemp+9
		movlw	'A'
		movwf	Txtemp+10
		movlw	'B'
		movwf	Txtemp+11
		movlw	'C'
		movwf	Txtemp+12
		movlw	'D'
		movwf	Txtemp+13
		movlw	'E'
		movwf	Txtemp+14
		movlw	'F'
		movwf	Txtemp+15
        	return
;-----------------------------------------------------------------------
; EEPROM rs/trls engedlyezse
;
EEnable 	bsf     PORTA,CS	; EEPROM kivlasztsa
        	movlw	12     		; kilptetend bitek szma
		movwf	Clocks
        	movlw	EWEN       	; az engedlyezs kdjnak msolsa Temp-be
		movwf	Temp
        	call    Bitout       	; a kd kilptetse
        	bcf     PORTA,CS	; EEPROM kivlaszts megszntetse
        	return
;-----------------------------------------------------------------------
; EEPROM rs/trls letiltsa
;
EEdisbl 	bsf     PORTA,CS	; EEPROM kivlasztsa
        	movlw	12     		; kilptetend bitek szma
		movwf	Clocks
        	movlw	EWDS      	; az rs/trls tiltsi kd msolsa
		movwf	Temp
        	call    Bitout      	; a kd kilptetse
        	bcf     PORTA,CS	; EEPROM kivlaszts megszntetse
        	return
;-----------------------------------------------------------------------
; Egy bjt beolvassa az EEPROM EE_addr cm rekeszbl az EE_data vltozba
;
EEread  	movlw	ROP       	; az olvass kdjnak msolsa Temp-be
		movwf	Temp
        	movlw	4     		; kilptetend bitek szma
		movwf	Clocks
        	bsf     PORTA,CS	; EEPROM engedlyezse
        	call    Bitout       	; az olvass kd kilptetse
        	movlw	8    		; kilptetend bitek szma
		movwf	Clocks
		movf	EE_addr,0       ; az aktulis EEPROM cm msolsa Temp-be
		movwf	Temp
        	call    Bitout       	; a cm kilptetse
        	bcf	PORTC,SDO
        	movlw	8    		; a beolvasand bitek szma
		movwf	Clocks
Read    	bsf     PORTC,CLK	; CLK=1
		nop
	       	btfss	PORTC,SDI	; SDI bemenet msolsa a C bitbe
		bcf	STATUS,C
		btfsc	PORTC,SDI
		bsf	STATUS,C
        	rlf     EE_data,1	; C bit belptetse az EE_data regiszterbe
        	bcf     PORTC,CLK	; CLK=0
        	decfsz  Clocks,1	; az sszes bit beolvassa megtrtnt?
        	goto	Read		; mg nem
;-----------------------------------------------------------------------
	        bcf     PORTA,CS	; EEPROM kivlaszts megszntetse
        	return
;-----------------------------------------------------------------------
; Egy bjt bersa az EEPROM EE_addr cm rekeszbe
;
EEwrite 	movlw	WROP       	; az rs kdjnak msolsa Temp-be
		movwf	Temp
        	movlw	4    		; kilptetend bitek szma
		movwf	Clocks
        	bsf     PORTA,CS	; EEPROM engedlyezse
        	call    Bitout       	; az rs kd kilptetse
        	movlw	8    		; kilptetend bitek szma
		movwf	Clocks
        	movf	EE_addr,0       ; az aktulis EEPROM cm msolsa Temp-be
		movwf	Temp
        	call    Bitout       	; a cm kilptetse
       		movlw	8    		; kilptetend bitek szma
		movwf	Clocks
        	movf	EE_data,0	; az adat msolsa Temp-be
		movwf	Temp
        	call    Bitout       	; az adat kilptetse
        	bcf     PORTA,CS	; aktv L szint impulzus indtja az
	    	nop			; nidzts rsi folyamatot
		bsf	PORTA,CS
		nop
Busy    	btfss	PORTC,SDI	; vrakozs az rsi folyamat vgre
		goto	Busy
        	bcf     PORTA,CS	; EEPROM kivlaszts megszntetse
	        return
;-----------------------------------------------------------------------
; A Clocks regiszterben meghatrozott szm bit kilptetse az SDO vonalon
;
Bitout   	rlf     Temp,1    	; Temp regiszter 7. bitjnek kilptetse
		bcf	PORTC,SDO	; a Carry bitbe
		btfsc	STATUS,C	; C bit msolsa az SDO kimenet
		bsf	PORTC,SDO
		nop
        	bsf    	PORTC,CLK     	; CLK=1
        	nop
        	nop
        	nop
        	bcf	PORTC,CLK	; CLK=0
        	decfsz	Clocks,1	; az sszes bit kilptetse megtrtnt
		goto	Bitout		; mg nem
        	return
;-----------------------------------------------------------------------
		end
