;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    I2C.ASM                                           *
;    Dtum:         2000.11.18.                                       *
;    Verziszm:    V1.1                                              *
;    #5                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    24LC16B I2C SOROS EEPROM BYTE/PAGE R/OLVAS PROGRAM            *
;    -----------------------------------------------------            *
;    A 24LC16B EEPROM a mikrovezrl I2C zemmd szinkron soros      *
;    portjra csatlakozik.                                            *
;    A 0x123 cmtl kezdve 6 bjtot runk az EEPROM-ba.		      *
;    A 0x125 cm EEPROM rekesz tartalmt kiolvassa, majd a LED       *
;    soron kijelzi.						      *
;                                                                     *
;**********************************************************************
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;
;------------------------------------------------------------------------------
Slave           equ     B'10100000'     ; EEPROM I2C cme (B'1010xxxx')
;------------------------------------------------------------------------------
Addr_Lo         equ     32              ; EEPROM cm als bjt trolja
Addr_Hi         equ     33              ; EEPROM cm 3 fels bit trolja
Timer0          equ     34              ; ksleltets szmll als bjt
Timer1          equ     35              ; ksleltets szmll fels bjt
;------------------------------------------------------------------------------
; PORTC kivezetsek
;
; RC3: SCL - I2C soros rajel
; RC4: SDA - I2C be/kimeneti adat
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
;------------------------------------- FPROGRAM ------------------------------
;------------------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt
;------------------------------------------------------------------------------
; PORTA, PORTC, PORTD konfigurlsa
;
Start		bsf	STATUS,RP0	
		bcf	STATUS,RP1	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111111'    	; PORTA bemenet
		movwf	TRISA
		movlw	B'11111111'	; PORTC bemenet
		movwf	TRISC
		clrf	TRISD
;------------------------------------------------------------------------------
; Az I2C port konfigurlsa
;
		clrf	PIE1		; a perifria megszaktsok tiltsa 
		clrf	INTCON		;
		movlw	0x80 
		movwf	SSPSTAT		; slew rate vezrls tiltva
		movlw	0x31		; SSPADD=49
		movwf	SSPADD
		bcf	STATUS,RP0	; bank0 kivlaszts
		clrf	PORTD
		movlw	B'00101000'	; SSPEN=1, soros port engedlyezs
		movwf	SSPCON		; I2C master, Fosc/(4*(SSPADD+1))
		clrf	PIR1
;------------------------------------------------------------------------------
		movlw	0x01		; rs kezdcmnek belltsa
		movwf	Addr_Hi
		movlw	0x23
		movwf	Addr_Lo
;------------------------------------------------------------------------------
; EEPROM rs
;
EE_Write	bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,SEN	; start bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
                bcf	STATUS,C	; R/W bitet 0-ba lltja
                rlf	Addr_Hi,0	; Addr_Hi -> W
		addlw	Slave		; W= slave + cm hi + R/W
		movwf	SSPBUF
		call	Wait
		movf	Addr_Lo,0	; cm lo
		movwf	SSPBUF
		call	Wait
		movlw	0x12		; adat1
		movwf	SSPBUF
		call	Wait
		movlw	0x23		; adat2
		movwf	SSPBUF
		call	Wait
		movlw	0x34		; adat3
		movwf	SSPBUF
		call	Wait
		movlw	0x45		; adat4
		movwf	SSPBUF
		call	Wait
		movlw	0x56		; adat5
		movwf	SSPBUF
		call	Wait
		movlw	0x67		; adat6
		movwf	SSPBUF
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,PEN	; stop bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		call	Delay		; vrakozs az rs vgre (kb. 10ms)
;------------------------------------------------------------------------------
		movlw	0x01		; olvass cmnek belltsa
		movwf	Addr_Hi
		movlw	0x25
		movwf	Addr_Lo
;------------------------------------------------------------------------------
; EEPROM olvass
;
EE_Read		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,SEN	; start bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
                bcf	STATUS,C	; R/W bitet 0-ba lltja
                rlf	Addr_Hi,0	; Addr_Hi -> W
		addlw	Slave		; W= slave + cm hi + R/W
		movwf	SSPBUF
		call	Wait
		movf	Addr_Lo,0	; cm lo
		movwf	SSPBUF
		call	Wait
;------------------------------------------------------------------------------
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RSEN	; ismtelt start bit !!!
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
                bsf	STATUS,C	; R/W bitet 1-be lltja, olvass !!!!!!!!!
                rlf	Addr_Hi,0	; Addr_Hi -> W
		addlw	Slave		; W= slave + cm hi + R/W
		movwf	SSPBUF
		call	Wait

		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel engedlyezs
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0	; vett adat msolsa PORTD-re
		movwf	PORTD

		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,PEN	; stop bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait

Stop		goto	Stop		; resetre vrakozs
;------------------------------------------------------------------------------
Wait		btfss	PIR1,SSPIF	; SSPIF megszakts flagre vr
		goto	Wait
;------------------------------------------------------------------------------
		bcf	PIR1,SSPIF	; SSPIF flag trlse
                return
;------------------------------------------------------------------------------
Delay           movlw   70		; kb. 10ms ksleltets
                movwf   Timer1		
Delay1          decfsz  Timer0,1
                goto    Delay1
                decfsz  Timer1,1
                goto    Delay1
                return
;------------------------------------------------------------------------------
                end

