;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    KEYBOARD.ASM                                      *
;    Dtum:         2000.11.10.                                       *
;    Verziszm:    V1.2                                              *
;    #5                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    4X4-ES BILLENTYZET KEZEL PROGRAM                               *
;    ----------------------------------                               *
;    A LED soron a lenyomott billenty kdjt jeleniti meg.           *
;    0x10 kd jelentse: nincs  lenyomott billenty.                  *
;    A billentyzet sorainak vezrlst a PIC16F877 mikrovezrl      *
;    RB0...RB3 kivezetsei vgzik, mg a fggleges vezetkek         *
;    jeleinek beolvassa az RB4 s RB5, illetve az RA3 s RA5         *
;    kivezetsek feladata.                                            *
;    A portkivezetsek ilyen konfigurlsnak elnye, hogy egy        *
;    lenyomott billenty felbresztheti a SLEEP md mikrovezrlt.   *         
;                                                                     *
;**********************************************************************
;
;
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;-------------------------------------------------------------------------------
;
Timer1		equ	32	; ksleltet szubrutin szmllja, LO
Timer2		equ	33	; ksleltet szubrutin szmllja, HI
Rows            equ     34	; sor szmll
Key             equ     35	; billenty kd trolja
Temp		equ	36	; 
;-------------------------------------------------------------------------------
; PORTA s PORTB kivezetsek, melyek a billentyzetet olvassk
;
#define		Col1 	PORTB,4		; RB4
#define		Col2    PORTB,5		; RB5
#define		Col3    PORTA,3		; RA3
#define		Col4    PORTA,5		; RA5
;
;
;
;-------------------------------------------------------------------------------
;----------------------------- FPROGRAM ---------------------------------------
;-------------------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt
;-------------------------------------------------------------------------------
; PORTA, PORTB, PORTD konfigurlsa
;
		bcf	STATUS,RP0	
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'00111111'    	; PORTA bemenet
		movwf	TRISA
		movlw	B'11110000'    	; RB0..3 kimenet, RB4..7 bemenet
		movwf	TRISB
		clrf	TRISD		; PORTD kimenet
		bcf	OPTION_REG,NOT_RBPU	; felhz ellenllsok konfigurlsa
		bcf	STATUS,RP0	; bank0 kivlaszts
;-------------------------------------------------------------------------------
Start		call	Scan		; billentyzet vizsglata
		movf	Key,0		; lenyomott billenty kd -> W
		movwf	PORTD		; W -> PORTD
		call	Delay		; ksleltets
		goto	Start		; ismt
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;---------------------------- SZUBRUTINOK --------------------------------------
;-------------------------------------------------------------------------------
;
;
;-------------------------------------------------------------------------------
Delay		decfsz	Timer1,1	; ksleltet szubrutin
		goto	Delay
		decfsz	Timer2,1
		goto	Delay
		return
;-------------------------------------------------------------------------------
; 4x4-es billentyzet vizsglata.
; Ha lenyomott gombot tall, a szubrutin befejezdik, s a Key vltoz
; a billenty kdjt tartalmazza. Ha nincs lenyomott billenty, Key rtke
; 0x10 lesz. A szubrutin a billentyket egyenknt tapogatja le.
; A K0 jel nyomgombhoz Key=0, a K1-hez Key=1, a K2-hz Key=2, ... stb.
; mg vgl a K15 jel nyomgombhoz Key=15 rtk tartozik.
;
Scan            clrf    Key		; Key vltoz trlse
                movlw   4
                movwf   Rows		; 4 nyomgomb sor van
                movlw   14
                movwf   Temp		; Temp kezdeti rtke 14, gy
		goto	Scan1		; a B portra xxxx1110 kerl ki!
;-----------------------------------------------------------------------------
Scan0		bsf	STATUS,C
		rlf	Temp,1		; Carry belptetse a Temp regiszterbe
Scan1		movf	Temp,0
                movwf   PORTB		; Temp msolsa W-n keresztl PORTB-re
		nop
                btfss   Col1		; els oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                btfss   Col2		; 2. oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                btfss   Col3		; 3. oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                btfss   Col4		; 4. oszlopban van-e lenyomott gomb?
                goto    Press		; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
                incf    Key,1		; billenty kd inkrementls
                decfsz  Rows,1		; sor szmll cskkents
                goto    Scan0		; mg nem vizsgltunk meg mind a 4 sort
;-----------------------------------------------------------------------------
Press           return
;-----------------------------------------------------------------------------
		end                   	

