;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    RS5C372.ASM                                       *
;    Dtum:         2001.02.04.                                       *
;    Verziszm:    V1.1                                              *
;    #3                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    RS5C372A RAMODUL KEZEL PROGRAM                                 *
;    --------------------------------                                 *
;                                                                     *
;    1. Az ramodult az albbiak szerint programozza fel:             *
;       - 32,768 kHz kristly frekvencia kivlaszts (default),       *
;       - rjel megjenenik az INTRB kivezetsen (default),            *
;       - 24 rs zemmd,                                            *
;       - id: 12:00:00,                                              *
;       - dtum: (20)01-02-04.                                        *
;                                                                     *
;    2. Kb. 0,5 msodpercenknt lekrdezi az idt, s az LCD          *
;       modulon kijelzi.                                              *
;                                                                     *
;**********************************************************************
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;
;------------------------------------------------------------------------------
Slave           equ     B'01100100'     ; ra modul slave cme
;------------------------------------------------------------------------------
Timer1          equ     32              ; ksleltets szmll als bjt
Timer2          equ     33              ; ksleltets szmll fels bjt
Sec		equ	34              ; tmeneti regiszterek
Min		equ	35
Hour		equ	36
Day_of_week	equ	37
Day		equ	38
Month		equ	39
Year		equ	40
Timer3          equ     41
;------------------------------------------------------------------------------
; PORTC kivezetsek
;
SCL             equ     3               ; RC3, I2C soros rajel
SDA             equ     4               ; RC4, I2C be/kimeneti adat
;------------------------------------------------------------------------------
; PORTE kivezetsek
;
RS              equ     0               ; 0= utasts, 1= adat reg. vlaszts
RdWr		equ	1		; R/W=0 LCD rs, R/W=1 LCD memria olvass
E               equ     2               ; 0= LCD tilts, 1= engedlyezs
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
;********************************* FPROGRAM **********************************
;------------------------------------------------------------------------------
;
		org     0             	; reset vektor
		nop			; MPLAB-ICD miatt
;==============================================================================
; Port bellts
;
Start		bcf	STATUS,RP1	
		bcf	STATUS,RP0	; bank0 kivlaszts
	        clrf    PORTD
                clrf    PORTE
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111111'
		movwf	TRISA    	; PORTA bemenet
		movlw	B'11111111'
		movwf	TRISC		; PORTC bemenet
		clrf	TRISD		; PORTD kimenet
		clrf	TRISE		; PORTE kimenet
;------------------------------------------------------------------------------
; Az I2C port konfigurlsa
;
		clrf	PIE1		; a perifria megszaktsok tiltsa 
		clrf	INTCON		;
		movlw	0x80 
		movwf	SSPSTAT		; slew rate vezrls tiltva
		movlw	0x31		; SSPADD=49
		movwf	SSPADD
		bcf	STATUS,RP0	; bank0 kivlaszts
		clrf	PORTD
		movlw	B'00101000'	; SSPEN=1, soros port engedlyezs
		movwf	SSPCON		; I2C master, Fosc/(4*(SSPADD+1))
		clrf	PIR1
;------------------------------------------------------------------------------
; LCD kijelz inicializlsa 
;
		call	Delay		
	        bcf	PORTE,RS	; LCD parancs kvetkezik
		movlw   H'38'           ; 8 bites interfsz, 2 sor
                call    Write
                call    Delay2		; Busy flag olvasst "helyettesti"
                movlw   H'38'
                call    Write
                movlw   6               ; 06h, Entry mode set: increment
                call    Write
                movlw   12              ; 0ch, Display on, blink off
                call    Write
                movlw   16              ; 10h, Display/cursor shift: cursor
                call    Write
                movlw   1               ; 01h, Display clear
                call    Write
                call    Delay2		; Busy flag olvasst "helyettesti"
;------------------------------------------------------------------------------
; RA MODUL rs
;
Clock_Write	bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,SEN	; start bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movlw	Slave		; W= slave + R/W (=0)
		movwf	SSPBUF
		call	Wait
		movlw	0xF0		; kezdcm= 0Fh, tv. formtum reg.= 0
		movwf	SSPBUF
		call	Wait
		movlw	0x20		; CONTROL2 regiszter rs, 24 rs zemmd
		movwf	SSPBUF
		call	Wait
		movlw	0x00		; SEC regiszter rs
		movwf	SSPBUF
		call	Wait
		movlw	0x00		; MIN regiszter rs
		movwf	SSPBUF
		call	Wait
		movlw	0x12		; HOUR regiszter rs
		movwf	SSPBUF
		call	Wait
		movlw	0x00		; DAY OF WEEK regiszter rs (=vasrnap !)
		movwf	SSPBUF
		call	Wait
		movlw	0x04		; DAY regiszter rs
		movwf	SSPBUF
		call	Wait
		movlw	0x02		; MONTH regiszter rs
		movwf	SSPBUF
		call	Wait
		movlw	0x01		; YEAR regiszter rs (2001)
		movwf	SSPBUF
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,PEN	; stop bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		call	Delay		; vrakozs az rs vgre (kb. 10ms)
;------------------------------------------------------------------------------
; RA MODUL olvass
;
Clock_Read	bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,SEN	; start bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movlw	Slave		; W= slave + R/W (=0)
		movwf	SSPBUF
		call	Wait
		movlw	0x00		; SEC regiszter cme
		movwf	SSPBUF
		call	Wait
;------------------------------------------------------------------------------
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RSEN	; ismtelt start bit !!!
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movlw	Slave
		addlw	1		; W= slave + R/W (=1), olvass !
		movwf	SSPBUF
		call	Wait
;------------------------------------------------------------------------------
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel engedlyezs
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Sec		; vett adat msolsa SEC regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,ACKEN	; acknowledge bit generls
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel ismtelt engedlyezse
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Min		; vett adat msolsa MIN regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,ACKEN	; acknowledge bit generls
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel ismtelt engedlyezse
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Hour		; vett adat msolsa HOUR regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,ACKEN	; acknowledge bit generls
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel ismtelt engedlyezse
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Day_of_week	; vett adat msolsa DAY OF WEEK regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,ACKEN	; acknowledge bit generls
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel ismtelt engedlyezse
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Day		; vett adat msolsa DAY regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,ACKEN	; acknowledge bit generls
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel ismtelt engedlyezse
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Month		; vett adat msolsa MONTH regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,ACKEN	; acknowledge bit generls
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,RCEN	; vtel ismtelt engedlyezse
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
		movf	SSPBUF,0
		movwf	Year		; vett adat msolsa YEAR regiszterbe
		bsf	STATUS,RP0	; bank1 kivlaszts
		bsf	SSPCON2,PEN	; stop bit
		bcf	STATUS,RP0	; bank0 kivlaszts
		call	Wait
;------------------------------------------------------------------------------
; Dtum s id kiirats az LCD kijelzn
;
LCD_Write	bcf     PORTE,RS	; cm
                movlw   129             ; LCD cm= 1 (+128, els sor)
                call    Write
                bsf     PORTE,RS	; adat
		movlw	'2'
                call    Write
		movlw	'0'
                call    Write
		swapf	Year,0
		andlw	15
		addlw	48
                call    Write		; v tizesek kiiratsa
		movf	Year,0
		andlw	15
		addlw	48
                call    Write		; v egyesek kiiratsa
		movlw	'-'
                call    Write
		swapf	Month,0
		andlw	15
		addlw	48
                call    Write		; hnap tizesek kiiratsa
		movf	Month,0
		andlw	15
		addlw	48
                call    Write		; hnap egyesek kiiratsa
		movlw	'-'
                call    Write
		swapf	Day,0
		andlw	15
		addlw	48
                call    Write		; nap tizesek kiiratsa
		movf	Day,0
		andlw	15
		addlw	48
                call    Write		; nap egyesek kiiratsa
		bcf     PORTE,RS	; cm
                movlw   193             ; LCD cm= 1 (+192, msodik sor)
                call    Write
                bsf     PORTE,RS	; adat
		swapf	Hour,0
		andlw	15
		addlw	48
                call    Write		; ra tizesek kiiratsa
		movf	Hour,0
		andlw	15
		addlw	48
                call    Write		; ra egyesek kiiratsa
		movlw	':'
                call    Write
		swapf	Min,0
		andlw	15
		addlw	48
                call    Write		; perc tizesek kiiratsa
		movf	Min,0
		andlw	15
		addlw	48
                call    Write		; perc egyesek kiiratsa
		movlw	':'
                call    Write
		swapf	Sec,0
		andlw	15
		addlw	48
                call    Write		; msodperc tizesek kiiratsa
		movf	Sec,0
		andlw	15
		addlw	48
                call    Write		; msodperc egyesek kiiratsa
		call	Delay05

		goto	Clock_Read	; kb. 0,5 mp mlva jabb olvass
;==============================================================================
;
;
;
;------------------------------------------------------------------------------
;******************************* SZUBRUTINOK **********************************
;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------
Wait		btfss	PIR1,SSPIF	; SSPIF megszakts flagre vr
		goto	Wait
;------------------------------------------------------------------------------
		bcf	PIR1,SSPIF	; SSPIF flag trlse
                return
;------------------------------------------------------------------------------
Delay           movlw   70		; kb. 10ms ksleltets
                movwf   Timer2		
Delay1          decfsz  Timer1,1
                goto    Delay1
                decfsz  Timer2,1
                goto    Delay1
                return
;------------------------------------------------------------------------------
; LCD rs lpsei:
; -----------------
;   1/   RS, R/W belltsa
;   2/   E=1
;   3/   adat kiklds
;   4/   ksleltets (100us)
;   5/   E=0
;
Write           movwf   PORTD
		bsf     PORTE,E
                call    Delay100	; Busy flag olvasst "helyettesti"
                bcf     PORTE,E
                return
;-------------------------------------------------------------------------------
Delay100        movlw   165		; 100us ksleltets
                movwf   Timer1
Del11		decfsz  Timer1,1
                goto    Del11
                return
;-------------------------------------------------------------------------------
Delay2          clrf    Timer1		; 2ms ksleltets
                movlw	20
		movwf   Timer2
Del21           call	Delay100
                decfsz  Timer2,1
                goto    Del21
                return
;-------------------------------------------------------------------------------
Delay05		movlw	50		; kb. 0,5 mp ksleltets
		movwf   Timer3
Del31           call	Delay
                decfsz  Timer3,1
                goto    Del31
                return
;-------------------------------------------------------------------------------
                end

