;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       I2C_18.ASM                                        *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    24LC16B I2C SOROS EEPROM BYTE/PAGE R/OLVAS PROGRAM            *
;    -----------------------------------------------------            *
;    A 24LC16B EEPROM a mikrovezrl I2C zemmd szinkron soros      *
;    portjra csatlakozik.                                            *
;    A 0x123 cmtl kezdve 6 bjtot runk az EEPROM-ba.               *
;    A 0x125 cm EEPROM rekesz tartalmt kiolvassa, majd a LED       *
;    soron kijelzi.                                                   *
;                                                                     *
;**********************************************************************
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;
;------------------------------------------------------------------------------
Slave           equ     B'10100000'             ; EEPROM I2C cme (B'1010xxxx')
;------------------------------------------------------------------------------
        CBLOCK
Addr_Lo                                         ; EEPROM cm als bjt trolja
Addr_Hi                                         ; EEPROM cm 3 fels bit trolja
Timer0                                          ; ksleltets szmll als bjt
Timer1                                          ; ksleltets szmll fels bjt
        ENDC
;------------------------------------------------------------------------------
; PORTC kivezetsek
;
; RC3: SCL - I2C soros rajel
; RC4: SDA - I2C be/kimeneti adat
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
;------------------------------------- FPROGRAM ------------------------------
;------------------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;------------------------------------------------------------------------------
; PORTA, PORTC, PORTD konfigurlsa
;
Start
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            setf    TRISA                       ; PORTA bemenet
            setf    TRISC                       ; PORTC bemenet
            clrf    TRISD                       ; PORTD kimenet
;------------------------------------------------------------------------------
; Az I2C port konfigurlsa
;
            clrf    PIE1                        ; a perifria megszaktsok tiltsa
            clrf    INTCON
            movlw   0x80
            movwf   SSPSTAT                     ; slew rate vezrls tiltva
            movlw   0x31                        ; SSPADD=49
            movwf   SSPADD
            clrf    PORTD
            movlw   B'00101000'                 ; SSPEN=1, soros port engedlyezs
            movwf   SSPCON1                     ; I2C master, Fosc/(4*(SSPADD+1))
            clrf    PIR1
;------------------------------------------------------------------------------
            movlw   0x01                        ; rs kezdcmnek belltsa
            movwf   Addr_Hi
            movlw   0x23
            movwf   Addr_Lo
;------------------------------------------------------------------------------
; EEPROM rs
;
EE_Write
            bsf     SSPCON2,SEN                 ; start bit
            rcall   Wait
            bcf     STATUS,C                    ; R/W bitet 0-ba lltja
            rlcf    Addr_Hi,0                   ; Addr_Hi -> W
            addlw   Slave                       ; W= slave + cm hi + R/W
            movwf   SSPBUF
            rcall   Wait
            movff   Addr_Lo, SSPBUF             ; cm LOW
            rcall   Wait
            movlw   0x12                        ; adat1
            movwf   SSPBUF
            rcall   Wait
            movlw   0x23                        ; adat2
            movwf   SSPBUF
            rcall   Wait
            movlw   0x34                        ; adat3
            movwf   SSPBUF
            rcall   Wait
            movlw   0x45                        ; adat4
            movwf   SSPBUF
            rcall   Wait
            movlw   0x56                        ; adat5
            movwf   SSPBUF
            rcall   Wait
            movlw   0x67                        ; adat6
            movwf   SSPBUF
            rcall   Wait
            bsf     SSPCON2,PEN                 ; stop bit
            rcall   Wait
            rcall   Delay                       ; vrakozs az rs vgre (kb. 10ms)
;------------------------------------------------------------------------------
            movlw   0x01                        ; olvass cmnek belltsa
            movwf   Addr_Hi
            movlw   0x25
            movwf   Addr_Lo
;------------------------------------------------------------------------------
; EEPROM olvass
;
EE_Read
            bsf     SSPCON2,SEN                 ; start bit
            rcall   Wait
            bcf     STATUS,C                    ; R/W bitet 0-ba lltja
            rlcf    Addr_Hi,0                   ; Addr_Hi -> W
            addlw   Slave                       ; W= slave + cm hi + R/W
            movwf   SSPBUF
            rcall   Wait
            movff   Addr_Lo, SSPBUF             ; cm lo
            rcall   Wait
;------------------------------------------------------------------------------
            bsf     SSPCON2,RSEN                ; ismtelt start bit !!!
            rcall   Wait
            bsf     STATUS,C                    ; R/W bitet 1-be lltja, olvass !!!!!!!!!
            rlcf    Addr_Hi,0                   ; Addr_Hi -> W
            addlw   Slave                       ; W= slave + cm hi + R/W
            movwf   SSPBUF
            rcall   Wait

            bsf     SSPCON2,RCEN                ; vtel engedlyezs
            rcall   Wait
            movff   SSPBUF, LATD                ; vett adat msolsa PORTD-re

            bsf     SSPCON2,PEN                 ; stop bit
            rcall   Wait

Stop
            bra     Stop                        ; resetre vrakozs
;------------------------------------------------------------------------------
Wait
            btfss   PIR1,SSPIF                  ; SSPIF megszakts flagre vr
            bra     Wait
;------------------------------------------------------------------------------
            bcf     PIR1,SSPIF                  ; SSPIF flag trlse
            return
;------------------------------------------------------------------------------
Delay
            movlw   70                          ; kb. 10ms ksleltets
            movwf   Timer1
Delay1
            decfsz  Timer0,1
            bra     Delay1
            decfsz  Timer1,1
            bra     Delay1
            return
;------------------------------------------------------------------------------
        end
