;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       RS232H18.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    RS-232 INTERFSZ KEZELSE A USART PORTTAL                        *
;    -----------------------------------------                        *
;    A program a 00h...FFh rtkek kztt vltoz Temp regiszter      *
;    tartalmt kldi ki a soros porton 9600 baud sebessggel.         *
;    A PIC18F442 USART portjt (HW) hasznlja.                        *
;    Az RS232 kommunikci adatformtuma: 9600-1-8-N-1.               *
;                                                                     *
;**********************************************************************
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;----------------------------------------------------------------------
;
        CBLOCK
Timer1
Bit_Cntr
Temp
        ENDC
;----------------------------------------------------------------------
; PORTC bitek
;
        #define TxData          6
        #define RxData          7
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
                nop                             ; MPLAB-ICD miatt
        #endif            
;----------------------------------------------------------------------
; I/O port konfigurls
;
                movlw   14
                movwf   ADCON1                  ; RA0 analg bemenet !!!
                movlw   1                       ; RA0 bemenet, RA1..5 kimenet
                movwf   TRISA
                movlw   B'10111111'             ; RC6 kimenet (TxD)
                movwf   TRISC
;----------------------------------------------------------------------
; USART port programozsa aszinkron mdban
;
                movlw   B'10100100'             ;initialize USART
                movwf   TXSTA                   ;8-bit, Async, High Speed
                movlw   .129
                movwf   SPBRG                   ;9.6kbaud @ 20MHz
                movlw   B'10010000'
                movwf   RCSTA
;----------------------------------------------------------------------
                clrf    Temp
Loop            incf    Temp,1
                movf    Temp,0                  ; Temp msolsa a USART port
                movwf   TXREG                   ; TXREG ads regiszterbe
Wait            btfss   PIR1,TXIF
                goto    Wait                    ; vr az ads befejezdsre
;----------------------------------------------------------------------
                bcf     PIR1,TXIF               ; megszakts jelzbit trlse
                goto    Loop
;----------------------------------------------------------------------
        end
