; *******************************************************************
;        Software License Agreement
;
; The software supplied herewith by Microchip Technology Incorporated
; (the Company) for its PICmicro Microcontroller is intended and
; supplied to you, the Companys customer, for use solely and
; exclusively on Microchip PICmicro Microcontroller products. The
; software is owned by the Company and/or its supplier, and is
; protected under applicable copyright laws. All rights are reserved.
;  Any use in violation of the foregoing restrictions may subject the
; user to criminal sanctions under applicable laws, as well as to
; civil liability for the breach of the terms and conditions of this
; license.
;
; THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *******************************************************************

; *******************************************************************
        Title   "16/32 bit Integer Square Root"
; *******************************************************************

; *******************************************************************
; ***                                                             ***
; ***   Author: Ross Fosler                                       ***
; ***           Applications Engineer                             ***
; ***           Microchip Technology Inc.                         ***
; ***                                                             ***
; ***  Program: sqrt.asm                                          ***
; ***           This module contains code to perform fast integer ***
; ***           square root functions on either 16 or 32 bit      ***
; ***           values.                                           ***
; ***                                                             ***
; *** Last Rev: August 10, 2000                                   ***
; ***           Ver 1.00                                          ***
; ***                                                             ***
; *******************************************************************

; *******************************************************************
        #include P18C252.INC
; *******************************************************************

; *******************************************************************
MSB     equ     7       ; general literal constants
LSB     equ     0
W       equ     0
F       equ     1
a       equ     0
; *******************************************************************

; *******************************************************************
SimpMth UDATA_ACS

ARGA0   res     1       ; various argument registers
ARGA1   res     1
ARGA2   res     1
ARGA3   res     1

        GLOBAL  ARGA0, ARGA1, ARGA2, ARGA3

ARG1H   res     1
ARG1L   res     1
ARG2H   res     1
ARG2L   res     1

        GLOBAL  ARG1H, ARG1L, ARG2H, ARG2L

SARG1   res     1       ; signed arguments
SARG2   res     1

        GLOBAL  SARG1, SARG2

RES1    res     1       ; result registers
RES0    res     1

        GLOBAL  RES0, RES1

SQRES0  res     1
SQRES1  res     1
SQRES2  res     1
SQRES3  res     1

        GLOBAL SQRES0, SQRES1, SQRES2, SQRES3

BITLOC0 res     1       ; temporary registers
BITLOC1 res     1
TEMP0   res     1
TEMP1   res     1
; *******************************************************************

; *******************************************************************
; The function of this square root routine is to determine the root
; to the nearest integer.  At the same time the root is found at the
; best possible speed; therefore, the root is found a little differently
; for the two basic sizes of numbers, 16-bit and 32-bit.  The following
; differentiates the two and jumps to the appropriate function.

; Sqrt(ARGA3:ARGA2:ARGA1:ARGA0) = RES1:RES0

S_ROOT  CODE

Sqrt    tstfsz  ARGA3, a        ; determine if the number is 16-bit
        bra     Sqrt32          ;  or 32-bit and call the best function
        tstfsz  ARGA2, a
        bra     Sqrt32
        clrf    RES1, a
        bra     Sqrt16

        GLOBAL  Sqrt
; *******************************************************************

; ******************** Square Root **********************************
;  Sqrt16(ARGA1:ARGA0) = RES0

Sqrt16  clrf    TEMP0, a        ; clear the temp solution
        movlw   0x80            ; setup the first bit
        movwf   BITLOC0, a
        movwf   RES0, a

Square8 movf    RES0, W, a      ; square the guess
        mulwf   RES0, a

        movf    PRODL, W, a     ; ARGA - PROD  test
        subwf   ARGA0, W, a
        movf    PRODH, W, a
        subwfb  ARGA1, W, a

        btfsc   STATUS, C, a
        bra     NextBit         ; if positive then next bit
                                ; if negative then rotate right

        movff   TEMP0, RES0     ; move last good value back into RES0
        rrncf   BITLOC0, F, a   ; then rotote the bit and put it
        movf    BITLOC0, W, a   ; back into RES0
        iorwf   RES0, F, a

        btfsc   BITLOC0, 7, a   ; if last value was tested then get
        bra     Done            ; out

        bra     Square8         ; elso go back for another test

NextBit movff   RES0, TEMP0     ; copy the last good approximation
        rrncf   BITLOC0, F, a   ; rotate the bit location register
        movf    BITLOC0, W, a
        iorwf   RES0, F, a

        btfsc   BITLOC0, 7, a   ; if last value was tested then get
        bra     Done            ; out

        bra     Square8

Done    movff   TEMP0,RES0      ; put the final result in RES0
        return

        GLOBAL  Sqrt16
; *******************************************************************

; ******************** Square Root **********************************
;  Sqrt32(ARGA3:ARGA2:ARGA1:ARGA0) = RES1:RES0

Sqrt32  clrf    TEMP0, a        ; clear the temp solution
        clrf    TEMP1, a
        clrf    BITLOC0, a      ; setup the first bit
        clrf    RES0, a
        movlw   0x80
        movwf   BITLOC1, a      ; BitLoc = 0x8000
        movwf   RES1, a         ; RES = 0x8000

Squar16 movff   RES0, ARG1L     ; square the guess
        movff   RES1, ARG1H
        call    Sq16

        movf    SQRES0, W, a    ; ARGA - PROD  test
        subwf   ARGA0, W, a
        movf    SQRES1, W, a
        subwfb  ARGA1, W, a
        movf    SQRES2, W, a
        subwfb  ARGA2, W, a
        movf    SQRES3, W, a
        subwfb  ARGA3, W, a

        btfsc   STATUS, C, a
        bra     NxtBt16         ; if positive then next bit
                                ; if negative then rotate right

        addlw   0x00            ; clear carry
        movff   TEMP0, RES0     ; move last good value back into RES0
        movff   TEMP1, RES1

        rrcf    BITLOC1, F, a   ; then rotote the bit and put it
        rrcf    BITLOC0, F, a
        movf    BITLOC1, W, a   ; back into RES1:RES0
        iorwf   RES1, F, a
        movf    BITLOC0, W, a
        iorwf   RES0, F, a

        btfsc   STATUS, C, a    ; if last value was tested then get
        bra     Done32          ; out

        bra     Squar16         ; elso go back for another test

NxtBt16 addlw   0x00            ; clear carry
        movff   RES0, TEMP0     ; copy the last good approximation
        movff   RES1, TEMP1

        rrcf    BITLOC1, F, a   ; rotate the bit location register
        rrcf    BITLOC0, F, a
        movf    BITLOC1, W, a   ; and put back into RES1:RES0
        iorwf   RES1, F, a
        movf    BITLOC0, W, a
        iorwf   RES0, F, a

        btfsc   STATUS, C, a    ; if last value was tested then get
        bra     Done32          ; out

        bra     Squar16

Done32  movff   TEMP0,RES0      ; put the final result in RES1:RES0
        movff   TEMP1,RES1
        return

        GLOBAL  Sqrt32
; *******************************************************************

; *********** 16 X 16 Unsigned Square *****************************
; SQRES3:SQRES0 = ARG1H:ARG1L ^2


Sq16    movf    ARG1L, W, a
        mulwf   ARG1L                   ; ARG1L * ARG2L ->
                                        ; PRODH:PRODL
        movff   PRODH, SQRES1           ;
        movff   PRODL, SQRES0           ;

        movf    ARG1H, W, a
        mulwf   ARG1H                   ; ARG1H * ARG2H ->
                                        ; PRODH:PRODL
        movff   PRODH, SQRES3           ;
        movff   PRODL, SQRES2           ;

        movf    ARG1L, W, a
        mulwf   ARG1H                   ; ARG1L * ARG2H ->
                                        ; PRODH:PRODL
        movf    PRODL, W, a             ;
        addwf   SQRES1, F, a            ; Add cross
        movf    PRODH, W, a             ; products
        addwfc  SQRES2, F, a            ;
        clrf    WREG, a                 ;
        addwfc  SQRES3, F, a            ;

        movf    ARG1H, W, a             ;
        mulwf   ARG1L                   ; ARG1H * ARG2L ->
                                        ; PRODH:PRODL
        movf    PRODL, W, a             ;
        addwf   SQRES1, F, a            ; Add cross
        movf    PRODH, W, a             ; products
        addwfc  SQRES2, F, a            ;
        clrf    WREG, W                 ;
        addwfc  SQRES3, F, a            ;

        return

        GLOBAL  Sq16
; *******************************************************************

        end

